/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.GotoFileAction;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereDataKeys;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoFileConfiguration;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.ui.IdeUICustomization;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSearchEverywhereContributor
extends AbstractGotoSEContributor<FileType> {
    private final GotoFileModel myModelForRenderer;

    public FileSearchEverywhereContributor(@Nullable Project project, @Nullable PsiElement context) {
        super(project, context);
        this.myModelForRenderer = project == null ? null : new GotoFileModel(project);
    }

    @NotNull
    public String getGroupName() {
        return "Files";
    }

    public String includeNonProjectItemsText() {
        return IdeBundle.message((String)"checkbox.include.non.project.files", (Object[])new Object[]{IdeUICustomization.getInstance().getProjectConceptName()});
    }

    public int getSortWeight() {
        return 200;
    }

    @Override
    public int getElementPriority(@NotNull Object element, @NotNull String searchPattern) {
        return super.getElementPriority(element, searchPattern) + 2;
    }

    @Override
    @NotNull
    protected FilteringGotoByModel<FileType> createModel(@NotNull Project project) {
        return new GotoFileModel(project);
    }

    @Override
    @NotNull
    public ListCellRenderer getElementsRenderer(@NotNull JList<?> list2) {
        return new AbstractGotoSEContributor.SERenderer(list2){

            @Override
            @NotNull
            protected PsiElementListCellRenderer.ItemMatchers getItemMatchers(@NotNull JList list2, @NotNull Object value) {
                PsiElementListCellRenderer.ItemMatchers defaultMatchers = super.getItemMatchers(list2, value);
                if (!(value instanceof PsiFileSystemItem) || FileSearchEverywhereContributor.this.myModelForRenderer == null) {
                    return defaultMatchers;
                }
                return GotoFileModel.convertToFileItemMatchers(defaultMatchers, (PsiFileSystemItem)value, FileSearchEverywhereContributor.this.myModelForRenderer);
            }
        };
    }

    @Override
    public boolean processSelectedItem(@NotNull Object selected, int modifiers, @NotNull String searchText) {
        VirtualFile file2;
        if (selected instanceof PsiFile && (file2 = ((PsiFile)selected).getVirtualFile()) != null && this.myProject != null) {
            Pair<Integer, Integer> pos = FileSearchEverywhereContributor.getLineAndColumn(searchText);
            OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, file2, ((Integer)pos.first).intValue(), ((Integer)pos.second).intValue());
            descriptor.setUseCurrentWindow(FileSearchEverywhereContributor.openInCurrentWindow(modifiers));
            if (descriptor.canNavigate()) {
                descriptor.navigate(true);
                return true;
            }
        }
        return super.processSelectedItem(selected, modifiers, searchText);
    }

    @Override
    public Object getDataForItem(@NotNull Object element, @NotNull String dataId) {
        if (CommonDataKeys.PSI_FILE.is(dataId) && element instanceof PsiFile) {
            return element;
        }
        if (SearchEverywhereDataKeys.ITEM_STRING_DESCRIPTION.is(dataId) && element instanceof PsiFile) {
            String basePath;
            String path = ((PsiFile)element).getVirtualFile().getPath();
            path = FileUtil.toSystemIndependentName((String)path);
            if (this.myProject != null && (basePath = this.myProject.getBasePath()) != null) {
                path = FileUtil.getRelativePath((String)basePath, (String)path, (char)'/');
            }
            return path;
        }
        return super.getDataForItem(element, dataId);
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<FileType> {
        @NotNull
        public SearchEverywhereContributor<FileType> createContributor(AnActionEvent initEvent) {
            return new FileSearchEverywhereContributor(initEvent.getProject(), GotoActionBase.getPsiContext(initEvent));
        }

        @Nullable
        public SearchEverywhereContributorFilter<FileType> createFilter(AnActionEvent initEvent) {
            Project project = initEvent.getProject();
            if (project == null) {
                return null;
            }
            List items = Stream.of(FileTypeManager.getInstance().getRegisteredFileTypes()).sorted(GotoFileAction.FileTypeComparator.INSTANCE).collect(Collectors.toList());
            return new PersistentSearchEverywhereContributorFilter<FileType>(items, GotoFileConfiguration.getInstance(project), FileType::getName, FileType::getIcon);
        }
    }
}

