/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.actions.searcheverywhere.SEResultsEqualityProvider;
import com.intellij.ide.actions.searcheverywhere.SESearcher;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class MultiThreadSearcher
implements SESearcher {
    private static final Logger LOG = Logger.getInstance(MultiThreadSearcher.class);
    @NotNull
    private final SESearcher.Listener myListener;
    @NotNull
    private final Executor myNotificationExecutor;
    @NotNull
    private final SEResultsEqualityProvider myEqualityProvider;

    MultiThreadSearcher(@NotNull SESearcher.Listener listener2, @NotNull Executor notificationExecutor, @NotNull Collection<? extends SEResultsEqualityProvider> equalityProviders) {
        this.myListener = listener2;
        this.myNotificationExecutor = notificationExecutor;
        this.myEqualityProvider = SEResultsEqualityProvider.composite(equalityProviders);
    }

    @Override
    public ProgressIndicator search(@NotNull Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, @NotNull String pattern, boolean useNonProjectItems, @NotNull Function<? super SearchEverywhereContributor<?>, ? extends SearchEverywhereContributorFilter<?>> filterSupplier) {
        ProgressIndicatorBase indicator;
        FullSearchResultsAccumulator accumulator;
        LOG.debug("Search started for pattern [", new Object[]{pattern, "]"});
        Collection<Object> contributors = contributorsAndLimits.keySet();
        if (pattern.isEmpty()) {
            contributors = ApplicationManager.getApplication().isUnitTestMode() ? Collections.emptySet() : ContainerUtil.filter(contributors, contributor -> contributor.isEmptyPatternSupported());
        }
        if (!contributors.isEmpty()) {
            CountDownLatch latch = new CountDownLatch(contributors.size());
            ProgressIndicatorWithCancelListener indicatorWithCancelListener = new ProgressIndicatorWithCancelListener();
            accumulator = new FullSearchResultsAccumulator((Map<? extends SearchEverywhereContributor<?>, Integer>)contributorsAndLimits, this.myEqualityProvider, this.myListener, this.myNotificationExecutor, (ProgressIndicator)indicatorWithCancelListener);
            for (SearchEverywhereContributor searchEverywhereContributor : contributors) {
                SearchEverywhereContributorFilter<?> filter = filterSupplier.apply(searchEverywhereContributor);
                Runnable task2 = MultiThreadSearcher.createSearchTask(pattern, useNonProjectItems, accumulator, indicatorWithCancelListener, searchEverywhereContributor, filter, () -> latch.countDown());
                ApplicationManager.getApplication().executeOnPooledThread(task2);
            }
            Runnable finisherTask = MultiThreadSearcher.createFinisherTask(latch, accumulator, indicatorWithCancelListener);
            Future future2 = ApplicationManager.getApplication().executeOnPooledThread(finisherTask);
            indicatorWithCancelListener.setCancelCallback(() -> {
                accumulator.stop();
                finisherFeature.cancel(true);
            });
            indicator = indicatorWithCancelListener;
        } else {
            indicator = new ProgressIndicatorBase();
            accumulator = new FullSearchResultsAccumulator((Map<? extends SearchEverywhereContributor<?>, Integer>)contributorsAndLimits, this.myEqualityProvider, this.myListener, this.myNotificationExecutor, (ProgressIndicator)indicator);
        }
        indicator.start();
        if (contributors.isEmpty()) {
            indicator.stop();
            accumulator.searchFinished();
        }
        return indicator;
    }

    @Override
    public ProgressIndicator findMoreItems(@NotNull Map<? extends SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> alreadyFound, @NotNull String pattern, boolean useNonProjectItems, @NotNull SearchEverywhereContributor<?> contributorToExpand, int newLimit, @NotNull Function<? super SearchEverywhereContributor<?>, ? extends SearchEverywhereContributorFilter<?>> filterSupplier) {
        SearchEverywhereContributorFilter<?> filter = filterSupplier.apply(contributorToExpand);
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        ShowMoreResultsAccumulator accumulator = new ShowMoreResultsAccumulator(alreadyFound, this.myEqualityProvider, contributorToExpand, newLimit, this.myListener, this.myNotificationExecutor, indicator);
        indicator.start();
        Runnable task2 = MultiThreadSearcher.createSearchTask(pattern, useNonProjectItems, accumulator, indicator, contributorToExpand, filter, () -> indicator.stop());
        ApplicationManager.getApplication().executeOnPooledThread(task2);
        return indicator;
    }

    @NotNull
    private static <F> Runnable createSearchTask(String pattern, boolean useNonProjectItems, ResultsAccumulator accumulator, ProgressIndicator indicator, SearchEverywhereContributor<F> contributor, SearchEverywhereContributorFilter<?> filter, Runnable finalCallback) {
        ContributorSearchTask task2 = new ContributorSearchTask(contributor, pattern, filter, useNonProjectItems, accumulator, indicator, finalCallback);
        return ConcurrencyUtil.underThreadNameRunnable((String)"SE-SearchTask", task2);
    }

    private static Runnable createFinisherTask(CountDownLatch latch, FullSearchResultsAccumulator accumulator, ProgressIndicator indicator) {
        return ConcurrencyUtil.underThreadNameRunnable((String)"SE-FinisherTask", () -> {
            try {
                latch.await();
                if (!indicator.isCanceled()) {
                    accumulator.searchFinished();
                }
                indicator.stop();
            }
            catch (InterruptedException e) {
                LOG.debug("Finisher interrupted before search process is finished");
            }
        });
    }

    private static class ProgressIndicatorWithCancelListener
    extends ProgressIndicatorBase {
        private volatile Runnable cancelCallback = () -> {};

        private ProgressIndicatorWithCancelListener() {
        }

        private void setCancelCallback(Runnable cancelCallback) {
            this.cancelCallback = cancelCallback;
        }

        @Override
        protected void onRunningChange() {
            if (this.isCanceled()) {
                this.cancelCallback.run();
            }
        }
    }

    private static class FullSearchResultsAccumulator
    extends ResultsAccumulator {
        private final Map<? extends SearchEverywhereContributor<?>, Integer> sectionsLimits;
        private final Map<? extends SearchEverywhereContributor<?>, Condition> conditionsMap;
        private final Map<SearchEverywhereContributor<?>, Boolean> hasMoreMap = new ConcurrentHashMap();
        private final Set<SearchEverywhereContributor<?>> finishedContributorsSet = ContainerUtil.newConcurrentSet();
        private final Lock lock = new ReentrantLock();
        private volatile boolean mySearchFinished = false;

        FullSearchResultsAccumulator(Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, SEResultsEqualityProvider equalityProvider, SESearcher.Listener listener2, Executor notificationExecutor, ProgressIndicator progressIndicator) {
            super(contributorsAndLimits.entrySet().stream().collect(Collectors.toMap(entry -> (SearchEverywhereContributor)entry.getKey(), entry -> new ArrayList((Integer)entry.getValue()))), equalityProvider, listener2, notificationExecutor, progressIndicator);
            this.sectionsLimits = contributorsAndLimits;
            this.conditionsMap = contributorsAndLimits.keySet().stream().collect(Collectors.toMap(Function.identity(), c -> this.lock.newCondition()));
        }

        @Override
        public void setContributorHasMore(SearchEverywhereContributor<?> contributor, boolean hasMore) {
            this.hasMoreMap.put(contributor, hasMore);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addElement(Object element, SearchEverywhereContributor<?> contributor, int priority, ProgressIndicator indicator) throws InterruptedException {
            SearchEverywhereFoundElementInfo newElementInfo = new SearchEverywhereFoundElementInfo(element, priority, contributor);
            Condition condition = this.conditionsMap.get(contributor);
            Collection section = (Collection)this.sections.get(contributor);
            int limit = this.sectionsLimits.get(contributor);
            this.lock.lock();
            try {
                while (section.size() >= limit && !this.mySearchFinished) {
                    indicator.checkCanceled();
                    condition.await(100L, TimeUnit.MILLISECONDS);
                }
                if (this.mySearchFinished) {
                    boolean bl = false;
                    return bl;
                }
                Map<SEResultsEqualityProvider.SEEqualElementsActionType, Collection<SearchEverywhereFoundElementInfo>> otherElementsMap = this.getActionsWithOtherElements(newElementInfo);
                if (otherElementsMap.get((Object)SEResultsEqualityProvider.SEEqualElementsActionType.REPLACE).isEmpty() && !otherElementsMap.get((Object)SEResultsEqualityProvider.SEEqualElementsActionType.SKIP).isEmpty()) {
                    LOG.debug(String.format("Element %s for contributor %s was skipped", element.toString(), contributor.getSearchProviderId()));
                    boolean bl = true;
                    return bl;
                }
                section.add(newElementInfo);
                this.runInNotificationExecutor(() -> this.myListener.elementsAdded(Collections.singletonList(newElementInfo)));
                ArrayList<SearchEverywhereFoundElementInfo> toRemove2 = new ArrayList<SearchEverywhereFoundElementInfo>(otherElementsMap.get((Object)SEResultsEqualityProvider.SEEqualElementsActionType.REPLACE));
                toRemove2.forEach(info -> {
                    Collection list2 = (Collection)this.sections.get(info.getContributor());
                    Condition listCondition = this.conditionsMap.get(info.getContributor());
                    list2.remove(info);
                    LOG.debug(String.format("Element %s for contributor %s is removed", info.getElement().toString(), info.getContributor().getSearchProviderId()));
                    listCondition.signal();
                });
                this.runInNotificationExecutor(() -> this.myListener.elementsRemoved(toRemove2));
                if (section.size() >= limit) {
                    this.stopSearchIfNeeded();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void contributorFinished(SearchEverywhereContributor<?> contributor) {
            this.lock.lock();
            try {
                this.finishedContributorsSet.add(contributor);
                this.stopSearchIfNeeded();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void searchFinished() {
            this.runInNotificationExecutor(() -> this.myListener.searchFinished(this.hasMoreMap));
        }

        public void stop() {
            this.lock.lock();
            try {
                this.mySearchFinished = true;
                this.conditionsMap.values().forEach(Condition::signalAll);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void stopSearchIfNeeded() {
            if (this.sections.keySet().stream().allMatch(contributor -> this.isContributorFinished((SearchEverywhereContributor<?>)contributor))) {
                this.mySearchFinished = true;
                this.conditionsMap.values().forEach(Condition::signalAll);
            }
        }

        private boolean isContributorFinished(SearchEverywhereContributor<?> contributor) {
            if (this.finishedContributorsSet.contains(contributor)) {
                return true;
            }
            return ((Collection)this.sections.get(contributor)).size() >= this.sectionsLimits.get(contributor);
        }
    }

    private static class ShowMoreResultsAccumulator
    extends ResultsAccumulator {
        private final SearchEverywhereContributor<?> myExpandedContributor;
        private final int myNewLimit;
        private volatile boolean hasMore;

        ShowMoreResultsAccumulator(Map<? extends SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> alreadyFound, SEResultsEqualityProvider equalityProvider, SearchEverywhereContributor<?> contributor, int newLimit, SESearcher.Listener listener2, Executor notificationExecutor, ProgressIndicator progressIndicator) {
            super(new ConcurrentHashMap(alreadyFound), equalityProvider, listener2, notificationExecutor, progressIndicator);
            this.myExpandedContributor = contributor;
            this.myNewLimit = newLimit;
        }

        @Override
        public boolean addElement(Object element, SearchEverywhereContributor<?> contributor, int priority, ProgressIndicator indicator) {
            assert (contributor == this.myExpandedContributor);
            Collection section = (Collection)this.sections.get(contributor);
            SearchEverywhereFoundElementInfo newElementInfo = new SearchEverywhereFoundElementInfo(element, priority, contributor);
            if (section.size() >= this.myNewLimit) {
                return false;
            }
            Map<SEResultsEqualityProvider.SEEqualElementsActionType, Collection<SearchEverywhereFoundElementInfo>> otherElementsMap = this.getActionsWithOtherElements(newElementInfo);
            if (otherElementsMap.get((Object)SEResultsEqualityProvider.SEEqualElementsActionType.REPLACE).isEmpty() && !otherElementsMap.get((Object)SEResultsEqualityProvider.SEEqualElementsActionType.SKIP).isEmpty()) {
                LOG.debug(String.format("Element %s for contributor %s was skipped", element.toString(), contributor.getSearchProviderId()));
                return true;
            }
            section.add(newElementInfo);
            this.runInNotificationExecutor(() -> this.myListener.elementsAdded(Collections.singletonList(newElementInfo)));
            ArrayList<SearchEverywhereFoundElementInfo> toRemove2 = new ArrayList<SearchEverywhereFoundElementInfo>(otherElementsMap.get((Object)SEResultsEqualityProvider.SEEqualElementsActionType.REPLACE));
            toRemove2.forEach(info -> {
                Collection list2 = (Collection)this.sections.get(info.getContributor());
                list2.remove(info);
                LOG.debug(String.format("Element %s for contributor %s is removed", info.getElement().toString(), info.getContributor().getSearchProviderId()));
            });
            this.runInNotificationExecutor(() -> this.myListener.elementsRemoved(toRemove2));
            return true;
        }

        @Override
        public void setContributorHasMore(SearchEverywhereContributor<?> contributor, boolean hasMore) {
            assert (contributor == this.myExpandedContributor);
            this.hasMore = hasMore;
        }

        @Override
        public void contributorFinished(SearchEverywhereContributor<?> contributor) {
            this.runInNotificationExecutor(() -> this.myListener.searchFinished(Collections.singletonMap(contributor, this.hasMore)));
        }
    }

    private static abstract class ResultsAccumulator {
        protected final Map<SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> sections;
        protected final SESearcher.Listener myListener;
        protected final Executor myNotificationExecutor;
        protected final SEResultsEqualityProvider myEqualityProvider;
        protected final ProgressIndicator myProgressIndicator;

        ResultsAccumulator(Map<SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> sections, SEResultsEqualityProvider equalityProvider, SESearcher.Listener listener2, Executor notificationExecutor, ProgressIndicator progressIndicator) {
            this.sections = sections;
            this.myEqualityProvider = equalityProvider;
            this.myListener = listener2;
            this.myNotificationExecutor = notificationExecutor;
            this.myProgressIndicator = progressIndicator;
        }

        protected Map<SEResultsEqualityProvider.SEEqualElementsActionType, Collection<SearchEverywhereFoundElementInfo>> getActionsWithOtherElements(SearchEverywhereFoundElementInfo newElement) {
            EnumMap<SEResultsEqualityProvider.SEEqualElementsActionType, Collection<SearchEverywhereFoundElementInfo>> res2 = new EnumMap<SEResultsEqualityProvider.SEEqualElementsActionType, Collection<SearchEverywhereFoundElementInfo>>(SEResultsEqualityProvider.SEEqualElementsActionType.class);
            res2.put(SEResultsEqualityProvider.SEEqualElementsActionType.REPLACE, new ArrayList());
            res2.put(SEResultsEqualityProvider.SEEqualElementsActionType.SKIP, new ArrayList());
            this.sections.values().stream().flatMap(Collection::stream).forEach(info -> {
                SEResultsEqualityProvider.SEEqualElementsActionType action = this.myEqualityProvider.compareItems(newElement, (SearchEverywhereFoundElementInfo)info);
                if (action != SEResultsEqualityProvider.SEEqualElementsActionType.DO_NOTHING) {
                    ((Collection)res2.get((Object)action)).add(info);
                }
            });
            return res2;
        }

        protected void runInNotificationExecutor(Runnable runnable2) {
            this.myNotificationExecutor.execute(() -> {
                if (!this.myProgressIndicator.isCanceled()) {
                    runnable2.run();
                }
            });
        }

        public abstract boolean addElement(Object var1, SearchEverywhereContributor<?> var2, int var3, ProgressIndicator var4) throws InterruptedException;

        public abstract void contributorFinished(SearchEverywhereContributor<?> var1);

        public abstract void setContributorHasMore(SearchEverywhereContributor<?> var1, boolean var2);
    }

    private static class ContributorSearchTask<F>
    implements Runnable {
        private final ResultsAccumulator myAccumulator;
        private final Runnable finishCallback;
        private final SearchEverywhereContributor<F> myContributor;
        private final SearchEverywhereContributorFilter<F> filter;
        private final String myPattern;
        private final boolean myUseNonProjectItems;
        private final ProgressIndicator myIndicator;

        private ContributorSearchTask(SearchEverywhereContributor<F> contributor, String pattern, SearchEverywhereContributorFilter<F> filter, boolean everywhere, ResultsAccumulator accumulator, ProgressIndicator indicator, Runnable callback2) {
            this.myContributor = contributor;
            this.myPattern = pattern;
            this.filter = filter;
            this.myUseNonProjectItems = everywhere;
            this.myAccumulator = accumulator;
            this.myIndicator = indicator;
            this.finishCallback = callback2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.debug("Search task started for contributor ", new Object[]{this.myContributor});
            try {
                SensitiveProgressWrapper wrapperIndicator;
                boolean repeat = false;
                do {
                    wrapperIndicator = new SensitiveProgressWrapper(this.myIndicator);
                    try {
                        ProgressManager.getInstance().runProcess(() -> this.myContributor.fetchElements(this.myPattern, this.myUseNonProjectItems, this.filter, wrapperIndicator, element -> {
                            try {
                                if (element == null) {
                                    LOG.debug("Skip null element");
                                    return true;
                                }
                                int priority = this.myContributor.getElementPriority(element, this.myPattern);
                                boolean added = this.myAccumulator.addElement(element, this.myContributor, priority, wrapperIndicator);
                                if (!added) {
                                    this.myAccumulator.setContributorHasMore(this.myContributor, true);
                                }
                                return added;
                            }
                            catch (InterruptedException e) {
                                LOG.warn("Search task was interrupted");
                                return false;
                            }
                        }), (ProgressIndicator)wrapperIndicator);
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        // empty catch block
                    }
                } while (repeat = !this.myIndicator.isCanceled() && wrapperIndicator.isCanceled());
                if (this.myIndicator.isCanceled()) {
                    return;
                }
                this.myAccumulator.contributorFinished(this.myContributor);
            }
            finally {
                this.finishCallback.run();
            }
            LOG.debug("Search task finished for contributor ", new Object[]{this.myContributor});
        }
    }
}

