/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.util.gotoByName.ChooseByNameFilterConfiguration;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PersistentSearchEverywhereContributorFilter<T>
implements SearchEverywhereContributorFilter<T> {
    private final ChooseByNameFilterConfiguration<? super T> myPersistentConfiguration;
    private final List<T> myElements;
    private final Function<? super T, String> myTextExtractor;
    private final Function<? super T, ? extends Icon> myIconExtractor;

    public PersistentSearchEverywhereContributorFilter(@NotNull List<T> elements, @NotNull ChooseByNameFilterConfiguration<? super T> configuration2, Function<? super T, String> textExtractor, Function<? super T, ? extends Icon> iconExtractor) {
        this.myElements = elements;
        this.myPersistentConfiguration = configuration2;
        this.myTextExtractor = textExtractor;
        this.myIconExtractor = iconExtractor;
    }

    public List<T> getAllElements() {
        return this.myElements;
    }

    public List<T> getSelectedElements() {
        return ContainerUtil.filter(this.myElements, this.myPersistentConfiguration::isFileTypeVisible);
    }

    public boolean isSelected(T element) {
        return this.myPersistentConfiguration.isFileTypeVisible(element);
    }

    public void setSelected(T element, boolean selected) {
        this.myPersistentConfiguration.setVisible(element, selected);
    }

    public String getElementText(T element) {
        return this.myTextExtractor.apply(element);
    }

    public Icon getElementIcon(T element) {
        return this.myIconExtractor.apply(element);
    }
}

