/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.google.common.collect.Lists;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecentFilesSEContributor
extends FileSearchEverywhereContributor {
    public RecentFilesSEContributor(@Nullable Project project, @Nullable PsiElement context) {
        super(project, context);
    }

    @Override
    @NotNull
    public String getSearchProviderId() {
        return RecentFilesSEContributor.class.getSimpleName();
    }

    @Override
    @NotNull
    public String getGroupName() {
        return "Recent Files";
    }

    @Override
    public String includeNonProjectItemsText() {
        return null;
    }

    @Override
    public int getSortWeight() {
        return 70;
    }

    @Override
    public int getElementPriority(@NotNull Object element, @NotNull String searchPattern) {
        return super.getElementPriority(element, searchPattern) + 5;
    }

    @Override
    public void fetchElements(@NotNull String pattern, boolean everywhere, @Nullable SearchEverywhereContributorFilter<FileType> filter, @NotNull ProgressIndicator progressIndicator, @NotNull Function<Object, Boolean> consumer) {
        if (this.myProject == null) {
            return;
        }
        String searchString = this.filterControlSymbols(pattern);
        MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + searchString)).build();
        List<VirtualFile> opened = Arrays.asList(FileEditorManager.getInstance((Project)this.myProject).getSelectedFiles());
        List history = Lists.reverse(EditorHistoryManager.getInstance(this.myProject).getFileList());
        ArrayList res2 = new ArrayList();
        ProgressIndicatorUtils.yieldToPendingWriteActions();
        ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            Stream<Object> stream = history.stream();
            if (!StringUtil.isEmptyOrSpaces((String)searchString)) {
                stream = stream.filter(file2 -> matcher.matches(file2.getName()));
            }
            res2.addAll(stream.filter(vf -> !opened.contains(vf) && vf.isValid()).distinct().map(vf -> psiManager.findFile(vf)).filter(file2 -> file2 != null).collect(Collectors.toList()));
            for (Object element : res2) {
                if (((Boolean)consumer.apply(element)).booleanValue()) continue;
                return;
            }
        }, progressIndicator);
    }

    public boolean isEmptyPatternSupported() {
        return true;
    }

    @Override
    public boolean isShownInSeparateTab() {
        return false;
    }
}

