/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.SEResultsEqualityProvider;
import com.intellij.ide.actions.searcheverywhere.SESearcher;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.util.ConcurrencyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collector;
import org.jetbrains.annotations.NotNull;

@Deprecated
class SingleThreadSearcher
implements SESearcher {
    private final Executor myNotificationExecutor;
    private final SESearcher.Listener myNotificationListener;
    @NotNull
    private final SEResultsEqualityProvider myEqualityProvider;

    SingleThreadSearcher(SESearcher.Listener listener2, Executor executor, @NotNull Collection<SEResultsEqualityProvider> equalityProviders) {
        this.myNotificationExecutor = executor;
        this.myNotificationListener = listener2;
        this.myEqualityProvider = SEResultsEqualityProvider.composite(equalityProviders);
    }

    @Override
    public ProgressIndicator search(@NotNull Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, @NotNull String pattern, boolean useNonProjectItems, @NotNull Function<? super SearchEverywhereContributor<?>, ? extends SearchEverywhereContributorFilter<?>> filterSupplier) {
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        SearchTask task2 = new SearchTask(contributorsAndLimits, pattern, useNonProjectItems, filterSupplier, indicator, this.myNotificationExecutor, this.myNotificationListener, this.myEqualityProvider);
        ApplicationManager.getApplication().executeOnPooledThread(ConcurrencyUtil.underThreadNameRunnable((String)"SE-SingleThread-SearchTask", (Runnable)task2));
        return indicator;
    }

    @Override
    public ProgressIndicator findMoreItems(@NotNull Map<? extends SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> alreadyFound, @NotNull String pattern, boolean useNonProjectItems, @NotNull SearchEverywhereContributor<?> contributorToExpand, int newLimit, @NotNull Function<? super SearchEverywhereContributor<?>, ? extends SearchEverywhereContributorFilter<?>> filterSupplier) {
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        ShowMoreTask<?> task2 = this.createShowMoreTask(contributorToExpand, newLimit, pattern, useNonProjectItems, alreadyFound, filterSupplier, indicator);
        ApplicationManager.getApplication().executeOnPooledThread(ConcurrencyUtil.underThreadNameRunnable((String)"SE-SingleThread-SearchTask", task2));
        return indicator;
    }

    @NotNull
    private <F> ShowMoreTask<F> createShowMoreTask(SearchEverywhereContributor<F> contributorToExpand, int newLimit, String pattern, boolean useNonProjectItems, Map<? extends SearchEverywhereContributor<?>, Collection<SearchEverywhereFoundElementInfo>> alreadyFound, Function<? super SearchEverywhereContributor<?>, ? extends SearchEverywhereContributorFilter<?>> filterSupplier, ProgressIndicator indicator) {
        List alreadyFoundList = alreadyFound.values().stream().collect(Collector.of(() -> new ArrayList(), (list2, infos) -> list2.addAll(infos), (left, right) -> {
            left.addAll(right);
            return left;
        }, new Collector.Characteristics[0]));
        return new ShowMoreTask(contributorToExpand, newLimit, pattern, useNonProjectItems, filterSupplier.apply(contributorToExpand), alreadyFoundList, indicator, this.myNotificationExecutor, this.myNotificationListener, this.myEqualityProvider);
    }

    private static <T> UpdateInfo calculateUpdates(SearchEverywhereContributor<T> contributor, String pattern, int limit, boolean everywhere, SearchEverywhereContributorFilter<?> filter, ProgressIndicator progressIndicator, Collection<SearchEverywhereFoundElementInfo> alreadyFound, SEResultsEqualityProvider equalityProvider) {
        UpdateInfo res2 = new UpdateInfo();
        contributor.fetchElements(pattern, everywhere, filter, progressIndicator, newElement -> {
            if (newElement == null) {
                return true;
            }
            if (res2.addedElements.size() >= limit) {
                res2.hasMore = true;
                return false;
            }
            int priority = contributor.getElementPriority(newElement, pattern);
            SearchEverywhereFoundElementInfo newInfo = new SearchEverywhereFoundElementInfo(newElement, priority, contributor);
            boolean shouldBeAdded = SingleThreadSearcher.processSameElements(newInfo, alreadyFound, res2, equalityProvider);
            if (!shouldBeAdded) {
                return true;
            }
            res2.addedElements.add(newInfo);
            alreadyFound.add(newInfo);
            return true;
        });
        return res2;
    }

    private static boolean processSameElements(SearchEverywhereFoundElementInfo newInfo, Collection<SearchEverywhereFoundElementInfo> alreadyFound, UpdateInfo res2, SEResultsEqualityProvider equalityProvider) {
        EnumMap sameItemsMap = new EnumMap(SEResultsEqualityProvider.SEEqualElementsActionType.class);
        sameItemsMap.put(SEResultsEqualityProvider.SEEqualElementsActionType.SKIP, new ArrayList());
        sameItemsMap.put(SEResultsEqualityProvider.SEEqualElementsActionType.REPLACE, new ArrayList());
        alreadyFound.forEach(info -> {
            SEResultsEqualityProvider.SEEqualElementsActionType action = equalityProvider.compareItems(newInfo, (SearchEverywhereFoundElementInfo)info);
            if (action != SEResultsEqualityProvider.SEEqualElementsActionType.DO_NOTHING) {
                ((Collection)sameItemsMap.get((Object)action)).add(info);
            }
        });
        Collection toReplace = (Collection)sameItemsMap.get((Object)SEResultsEqualityProvider.SEEqualElementsActionType.REPLACE);
        if (!toReplace.isEmpty()) {
            toReplace.forEach(info -> {
                res2.removedElements.add(info);
                alreadyFound.remove(info);
            });
            return true;
        }
        return ((Collection)sameItemsMap.get((Object)SEResultsEqualityProvider.SEEqualElementsActionType.SKIP)).isEmpty();
    }

    private static class ShowMoreTask<F>
    implements Runnable {
        private final SearchEverywhereContributor<F> myContributor;
        private final int myLimit;
        private final String myPattern;
        private final boolean myUseNonProjectItems;
        private final SearchEverywhereContributorFilter<F> myFilter;
        private final List<SearchEverywhereFoundElementInfo> myAlreadyFound;
        private final ProgressIndicator myProgressIndicator;
        private final Executor notificationExecutor;
        private final SESearcher.Listener notificationListener;
        private final SEResultsEqualityProvider myEqualityProvider;

        private ShowMoreTask(SearchEverywhereContributor<F> contributor, int limit, String pattern, boolean useNonProjectItems, SearchEverywhereContributorFilter<F> filter, List<SearchEverywhereFoundElementInfo> alreadyFound, ProgressIndicator indicator, Executor executor, SESearcher.Listener listener2, SEResultsEqualityProvider equalityProvider) {
            this.myContributor = contributor;
            this.myLimit = limit;
            this.myPattern = pattern;
            this.myUseNonProjectItems = useNonProjectItems;
            this.myFilter = filter;
            this.myAlreadyFound = alreadyFound;
            this.myProgressIndicator = indicator;
            this.notificationExecutor = executor;
            this.notificationListener = listener2;
            this.myEqualityProvider = equalityProvider;
        }

        @Override
        public void run() {
            UpdateInfo updates = SingleThreadSearcher.calculateUpdates(this.myContributor, this.myPattern, this.myLimit, this.myUseNonProjectItems, this.myFilter, this.myProgressIndicator, new ArrayList<SearchEverywhereFoundElementInfo>(this.myAlreadyFound), this.myEqualityProvider);
            this.notificationExecutor.execute(() -> this.notificationListener.elementsAdded(updates.addedElements));
            this.notificationExecutor.execute(() -> this.notificationListener.elementsRemoved(updates.removedElements));
            this.notificationExecutor.execute(() -> this.notificationListener.searchFinished(Collections.singletonMap(this.myContributor, updates.hasMore)));
        }
    }

    private static class SearchTask
    implements Runnable {
        private final Map<? extends SearchEverywhereContributor<?>, Integer> myContributorsAndLimits;
        private final String myPattern;
        private final boolean myUseNonProjectItems;
        private final Function<? super SearchEverywhereContributor<?>, ? extends SearchEverywhereContributorFilter<?>> myFilterSupplier;
        private final SEResultsEqualityProvider myEqualityProvider;
        private final ProgressIndicator myProgressIndicator;
        private final Executor notificationExecutor;
        private final SESearcher.Listener notificationListener;

        SearchTask(Map<? extends SearchEverywhereContributor<?>, Integer> contributorsAndLimits, String pattern, boolean useNonProjectItems, Function<? super SearchEverywhereContributor<?>, ? extends SearchEverywhereContributorFilter<?>> filterSupplier, ProgressIndicator progressIndicator, Executor notificationExecutor, SESearcher.Listener notificationListener, SEResultsEqualityProvider equalityProvider) {
            this.myContributorsAndLimits = contributorsAndLimits;
            this.myPattern = pattern;
            this.myUseNonProjectItems = useNonProjectItems;
            this.myFilterSupplier = filterSupplier;
            this.myEqualityProvider = equalityProvider;
            this.myProgressIndicator = progressIndicator;
            this.notificationExecutor = notificationExecutor;
            this.notificationListener = notificationListener;
        }

        @Override
        public void run() {
            HashMap hasMoreContributors = new HashMap();
            ArrayList alreadyFound = new ArrayList();
            this.myContributorsAndLimits.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((SearchEverywhereContributor)entry.getKey()).getSortWeight())).forEach(entry -> {
                SearchEverywhereContributor contributor = (SearchEverywhereContributor)entry.getKey();
                UpdateInfo updates = SingleThreadSearcher.calculateUpdates(contributor, this.myPattern, (Integer)entry.getValue(), this.myUseNonProjectItems, this.myFilterSupplier.apply(contributor), this.myProgressIndicator, alreadyFound, this.myEqualityProvider);
                this.notificationExecutor.execute(() -> this.notificationListener.elementsAdded(updates.addedElements));
                this.notificationExecutor.execute(() -> this.notificationListener.elementsRemoved(updates.removedElements));
                hasMoreContributors.put(contributor, updates.hasMore);
            });
            this.notificationExecutor.execute(() -> this.notificationListener.searchFinished(hasMoreContributors));
        }
    }

    private static class UpdateInfo {
        private final List<SearchEverywhereFoundElementInfo> addedElements = new ArrayList<SearchEverywhereFoundElementInfo>();
        private final List<SearchEverywhereFoundElementInfo> removedElements = new ArrayList<SearchEverywhereFoundElementInfo>();
        private boolean hasMore = false;

        private UpdateInfo() {
        }
    }
}

