/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.actions.searcheverywhere.AbstractGotoSEContributor;
import com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.PersistentSearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoClassSymbolConfiguration;
import com.intellij.ide.util.gotoByName.GotoSymbolModel2;
import com.intellij.lang.DependentLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IdeUICustomization;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SymbolSearchEverywhereContributor
extends AbstractGotoSEContributor<Language> {
    public SymbolSearchEverywhereContributor(@Nullable Project project, @Nullable PsiElement context) {
        super(project, context);
    }

    @NotNull
    public String getGroupName() {
        return "Symbols";
    }

    public String includeNonProjectItemsText() {
        return IdeBundle.message((String)"checkbox.include.non.project.symbols", (Object[])new Object[]{IdeUICustomization.getInstance().getProjectConceptName()});
    }

    public int getSortWeight() {
        return 300;
    }

    public boolean isDumbModeSupported() {
        return false;
    }

    @Override
    @NotNull
    protected FilteringGotoByModel<Language> createModel(@NotNull Project project) {
        return new GotoSymbolModel2(project);
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<Language> {
        @NotNull
        public SearchEverywhereContributor<Language> createContributor(AnActionEvent initEvent) {
            return new SymbolSearchEverywhereContributor(initEvent.getProject(), GotoActionBase.getPsiContext(initEvent));
        }

        @Nullable
        public SearchEverywhereContributorFilter<Language> createFilter(AnActionEvent initEvent) {
            Project project = initEvent.getProject();
            if (project == null) {
                return null;
            }
            List items = Language.getRegisteredLanguages().stream().filter(lang -> lang != Language.ANY && !(lang instanceof DependentLanguage)).sorted(LanguageUtil.LANGUAGE_COMPARATOR).collect(Collectors.toList());
            return new PersistentSearchEverywhereContributorFilter<Language>(items, GotoClassSymbolConfiguration.getInstance(project), ClassSearchEverywhereContributor.Factory.LANGUAGE_NAME_EXTRACTOR, ClassSearchEverywhereContributor.Factory.LANGUAGE_ICON_EXTRACTOR);
        }
    }
}

