/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.SESearcher;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.Alarm;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

class ThrottlingListenerWrapper
implements SESearcher.Listener {
    public final int myThrottlingDelay;
    private final SESearcher.Listener myDelegateListener;
    private final Executor myDelegateExecutor;
    private final Buffer myBuffer = new Buffer();
    private final BiConsumer<List<SearchEverywhereFoundElementInfo>, List<SearchEverywhereFoundElementInfo>> myFlushConsumer;
    private final Alarm flushAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private boolean flushScheduled;

    ThrottlingListenerWrapper(int throttlingDelay, SESearcher.Listener delegateListener, Executor delegateExecutor) {
        this.myThrottlingDelay = throttlingDelay;
        this.myDelegateListener = delegateListener;
        this.myDelegateExecutor = delegateExecutor;
        this.myFlushConsumer = (added, removed) -> {
            if (!added.isEmpty()) {
                this.myDelegateExecutor.execute(() -> this.myDelegateListener.elementsAdded((List<SearchEverywhereFoundElementInfo>)added));
            }
            if (!removed.isEmpty()) {
                this.myDelegateExecutor.execute(() -> this.myDelegateListener.elementsRemoved((List<SearchEverywhereFoundElementInfo>)removed));
            }
        };
    }

    public void clearBuffer() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myBuffer.clear();
        this.cancelScheduledFlush();
    }

    @Override
    public void elementsAdded(@NotNull List<SearchEverywhereFoundElementInfo> list2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myBuffer.addEvent(new Event(1, list2));
        this.scheduleFlushBuffer();
    }

    @Override
    public void elementsRemoved(@NotNull List<SearchEverywhereFoundElementInfo> list2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myBuffer.addEvent(new Event(0, list2));
        this.scheduleFlushBuffer();
    }

    @Override
    public void searchFinished(@NotNull Map<SearchEverywhereContributor<?>, Boolean> hasMoreContributors) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myBuffer.flush(this.myFlushConsumer);
        this.myDelegateExecutor.execute(() -> this.myDelegateListener.searchFinished(hasMoreContributors));
        this.cancelScheduledFlush();
    }

    private void scheduleFlushBuffer() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Runnable flushTask = () -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (!this.flushScheduled) {
                return;
            }
            this.flushScheduled = false;
            this.myBuffer.flush(this.myFlushConsumer);
        };
        if (!this.flushScheduled) {
            this.flushAlarm.addRequest(flushTask, this.myThrottlingDelay);
            this.flushScheduled = true;
        }
    }

    private void cancelScheduledFlush() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.flushAlarm.cancelAllRequests();
        this.flushScheduled = false;
    }

    private static class Buffer {
        private final Queue<Event> myQueue = new ArrayDeque<Event>();

        private Buffer() {
        }

        public void addEvent(Event event) {
            this.myQueue.add(event);
        }

        public void flush(BiConsumer<List<SearchEverywhereFoundElementInfo>, List<SearchEverywhereFoundElementInfo>> consumer) {
            ArrayList added = new ArrayList();
            ArrayList removed = new ArrayList();
            this.myQueue.forEach(event -> {
                if (event.type == 1) {
                    added.addAll(event.items);
                } else {
                    event.items.forEach(removing -> {
                        if (!added.removeIf(existing -> existing.getContributor() == removing.getContributor() && existing.getElement() == removing.getElement())) {
                            removed.add(removing);
                        }
                    });
                }
            });
            this.myQueue.clear();
            consumer.accept(added, removed);
        }

        public void clear() {
            this.myQueue.clear();
        }
    }

    private static class Event {
        static final int REMOVE = 0;
        static final int ADD = 1;
        final int type;
        final List<SearchEverywhereFoundElementInfo> items;

        Event(int type, List<SearchEverywhereFoundElementInfo> items) {
            this.type = type;
            this.items = items;
        }
    }
}

