/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere.statistics;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchEverywhereUsageTriggerCollector {
    private static final String NOT_REPORTABLE_CONTRIBUTOR_ID = "third.party";
    public static final String DIALOG_OPEN = "dialogOpen";
    public static final String TAB_SWITCHED = "tabSwitched";
    public static final String GROUP_NAVIGATE = "navigateThroughGroups";
    public static final String CONTRIBUTOR_ITEM_SELECTED = "contributorItemChosen";
    public static final String MORE_ITEM_SELECTED = "moreItemChosen";
    public static final String COMMAND_USED = "commandUsed";
    public static final String COMMAND_COMPLETED = "commandCompleted";
    public static final String CONTRIBUTOR_ID_FIELD = "contributorID";

    public static void trigger(@NotNull Project project, @NotNull String feature) {
        SearchEverywhereUsageTriggerCollector.trigger(project, feature, new FeatureUsageData());
    }

    public static void trigger(@NotNull Project project, @NotNull String feature, @NotNull FeatureUsageData data) {
        FUCounterUsageLogger.getInstance().logEvent(project, "searchEverywhere", feature, data);
    }

    @NotNull
    public static FeatureUsageData createData(@Nullable String contributorID) {
        FeatureUsageData res2 = new FeatureUsageData();
        if (contributorID != null) {
            res2.addData(CONTRIBUTOR_ID_FIELD, contributorID);
        }
        return res2;
    }

    @NotNull
    public static String getReportableContributorID(@NotNull SearchEverywhereContributor<?> contributor) {
        Class<?> clazz = contributor.getClass();
        PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(clazz);
        return pluginInfo.isDevelopedByJetBrains() ? contributor.getSearchProviderId() : NOT_REPORTABLE_CONTRIBUTOR_ID;
    }
}

