/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkItem;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.BookmarksListener;
import com.intellij.ide.favoritesTreeView.AbstractFavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BookmarksFavoriteListProvider
extends AbstractFavoritesListProvider<Bookmark>
implements BookmarksListener {
    private final BookmarkManager myBookmarkManager;
    private final FavoritesManager myFavoritesManager;

    public BookmarksFavoriteListProvider(Project project, BookmarkManager bookmarkManager, FavoritesManager favoritesManager) {
        super(project, "Bookmarks");
        this.myBookmarkManager = bookmarkManager;
        this.myFavoritesManager = favoritesManager;
        project.getMessageBus().connect((Disposable)project).subscribe(BookmarksListener.TOPIC, (Object)this);
        this.updateChildren();
    }

    @Override
    public void bookmarkAdded(@NotNull Bookmark b) {
        this.updateChildren();
    }

    @Override
    public void bookmarkRemoved(@NotNull Bookmark b) {
        this.updateChildren();
    }

    @Override
    public void bookmarkChanged(@NotNull Bookmark b) {
        this.updateChildren();
    }

    @Override
    public void bookmarksOrderChanged() {
        this.updateChildren();
    }

    private void updateChildren() {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myChildren.clear();
        List<Bookmark> bookmarks = this.myBookmarkManager.getValidBookmarks();
        for (final Bookmark bookmark : bookmarks) {
            AbstractTreeNode<Bookmark> child2 = new AbstractTreeNode<Bookmark>(this.myProject, bookmark){

                @NotNull
                public Collection<? extends AbstractTreeNode> getChildren() {
                    return Collections.emptyList();
                }

                public boolean canNavigate() {
                    return bookmark.canNavigate();
                }

                public boolean canNavigateToSource() {
                    return bookmark.canNavigateToSource();
                }

                public void navigate(boolean requestFocus) {
                    bookmark.navigate(requestFocus);
                }

                protected void update(@NotNull PresentationData presentation) {
                    presentation.setPresentableText(bookmark.toString());
                    presentation.setIcon(bookmark.getIcon());
                }
            };
            child2.setParent((AbstractTreeNode)this.myNode);
            this.myChildren.add(child2);
        }
        this.myFavoritesManager.fireListeners(this.getListName(this.myProject));
    }

    @Override
    @Nullable
    public String getCustomName(@NotNull CommonActionsPanel.Buttons type) {
        switch (type) {
            case EDIT: {
                return IdeBundle.message((String)"action.bookmark.edit.description", (Object[])new Object[0]);
            }
            case REMOVE: {
                return IdeBundle.message((String)"action.bookmark.delete", (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    public boolean willHandle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects) {
        switch (type) {
            case EDIT: {
                if (selectedObjects.size() != 1) {
                    return false;
                }
                Object toEdit = selectedObjects.iterator().next();
                return toEdit instanceof AbstractTreeNode && ((AbstractTreeNode)toEdit).getValue() instanceof Bookmark;
            }
            case REMOVE: {
                for (Object toRemove2 : selectedObjects) {
                    if (toRemove2 instanceof AbstractTreeNode && ((AbstractTreeNode)toRemove2).getValue() instanceof Bookmark) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void handle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects, JComponent component) {
        switch (type) {
            case EDIT: {
                Bookmark bookmark;
                Object toEdit;
                if (selectedObjects.size() != 1 || !((toEdit = selectedObjects.iterator().next()) instanceof AbstractTreeNode) || !(((AbstractTreeNode)toEdit).getValue() instanceof Bookmark) || (bookmark = (Bookmark)((AbstractTreeNode)toEdit).getValue()) == null) break;
                BookmarkManager.getInstance(project).editDescription(bookmark, component);
                break;
            }
            case REMOVE: {
                for (Object toRemove2 : selectedObjects) {
                    Bookmark bookmark = (Bookmark)((AbstractTreeNode)toRemove2).getValue();
                    BookmarkManager.getInstance(project).removeBookmark(bookmark);
                }
                break;
            }
        }
    }

    @Override
    public int getWeight() {
        return 100;
    }

    @Override
    public void customizeRenderer(ColoredTreeCellRenderer renderer2, JTree tree, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        renderer2.clear();
        renderer2.setIcon(Bookmark.DEFAULT_ICON);
        if (value instanceof Bookmark) {
            Bookmark bookmark = (Bookmark)value;
            BookmarkItem.setupRenderer((SimpleColoredComponent)renderer2, this.myProject, bookmark, selected);
            if (renderer2.getIcon() != null) {
                RowIcon icon = new RowIcon(3, RowIcon.Alignment.CENTER);
                icon.setIcon(bookmark.getIcon(), 0);
                icon.setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)1)), 1);
                icon.setIcon(renderer2.getIcon(), 2);
                renderer2.setIcon((Icon)icon);
            } else {
                renderer2.setIcon(bookmark.getIcon());
            }
        } else {
            renderer2.append(this.getListName(this.myProject));
        }
    }
}

