/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.ide.bookmarks.actions.BookmarksAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import org.jetbrains.annotations.NotNull;

public class ToggleBookmarkAction
extends BookmarksAction
implements DumbAware,
Toggleable {
    public ToggleBookmarkAction() {
        this.getTemplatePresentation().setText(IdeBundle.message((String)"action.bookmark.toggle", (Object[])new Object[0]));
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        BookmarksAction.BookmarkInContextInfo info;
        Project project = event.getProject();
        DataContext dataContext = event.getDataContext();
        event.getPresentation().setEnabled(project != null && (ToolWindowManager.getInstance((Project)project).isEditorComponentActive() && CommonDataKeys.EDITOR.getData(dataContext) != null || CommonDataKeys.VIRTUAL_FILE.getData(dataContext) != null));
        event.getPresentation().setText(IdeBundle.message((String)"action.bookmark.toggle", (Object[])new Object[0]));
        if ("TouchBarGeneral".equals(event.getPlace())) {
            event.getPresentation().setIcon(AllIcons.Actions.Checked);
        }
        boolean selected = (info = this.getBookmarkInfo(event)) != null && info.getBookmarkAtPlace() != null;
        event.getPresentation().putClientProperty("selected", (Object)selected);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        BookmarksAction.BookmarkInContextInfo info = this.getBookmarkInfo(e);
        if (info == null) {
            return;
        }
        boolean selected = info.getBookmarkAtPlace() != null;
        e.getPresentation().putClientProperty("selected", (Object)selected);
        if (selected) {
            BookmarkManager.getInstance(project).removeBookmark(info.getBookmarkAtPlace());
        } else {
            BookmarkManager.getInstance(project).addTextBookmark(info.getFile(), info.getLine(), "");
        }
    }

    private BookmarksAction.BookmarkInContextInfo getBookmarkInfo(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        BookmarksAction.BookmarkInContextInfo info = new BookmarksAction.BookmarkInContextInfo(e.getDataContext(), project).invoke();
        return info.getFile() == null ? null : info;
    }
}

