/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.util.List;
import java.util.UUID;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConfigurableWebBrowser
extends WebBrowser {
    private final UUID id;
    @NotNull
    private BrowserFamily family;
    @NotNull
    private String name;
    private boolean active;
    private String path;
    private BrowserSpecificSettings specificSettings;

    ConfigurableWebBrowser() {
        this(UUID.randomUUID(), BrowserFamily.CHROME);
    }

    ConfigurableWebBrowser(@NotNull UUID id, @NotNull BrowserFamily family) {
        this(id, family, family.getName(), family.getExecutionPath(), true, family.createBrowserSpecificSettings());
    }

    ConfigurableWebBrowser(@NotNull UUID id, @NotNull BrowserFamily family, @NotNull String name, @Nullable String path, boolean active, @Nullable BrowserSpecificSettings specificSettings) {
        this.id = id;
        this.family = family;
        this.name = name;
        this.path = StringUtil.nullize((String)path);
        this.active = active;
        this.specificSettings = specificSettings;
    }

    public void setName(@NotNull String value) {
        this.name = value;
    }

    public void setFamily(@NotNull BrowserFamily value) {
        this.family = value;
    }

    @NotNull
    public Icon getIcon() {
        if (this.family == BrowserFamily.CHROME) {
            if (WebBrowserManager.isYandexBrowser(this)) {
                return AllIcons.Xml.Browsers.Yandex16;
            }
            if (this.checkNameAndPath("Dartium") || this.checkNameAndPath("Chromium")) {
                return AllIcons.Xml.Browsers.Chromium16;
            }
            if (this.checkNameAndPath("Canary")) {
                return AllIcons.Xml.Browsers.Canary16;
            }
            if (this.checkNameAndPath("Opera")) {
                return AllIcons.Xml.Browsers.Opera16;
            }
            if (this.checkNameAndPath("node-webkit") || this.checkNameAndPath("nw") || this.checkNameAndPath("nwjs")) {
                return AllIcons.Xml.Browsers.Nwjs16;
            }
        } else if (this.family == BrowserFamily.EXPLORER && WebBrowserManager.isEdge(this)) {
            return AllIcons.Xml.Browsers.Edge16;
        }
        return this.family.getIcon();
    }

    private boolean checkNameAndPath(@NotNull String what) {
        return WebBrowserManager.checkNameAndPath(what, this);
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public void setPath(@Nullable String value) {
        this.path = PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)value));
    }

    @Nullable
    public BrowserSpecificSettings getSpecificSettings() {
        return this.specificSettings;
    }

    public void setSpecificSettings(@Nullable BrowserSpecificSettings value) {
        this.specificSettings = value;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean value) {
        this.active = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurableWebBrowser)) {
            return false;
        }
        ConfigurableWebBrowser browser2 = (ConfigurableWebBrowser)((Object)o);
        return this.getId().equals(browser2.getId()) && this.family.equals((Object)browser2.family) && this.active == browser2.active && Comparing.strEqual((String)this.name, (String)browser2.name) && Comparing.equal((String)this.path, (String)browser2.path) && Comparing.equal((Object)this.specificSettings, (Object)browser2.specificSettings);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    @NotNull
    public BrowserFamily getFamily() {
        return this.family;
    }

    @NotNull
    public String getBrowserNotFoundMessage() {
        return IdeBundle.message((String)"error.0.browser.path.not.specified", (Object[])new Object[]{this.getName()});
    }

    public void addOpenUrlParameter(@NotNull List<? super String> command, @NotNull String url) {
        if (WebBrowserManager.isEdge(this) && !command.isEmpty()) {
            command.set(command.size() - 1, command.get(command.size() - 1) + ":" + url);
        } else {
            super.addOpenUrlParameter(command, url);
        }
    }

    public String toString() {
        return this.getName() + " (" + this.getPath() + ")";
    }
}

