/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.ConfigurableWebBrowser;
import com.intellij.ide.browsers.DefaultBrowserPolicy;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="WebBrowsersConfiguration", storages={@Storage(value="web-browsers.xml")})
public class WebBrowserManager
extends SimpleModificationTracker
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(WebBrowserManager.class);
    private static final UUID PREDEFINED_CHROME_ID = UUID.fromString("98CA6316-2F89-46D9-A9E5-FA9E2B0625B3");
    public static final UUID PREDEFINED_FIREFOX_ID = UUID.fromString("A7BB68E0-33C0-4D6F-A81A-AAC1FDB870C8");
    private static final UUID PREDEFINED_SAFARI_ID = UUID.fromString("E5120D43-2C3F-47EF-9F26-65E539E05186");
    private static final UUID PREDEFINED_OPERA_ID = UUID.fromString("53E2F627-B1A7-4DFA-BFA7-5B83CC034776");
    private static final UUID PREDEFINED_YANDEX_ID = UUID.fromString("B1B2EC2C-20BD-4EE2-89C4-616DB004BCD4");
    private static final UUID PREDEFINED_EXPLORER_ID = UUID.fromString("16BF23D4-93E0-4FFC-BFD6-CB13575177B0");
    private static final UUID PREDEFINED_EDGE_ID = UUID.fromString("B2A9DCA7-9D0B-4E1E-98A8-AFB19C1328D2");
    private static final UUID[] PREDEFINED_BROWSER_IDS = new UUID[]{PREDEFINED_CHROME_ID, PREDEFINED_FIREFOX_ID, PREDEFINED_SAFARI_ID, PREDEFINED_OPERA_ID, PREDEFINED_YANDEX_ID, PREDEFINED_EXPLORER_ID, PREDEFINED_EDGE_ID};
    private static final String EDGE_COMMAND = "microsoft-edge";
    private List<ConfigurableWebBrowser> browsers;
    private boolean myShowBrowserHover = true;
    DefaultBrowserPolicy defaultBrowserPolicy = DefaultBrowserPolicy.SYSTEM;

    private static List<ConfigurableWebBrowser> getPredefinedBrowsers() {
        return Arrays.asList(new ConfigurableWebBrowser(PREDEFINED_CHROME_ID, BrowserFamily.CHROME), new ConfigurableWebBrowser(PREDEFINED_FIREFOX_ID, BrowserFamily.FIREFOX), new ConfigurableWebBrowser(PREDEFINED_SAFARI_ID, BrowserFamily.SAFARI), new ConfigurableWebBrowser(PREDEFINED_OPERA_ID, BrowserFamily.OPERA), new ConfigurableWebBrowser(PREDEFINED_YANDEX_ID, BrowserFamily.CHROME, "Yandex", SystemInfo.isWindows ? "browser" : (SystemInfo.isMac ? "Yandex" : "yandex"), false, BrowserFamily.CHROME.createBrowserSpecificSettings()), new ConfigurableWebBrowser(PREDEFINED_EXPLORER_ID, BrowserFamily.EXPLORER), new ConfigurableWebBrowser(PREDEFINED_EDGE_ID, BrowserFamily.EXPLORER, "Edge", SystemInfo.isWindows ? EDGE_COMMAND : null, true, null));
    }

    public WebBrowserManager() {
        this.browsers = new ArrayList<ConfigurableWebBrowser>(WebBrowserManager.getPredefinedBrowsers());
    }

    public static WebBrowserManager getInstance() {
        return (WebBrowserManager)((Object)ServiceManager.getService(WebBrowserManager.class));
    }

    public static boolean isYandexBrowser(@NotNull WebBrowser browser2) {
        return browser2.getFamily().equals((Object)BrowserFamily.CHROME) && (browser2.getId().equals(PREDEFINED_YANDEX_ID) || WebBrowserManager.checkNameAndPath("Yandex", browser2));
    }

    public static boolean isDartium(@NotNull WebBrowser browser2) {
        return browser2.getFamily().equals((Object)BrowserFamily.CHROME) && WebBrowserManager.checkNameAndPath("Dartium", browser2);
    }

    public static boolean isEdge(@NotNull WebBrowser browser2) {
        return browser2.getFamily() == BrowserFamily.EXPLORER && (browser2.getId().equals(PREDEFINED_EDGE_ID) || WebBrowserManager.checkNameAndPath(EDGE_COMMAND, browser2) || WebBrowserManager.checkNameAndPath("MicrosoftEdge", browser2));
    }

    static boolean checkNameAndPath(@NotNull String what, @NotNull WebBrowser browser2) {
        if (StringUtil.containsIgnoreCase((String)browser2.getName(), (String)what)) {
            return true;
        }
        String path = browser2.getPath();
        if (path != null) {
            int index = path.lastIndexOf(47);
            return index > 0 ? path.indexOf(what, index + 1) != -1 : path.contains(what);
        }
        return false;
    }

    boolean isPredefinedBrowser(@NotNull ConfigurableWebBrowser browser2) {
        UUID id = browser2.getId();
        for (UUID predefinedBrowserId : PREDEFINED_BROWSER_IDS) {
            if (!id.equals(predefinedBrowserId)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public DefaultBrowserPolicy getDefaultBrowserPolicy() {
        return this.defaultBrowserPolicy;
    }

    public Element getState() {
        Element state = new Element("state");
        if (this.defaultBrowserPolicy != DefaultBrowserPolicy.SYSTEM) {
            state.setAttribute("default", this.defaultBrowserPolicy.name().toLowerCase(Locale.ENGLISH));
        }
        if (!this.myShowBrowserHover) {
            state.setAttribute("showHover", "false");
        }
        if (!this.browsers.equals(WebBrowserManager.getPredefinedBrowsers())) {
            for (ConfigurableWebBrowser browser2 : this.browsers) {
                BrowserSpecificSettings specificSettings;
                Element entry = new Element("browser");
                entry.setAttribute("id", browser2.getId().toString());
                entry.setAttribute("name", browser2.getName());
                entry.setAttribute("family", browser2.getFamily().name());
                String path = browser2.getPath();
                if (path != null && !path.equals(browser2.getFamily().getExecutionPath())) {
                    entry.setAttribute("path", path);
                }
                if (!browser2.isActive()) {
                    entry.setAttribute("active", "false");
                }
                if ((specificSettings = browser2.getSpecificSettings()) != null) {
                    Element settingsElement = new Element("settings");
                    XmlSerializer.serializeInto((Object)specificSettings, (Element)settingsElement, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
                    if (!JDOMUtil.isEmpty((Element)settingsElement)) {
                        entry.addContent(settingsElement);
                    }
                }
                state.addContent(entry);
            }
        }
        return state;
    }

    @Nullable
    private static BrowserFamily readFamily(String value) {
        try {
            return BrowserFamily.valueOf((String)value);
        }
        catch (RuntimeException e) {
            LOG.warn((Throwable)e);
            for (BrowserFamily family : BrowserFamily.values()) {
                if (!family.getName().equalsIgnoreCase(value)) continue;
                return family;
            }
            return null;
        }
    }

    @Nullable
    private static UUID readId(String value, @NotNull BrowserFamily family, @NotNull List<ConfigurableWebBrowser> existingBrowsers) {
        if (StringUtil.isEmpty((String)value)) {
            UUID id;
            switch (family) {
                case CHROME: {
                    id = PREDEFINED_CHROME_ID;
                    break;
                }
                case EXPLORER: {
                    id = PREDEFINED_EXPLORER_ID;
                    break;
                }
                case FIREFOX: {
                    id = PREDEFINED_FIREFOX_ID;
                    break;
                }
                case OPERA: {
                    id = PREDEFINED_OPERA_ID;
                    break;
                }
                case SAFARI: {
                    id = PREDEFINED_SAFARI_ID;
                    break;
                }
                default: {
                    return null;
                }
            }
            for (ConfigurableWebBrowser browser2 : existingBrowsers) {
                if (browser2.getId() != id) continue;
                return null;
            }
            return id;
        }
        try {
            return UUID.fromString(value);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    public void loadState(@NotNull Element element) {
        String defaultValue = element.getAttributeValue("default");
        if (!StringUtil.isEmpty((String)defaultValue)) {
            try {
                this.defaultBrowserPolicy = DefaultBrowserPolicy.valueOf(defaultValue.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                LOG.warn((Throwable)e);
            }
        }
        this.myShowBrowserHover = !"false".equals(element.getAttributeValue("showHover"));
        ArrayList<ConfigurableWebBrowser> list2 = new ArrayList<ConfigurableWebBrowser>();
        for (Element child2 : element.getChildren("browser")) {
            UUID id;
            BrowserFamily family = WebBrowserManager.readFamily(child2.getAttributeValue("family"));
            if (family == null || (id = WebBrowserManager.readId(child2.getAttributeValue("id"), family, list2)) == null) continue;
            Element settingsElement = child2.getChild("settings");
            BrowserSpecificSettings specificSettings = family.createBrowserSpecificSettings();
            if (specificSettings != null && settingsElement != null) {
                try {
                    XmlSerializer.deserializeInto((Object)specificSettings, (Element)settingsElement);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
            String activeValue = child2.getAttributeValue("active");
            String path = StringUtil.nullize((String)child2.getAttributeValue("path"), (boolean)true);
            if (path == null) {
                path = family.getExecutionPath();
            }
            list2.add(new ConfigurableWebBrowser(id, family, StringUtil.notNullize((String)child2.getAttributeValue("name"), (String)family.getName()), path, activeValue == null || Boolean.parseBoolean(activeValue), specificSettings));
        }
        Map idToBrowser = null;
        int n = list2.size();
        block5: for (UUID predefinedBrowserId : PREDEFINED_BROWSER_IDS) {
            for (int i = 0; i < n; ++i) {
                if (((ConfigurableWebBrowser)((Object)list2.get(i))).getId().equals(predefinedBrowserId)) continue block5;
            }
            if (idToBrowser == null) {
                idToBrowser = ContainerUtil.newMapFromValues(WebBrowserManager.getPredefinedBrowsers().iterator(), it -> it.getId());
            }
            list2.add((ConfigurableWebBrowser)((Object)idToBrowser.get(predefinedBrowserId)));
        }
        this.setList(list2);
    }

    @NotNull
    public List<WebBrowser> getBrowsers() {
        return Collections.unmodifiableList(this.browsers);
    }

    @NotNull
    List<ConfigurableWebBrowser> getList() {
        return this.browsers;
    }

    void setList(@NotNull List<ConfigurableWebBrowser> value) {
        this.browsers = value;
        this.incModificationCount();
    }

    @NotNull
    public List<WebBrowser> getActiveBrowsers() {
        return this.getBrowsers((Condition<WebBrowser>)Conditions.alwaysTrue(), true);
    }

    @NotNull
    public List<WebBrowser> getBrowsers(@NotNull Condition<WebBrowser> condition) {
        return this.getBrowsers(condition, true);
    }

    @NotNull
    public List<WebBrowser> getBrowsers(@NotNull Condition<WebBrowser> condition, boolean onlyActive) {
        SmartList result2 = new SmartList();
        for (ConfigurableWebBrowser browser2 : this.browsers) {
            if (onlyActive && !browser2.isActive() || !condition.value((Object)browser2)) continue;
            result2.add(browser2);
        }
        return result2;
    }

    public void setBrowserSpecificSettings(@NotNull WebBrowser browser2, @NotNull BrowserSpecificSettings specificSettings) {
        ((ConfigurableWebBrowser)browser2).setSpecificSettings(specificSettings);
    }

    public void setBrowserPath(@NotNull WebBrowser browser2, @Nullable String path, boolean isActive) {
        ((ConfigurableWebBrowser)browser2).setPath(path);
        ((ConfigurableWebBrowser)browser2).setActive(isActive);
        this.incModificationCount();
    }

    public WebBrowser addBrowser(@NotNull UUID id, @NotNull BrowserFamily family, @NotNull String name, @Nullable String path, boolean active, BrowserSpecificSettings specificSettings) {
        ConfigurableWebBrowser browser2 = new ConfigurableWebBrowser(id, family, name, path, active, specificSettings);
        this.browsers.add(browser2);
        this.incModificationCount();
        return browser2;
    }

    @Nullable
    private static UUID parseUuid(@NotNull String id) {
        if (id.indexOf(45) == -1) {
            return null;
        }
        try {
            return UUID.fromString(id);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    @Nullable
    public WebBrowser findBrowserById(@Nullable String idOrFamilyName) {
        if (StringUtil.isEmpty((String)idOrFamilyName)) {
            return null;
        }
        UUID id = WebBrowserManager.parseUuid(idOrFamilyName);
        if (id == null) {
            for (ConfigurableWebBrowser browser2 : this.browsers) {
                if (!browser2.getFamily().name().equalsIgnoreCase(idOrFamilyName) && !browser2.getFamily().getName().equalsIgnoreCase(idOrFamilyName)) continue;
                return browser2;
            }
            return null;
        }
        for (ConfigurableWebBrowser browser3 : this.browsers) {
            if (!browser3.getId().equals(id)) continue;
            return browser3;
        }
        return null;
    }

    @Nullable
    public WebBrowser getFirstBrowserOrNull(@NotNull BrowserFamily family) {
        for (ConfigurableWebBrowser browser2 : this.browsers) {
            if (!browser2.isActive() || !family.equals((Object)browser2.getFamily())) continue;
            return browser2;
        }
        for (ConfigurableWebBrowser browser2 : this.browsers) {
            if (!family.equals((Object)browser2.getFamily())) continue;
            return browser2;
        }
        return null;
    }

    @NotNull
    public WebBrowser getFirstBrowser(@NotNull BrowserFamily family) {
        WebBrowser result2 = this.getFirstBrowserOrNull(family);
        if (result2 == null) {
            throw new IllegalStateException("Must be at least one browser per family");
        }
        return result2;
    }

    public boolean isActive(@NotNull WebBrowser browser2) {
        return !(browser2 instanceof ConfigurableWebBrowser) || ((ConfigurableWebBrowser)browser2).isActive();
    }

    @Nullable
    public WebBrowser getFirstActiveBrowser() {
        for (ConfigurableWebBrowser browser2 : this.browsers) {
            if (!browser2.isActive() || browser2.getPath() == null) continue;
            return browser2;
        }
        return null;
    }

    public void setShowBrowserHover(boolean showBrowserHover) {
        this.myShowBrowserHover = showBrowserHover;
    }

    public boolean isShowBrowserHover() {
        return this.myShowBrowserHover;
    }
}

