/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserAction;
import com.intellij.ide.browsers.actions.OpenFileInDefaultBrowserAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ComputableActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.util.CachedValueProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class OpenInBrowserBaseGroupAction
extends ComputableActionGroup {
    private OpenFileInDefaultBrowserAction myDefaultBrowserAction;

    protected OpenInBrowserBaseGroupAction(boolean popup2) {
        super(popup2);
        Presentation p = this.getTemplatePresentation();
        p.setText("Open in _Browser");
        p.setDescription("Open selected file in browser");
        p.setIcon(AllIcons.Nodes.PpWeb);
    }

    @Override
    @NotNull
    protected final CachedValueProvider<AnAction[]> createChildrenProvider(@NotNull ActionManager actionManager) {
        return () -> {
            List<WebBrowser> browsers = WebBrowserManager.getInstance().getBrowsers();
            boolean addDefaultBrowser = this.isPopup();
            int offset = addDefaultBrowser ? 1 : 0;
            AnAction[] actions = new AnAction[browsers.size() + offset];
            if (addDefaultBrowser) {
                if (this.myDefaultBrowserAction == null) {
                    this.myDefaultBrowserAction = new OpenFileInDefaultBrowserAction();
                    this.myDefaultBrowserAction.getTemplatePresentation().setText("Default");
                    this.myDefaultBrowserAction.getTemplatePresentation().setIcon(AllIcons.Nodes.PpWeb);
                }
                actions[0] = this.myDefaultBrowserAction;
            }
            int size = browsers.size();
            for (int i = 0; i < size; ++i) {
                actions[i + offset] = new BaseOpenInBrowserAction(browsers.get(i));
            }
            return CachedValueProvider.Result.create((Object)actions, (Object[])new Object[]{WebBrowserManager.getInstance()});
        };
    }

    public static final class OpenInBrowserEditorContextBarGroupAction
    extends OpenInBrowserBaseGroupAction {
        public OpenInBrowserEditorContextBarGroupAction() {
            super(false);
        }

        public void update(@NotNull AnActionEvent e) {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
            WebBrowserManager browserManager = WebBrowserManager.getInstance();
            e.getPresentation().setVisible(browserManager.isShowBrowserHover() && !browserManager.getActiveBrowsers().isEmpty() && editor != null && !DiffUtil.isDiffEditor(editor));
        }
    }

    public static final class OpenInBrowserGroupAction
    extends OpenInBrowserBaseGroupAction {
        public OpenInBrowserGroupAction() {
            super(true);
        }
    }
}

