/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.commander;

import com.intellij.ide.CopyPasteUtil;
import com.intellij.ide.commander.AbstractListBuilder;
import com.intellij.ide.commander.ColoredCommanderRenderer;
import com.intellij.ide.commander.CommanderPanel;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectListBuilder
extends AbstractListBuilder {
    private final MyPsiTreeChangeListener myPsiTreeChangeListener;
    private final MyFileStatusListener myFileStatusListener;
    private final CopyPasteManager.ContentChangedListener myCopyPasteListener;
    private final Alarm myUpdateAlarm;

    public ProjectListBuilder(Project project, CommanderPanel panel2, AbstractTreeStructure treeStructure, Comparator comparator2, boolean showRoot) {
        super(project, panel2.getList(), panel2.getModel(), treeStructure, comparator2, showRoot);
        this.myList.setCellRenderer(new ColoredCommanderRenderer(panel2));
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myProject);
        this.myPsiTreeChangeListener = new MyPsiTreeChangeListener();
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeListener);
        this.myFileStatusListener = new MyFileStatusListener();
        FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener((FileStatusListener)this.myFileStatusListener);
        this.myCopyPasteListener = new MyCopyPasteListener();
        CopyPasteManager.getInstance().addContentChangedListener(this.myCopyPasteListener);
        this.buildRoot();
    }

    @Override
    protected void updateParentTitle() {
        if (this.myParentTitle == null) {
            return;
        }
        AbstractTreeNode node = this.getParentNode();
        if (node instanceof ProjectViewNode) {
            this.myParentTitle.setText(((ProjectViewNode)node).getTitle());
        } else {
            this.myParentTitle.setText(null);
        }
    }

    @Override
    protected boolean shouldEnterSingleTopLevelElement(Object rootChild) {
        return true;
    }

    @Override
    protected boolean nodeIsAcceptableForElement(AbstractTreeNode node, Object element) {
        return Comparing.equal((Object)node.getValue(), (Object)element);
    }

    @Override
    protected List<AbstractTreeNode> getAllAcceptableNodes(Object[] childElements, VirtualFile file2) {
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
        for (Object childElement1 : childElements) {
            ProjectViewNode childElement = (ProjectViewNode)childElement1;
            if (!childElement.contains(file2)) continue;
            result2.add((AbstractTreeNode)childElement);
        }
        return result2;
    }

    @Override
    public void dispose() {
        super.dispose();
        PsiManager.getInstance((Project)this.myProject).removePsiTreeChangeListener((PsiTreeChangeListener)this.myPsiTreeChangeListener);
        FileStatusManager.getInstance((Project)this.myProject).removeFileStatusListener((FileStatusListener)this.myFileStatusListener);
        CopyPasteManager.getInstance().removeContentChangedListener(this.myCopyPasteListener);
    }

    public void addUpdateRequest() {
        this.addUpdateRequest(false);
    }

    public void addUpdateRequest(final boolean shouldRefreshSelection) {
        Runnable request = new Runnable(){

            @Override
            public void run() {
                if (!ProjectListBuilder.this.myProject.isDisposed()) {
                    if (ProjectListBuilder.this.myTreeStructure.hasSomethingToCommit()) {
                        ProjectListBuilder.this.myUpdateAlarm.cancelAllRequests();
                        ProjectListBuilder.this.myUpdateAlarm.addRequest((Runnable)this, 300, ModalityState.stateForComponent((Component)ProjectListBuilder.this.myList));
                        return;
                    }
                    ProjectListBuilder.this.updateList(shouldRefreshSelection);
                }
            }
        };
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.myUpdateAlarm.cancelAllRequests();
            this.myUpdateAlarm.addRequest(request, 300, ModalityState.stateForComponent((Component)this.myList));
        } else {
            request.run();
        }
    }

    public void updateList(boolean shouldRefreshSelection) {
        this.updateList();
        if (shouldRefreshSelection) {
            this.refreshSelection();
        }
    }

    protected void refreshSelection() {
    }

    private final class MyCopyPasteListener
    implements CopyPasteManager.ContentChangedListener {
        private MyCopyPasteListener() {
        }

        public void contentChanged(Transferable oldTransferable, Transferable newTransferable) {
            this.updateByTransferable(oldTransferable);
            this.updateByTransferable(newTransferable);
        }

        private void updateByTransferable(Transferable t) {
            PsiElement[] psiElements = CopyPasteUtil.getElementsInTransferable(t);
            for (int i = 0; i < psiElements.length; ++i) {
                ProjectListBuilder.this.myPsiTreeChangeListener.childrenChanged();
            }
        }
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            ProjectListBuilder.this.addUpdateRequest();
        }

        public void fileStatusChanged(@NotNull VirtualFile vFile) {
            PsiFileSystemItem item = PsiUtilCore.findFileSystemItem((Project)ProjectListBuilder.this.myProject, (VirtualFile)vFile);
            if (item != null) {
                ProjectListBuilder.this.myPsiTreeChangeListener.childrenChanged();
            }
        }
    }

    private final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private final PsiModificationTracker myModificationTracker;
        private long myOutOfCodeBlockModificationCount;

        private MyPsiTreeChangeListener() {
            this.myModificationTracker = PsiManager.getInstance((Project)ProjectListBuilder.this.myProject).getModificationTracker();
            this.myOutOfCodeBlockModificationCount = this.myModificationTracker.getOutOfCodeBlockModificationCount();
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            PsiElement child2 = event.getOldChild();
            if (child2 instanceof PsiWhiteSpace) {
                return;
            }
            this.childrenChanged();
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            PsiElement child2 = event.getNewChild();
            if (child2 instanceof PsiWhiteSpace) {
                return;
            }
            this.childrenChanged();
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            PsiElement oldChild = event.getOldChild();
            PsiElement newChild = event.getNewChild();
            if (oldChild instanceof PsiWhiteSpace && newChild instanceof PsiWhiteSpace) {
                return;
            }
            this.childrenChanged();
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            this.childrenChanged();
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            this.childrenChanged();
        }

        private void childrenChanged() {
            long newModificationCount = this.myModificationTracker.getOutOfCodeBlockModificationCount();
            if (newModificationCount == this.myOutOfCodeBlockModificationCount) {
                return;
            }
            this.myOutOfCodeBlockModificationCount = newModificationCount;
            ProjectListBuilder.this.addUpdateRequest();
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            String propertyName = event.getPropertyName();
            if (propertyName.equals("roots")) {
                ProjectListBuilder.this.addUpdateRequest();
            } else if (propertyName.equals("writable")) {
                this.childrenChanged();
            } else if (propertyName.equals("fileName") || propertyName.equals("directoryName")) {
                this.childrenChanged();
            } else if (propertyName.equals("propFileTypes")) {
                ProjectListBuilder.this.addUpdateRequest();
            }
        }
    }
}

