/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.ui.ClickListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCustomizeWizardStep
extends JPanel {
    protected static final int SMALL_GAP = 10;
    protected static final int GAP = 20;

    protected abstract String getTitle();

    protected abstract String getHTMLHeader();

    @Nullable
    protected String getHTMLFooter() {
        return null;
    }

    @NotNull
    protected static Color getSelectionBackground() {
        return ColorUtil.mix((Color)UIUtil.getListSelectionBackground(), (Color)UIUtil.getLabelBackground(), (double)(UIUtil.isUnderDarcula() ? 0.5 : 0.75));
    }

    public static Border createSmallEmptyBorder() {
        return BorderFactory.createEmptyBorder(10, 10, 10, 10);
    }

    public static BorderLayout createSmallBorderLayout() {
        return new BorderLayout(10, 10);
    }

    public static void applyHeaderFooterStyle(@NotNull JBLabel label2) {
        label2.setForeground(UIUtil.getLabelDisabledForeground());
    }

    protected static JPanel createBigButtonPanel(LayoutManager layout, final JToggleButton anchorButton, final Runnable action) {
        final JPanel panel2 = new JPanel(layout){

            @Override
            public Color getBackground() {
                return anchorButton.isSelected() ? AbstractCustomizeWizardStep.getSelectionBackground() : super.getBackground();
            }
        };
        panel2.setOpaque(anchorButton.isSelected());
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                anchorButton.setSelected(true);
                return true;
            }
        }.installOn((Component)panel2);
        anchorButton.addItemListener(new ItemListener(){
            boolean curState;
            {
                this.curState = anchorButton.isSelected();
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && this.curState != anchorButton.isSelected()) {
                    action.run();
                }
                this.curState = anchorButton.isSelected();
                panel2.setOpaque(this.curState);
                panel2.repaint();
            }
        });
        return panel2;
    }

    Component getDefaultFocusedComponent() {
        return null;
    }

    public void beforeShown(boolean forward) {
    }

    public boolean beforeOkAction() {
        return true;
    }
}

