/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class TransferableList<T>
implements Transferable {
    private static final DataFlavor LIST_DATA_FLAVOR = new DataFlavor(List.class, "Transferable List");
    private static final DataFlavor ALL_HTML_DATA_FLAVOR = DataFlavor.allHtmlFlavor;
    private static final DataFlavor PART_HTML_DATA_FLAVOR = DataFlavor.fragmentHtmlFlavor;
    private final List<T> myList;

    @SafeVarargs
    public TransferableList(T ... array) {
        this(Arrays.asList(array));
    }

    public TransferableList(List<? extends T> list2) {
        this.myList = Collections.unmodifiableList(list2);
    }

    @Override
    @NotNull
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{ALL_HTML_DATA_FLAVOR, PART_HTML_DATA_FLAVOR, DataFlavor.stringFlavor, LIST_DATA_FLAVOR};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor supported : this.getTransferDataFlavors()) {
            if (!supported.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(ALL_HTML_DATA_FLAVOR)) {
            return this.getHTML(this.myList, true);
        }
        if (flavor.equals(PART_HTML_DATA_FLAVOR)) {
            return this.getHTML(this.myList, false);
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.getText(this.myList);
        }
        if (flavor.equals(LIST_DATA_FLAVOR)) {
            return this.myList;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    protected String getHTML(List<T> list2, boolean all) {
        StringBuilder sb = new StringBuilder();
        if (all) {
            sb.append("<html><body>");
        }
        sb.append("<ul>\n");
        for (T object : list2) {
            sb.append("  <li>").append(this.toHTML(object)).append("</li>\n");
        }
        sb.append("</ul>");
        if (all) {
            sb.append("</body></html>");
        }
        return sb.toString();
    }

    protected String getText(List<T> list2) {
        StringBuilder sb = new StringBuilder();
        for (T object : list2) {
            sb.append(this.toString(object)).append('\n');
        }
        return sb.toString();
    }

    protected String toHTML(T object) {
        return this.toString(object);
    }

    protected abstract String toString(T var1);
}

