/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.extensionResources;

import com.intellij.ide.extensionResources.ResourceVersions;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtensionsRootType
extends RootType {
    static final Logger LOG = Logger.getInstance(ExtensionsRootType.class);
    private static final String HASH_ALGORITHM = "MD5";
    private static final String EXTENSIONS_PATH = "extensions";
    private static final String BACKUP_FILE_EXTENSION = "old";

    ExtensionsRootType() {
        super(EXTENSIONS_PATH, "Extensions");
    }

    @NotNull
    public static ExtensionsRootType getInstance() {
        return (ExtensionsRootType)ExtensionsRootType.findByClass(ExtensionsRootType.class);
    }

    @NotNull
    public static Condition<File> regularFileFilter() {
        return new Condition<File>(){
            private final ExtensionsRootType myRootType = ExtensionsRootType.getInstance();

            public boolean value(File file2) {
                if (file2.isDirectory() || file2.isHidden()) {
                    return false;
                }
                String name = file2.getName();
                String extension = FileUtilRt.getExtension((String)name);
                return !extension.isEmpty() && !FileUtilRt.extensionEquals((String)name, (String)"txt") && !FileUtilRt.extensionEquals((String)name, (String)"properties") && !extension.startsWith(ExtensionsRootType.BACKUP_FILE_EXTENSION) && !this.myRootType.isResourceFile(file2);
            }
        };
    }

    @Nullable
    public PluginId getOwner(@Nullable VirtualFile resource) {
        VirtualFile file2 = this.getPluginResourcesDirectoryFor(resource);
        return file2 != null ? PluginId.findId((String[])new String[]{file2.getName()}) : null;
    }

    @Nullable
    public File findResource(@NotNull PluginId pluginId, @NotNull String path) throws IOException {
        this.extractBundledExtensionsIfNeeded(pluginId);
        return this.findExtensionImpl(pluginId, path);
    }

    @Nullable
    public File findResourceDirectory(@NotNull PluginId pluginId, @NotNull String path, boolean createIfMissing) throws IOException {
        this.extractBundledExtensionsIfNeeded(pluginId);
        return this.findExtensionsDirectoryImpl(pluginId, path, createIfMissing);
    }

    public void extractBundledResources(@NotNull PluginId pluginId, @NotNull String path) throws IOException {
        List<URL> bundledResources = ExtensionsRootType.getBundledResourceUrls(pluginId, path);
        if (bundledResources.isEmpty()) {
            return;
        }
        File resourcesDirectory = this.findExtensionsDirectoryImpl(pluginId, path, true);
        if (resourcesDirectory == null) {
            return;
        }
        for (URL bundledResourceDirUrl : bundledResources) {
            VirtualFile bundledResourcesDir = VfsUtil.findFileByURL((URL)bundledResourceDirUrl);
            if (bundledResourcesDir == null || !bundledResourcesDir.isDirectory()) continue;
            ExtensionsRootType.extractResources(bundledResourcesDir, resourcesDirectory);
        }
    }

    @Nullable
    public String substituteName(@NotNull Project project, @NotNull VirtualFile file2) {
        String name;
        VirtualFile resourcesDir = this.getPluginResourcesDirectoryFor(file2);
        if (file2.equals(resourcesDir) && (name = this.getPluginResourcesRootName(resourcesDir)) != null) {
            return name;
        }
        return super.substituteName(project, file2);
    }

    public boolean isResourceFile(@NotNull File file2) {
        return false;
    }

    @Nullable
    String getPath(@Nullable VirtualFile resource) {
        VirtualFile pluginResourcesDir = this.getPluginResourcesDirectoryFor(resource);
        PluginId pluginId = this.getOwner(pluginResourcesDir);
        return pluginResourcesDir != null && pluginId != null ? VfsUtilCore.getRelativePath((VirtualFile)resource, (VirtualFile)pluginResourcesDir) : null;
    }

    @Nullable
    private File findExtensionImpl(@NotNull PluginId pluginId, @NotNull String path) throws IOException {
        File dir = this.findExtensionsDirectoryImpl(pluginId, "", false);
        File file2 = dir == null ? null : new File(dir, path);
        return file2 != null && file2.exists() && file2.isFile() ? file2 : null;
    }

    @Nullable
    private File findExtensionsDirectoryImpl(@NotNull PluginId pluginId, @NotNull String path, boolean createIfMissing) throws IOException {
        String fullPath = this.getPath(pluginId, path);
        File dir = new File(FileUtil.toSystemDependentName((String)fullPath));
        if (createIfMissing && !dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory: " + dir.getPath());
        }
        if (!dir.exists()) {
            return null;
        }
        if (!dir.isDirectory()) {
            throw new IOException("Not a directory: " + dir.getPath());
        }
        return dir;
    }

    @Nullable
    private String getPluginResourcesRootName(VirtualFile resourcesDir) {
        PluginId ownerPluginId = this.getOwner(resourcesDir);
        if (ownerPluginId == null) {
            return null;
        }
        if ("com.intellij".equals(ownerPluginId.getIdString())) {
            return PlatformUtils.getPlatformPrefix();
        }
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(ownerPluginId);
        if (plugin != null) {
            return plugin.getName();
        }
        return null;
    }

    @Contract(value="null->null")
    private VirtualFile getPluginResourcesDirectoryFor(@Nullable VirtualFile resource) {
        if (resource == null) {
            return null;
        }
        String rootPath = ScratchFileService.getInstance().getRootPath((RootType)this);
        VirtualFile root = LocalFileSystem.getInstance().findFileByPath(rootPath);
        if (root == null) {
            return null;
        }
        VirtualFile parent = resource;
        VirtualFile file2 = resource;
        while (parent != null && !root.equals(parent)) {
            file2 = parent;
            parent = file2.getParent();
        }
        return parent != null && file2.isDirectory() ? file2 : null;
    }

    @NotNull
    private String getPath(@NotNull PluginId pluginId, @NotNull String path) {
        return ScratchFileService.getInstance().getRootPath((RootType)this) + "/" + pluginId.getIdString() + (StringUtil.isEmpty((String)path) ? "" : "/" + path);
    }

    @NotNull
    private static List<URL> getBundledResourceUrls(@NotNull PluginId pluginId, @NotNull String path) throws IOException {
        LinkedHashSet urls;
        String resourcesPath = "extensions/" + path;
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
        ClassLoader pluginClassLoader = plugin != null ? plugin.getPluginClassLoader() : null;
        LinkedHashSet linkedHashSet = urls = plugin == null ? null : ContainerUtil.newLinkedHashSet((Iterable)ContainerUtil.toList(pluginClassLoader.getResources(resourcesPath)));
        if (urls == null) {
            return ContainerUtil.emptyList();
        }
        PluginId corePluginId = PluginId.findId((String[])new String[]{"com.intellij"});
        IdeaPluginDescriptor corePlugin = (IdeaPluginDescriptor)ObjectUtils.notNull((Object)PluginManager.getPlugin(corePluginId));
        ClassLoader coreClassLoader = corePlugin.getPluginClassLoader();
        if (coreClassLoader != pluginClassLoader && !plugin.getUseIdeaClassLoader() && !pluginId.equals(corePluginId)) {
            urls.removeAll(ContainerUtil.toList(coreClassLoader.getResources(resourcesPath)));
        }
        return ContainerUtil.newArrayList((Iterable)urls);
    }

    private static void extractResources(final @NotNull VirtualFile from, final @NotNull File to) throws IOException {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)from, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                try {
                    return this.visitImpl(file2);
                }
                catch (IOException e) {
                    throw new VirtualFileVisitor.VisitorException((Throwable)e);
                }
            }

            VirtualFileVisitor.Result visitImpl(@NotNull VirtualFile file2) throws IOException {
                boolean upToDate;
                File dir;
                File child2 = new File(to, FileUtil.toSystemDependentName((String)((String)ObjectUtils.notNull((Object)VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)from)))));
                if (child2.exists() && child2.isDirectory() != file2.isDirectory()) {
                    ExtensionsRootType.renameToBackupCopy(child2);
                }
                File file3 = dir = file2.isDirectory() ? child2 : child2.getParentFile();
                if (!dir.exists() && !dir.mkdirs()) {
                    LOG.warn("Failed to create dir: " + dir.getPath());
                    return SKIP_CHILDREN;
                }
                if (file2.isDirectory()) {
                    return CONTINUE;
                }
                if (file2.getFileType().isBinary()) {
                    return CONTINUE;
                }
                if (file2.getLength() > (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
                    return CONTINUE;
                }
                String newText = FileUtil.loadTextAndClose((InputStream)file2.getInputStream());
                String oldText = child2.exists() ? FileUtil.loadFile((File)child2) : "";
                String newHash = ExtensionsRootType.hash(newText);
                String oldHash = ExtensionsRootType.hash(oldText);
                boolean bl = upToDate = oldHash != null && newHash != null && StringUtil.equals((CharSequence)oldHash, (CharSequence)newHash);
                if (upToDate) {
                    return CONTINUE;
                }
                if (child2.exists()) {
                    ExtensionsRootType.renameToBackupCopy(child2);
                }
                FileUtil.writeToFile((File)child2, (String)newText);
                return CONTINUE;
            }
        }, IOException.class);
    }

    @Nullable
    private static String hash(@NotNull String s) {
        try {
            byte[] digest;
            MessageDigest md5 = MessageDigest.getInstance(HASH_ALGORITHM);
            StringBuilder sb = new StringBuilder();
            for (byte b : digest = md5.digest(s.getBytes(CharsetToolkit.UTF8_CHARSET))) {
                sb.append(Integer.toHexString(b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Hash algorithm MD5 is not supported", (Throwable)e);
            return null;
        }
    }

    private static void renameToBackupCopy(@NotNull File file2) throws IOException {
        File parent = file2.getParentFile();
        int i = 0;
        String newName = file2.getName() + "." + BACKUP_FILE_EXTENSION;
        while (new File(parent, newName).exists()) {
            newName = file2.getName() + "." + BACKUP_FILE_EXTENSION + "_" + i;
            ++i;
        }
        FileUtil.rename((File)file2, (String)newName);
    }

    private void extractBundledExtensionsIfNeeded(@NotNull PluginId pluginId) throws IOException {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return;
        }
        IdeaPluginDescriptor plugin = PluginManager.getPlugin(pluginId);
        if (plugin == null || !ResourceVersions.getInstance().shouldUpdateResourcesOf(plugin)) {
            return;
        }
        this.extractBundledResources(pluginId, "");
        ResourceVersions.getInstance().resourcesUpdated(plugin);
    }
}

