/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.externalComponents;

import com.intellij.ide.externalComponents.ExternalComponentManager;
import com.intellij.ide.externalComponents.ExternalComponentSource;
import com.intellij.ide.externalComponents.UpdatableExternalComponent;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalComponentManagerImpl
extends ExternalComponentManager {
    private final Set<ExternalComponentSource> mySources = new HashSet<ExternalComponentSource>();

    @Override
    @NotNull
    public Iterable<ExternalComponentSource> getComponentSources() {
        return this.mySources;
    }

    @Override
    public void registerComponentSource(@NotNull ExternalComponentSource site) {
        this.mySources.add(site);
        UpdateSettings updateSettings = UpdateSettings.getInstance();
        List<String> knownSources = updateSettings.getKnownExternalUpdateSources();
        if (!knownSources.contains(site.getName())) {
            knownSources.add(site.getName());
            updateSettings.getEnabledExternalUpdateSources().add(site.getName());
            List<String> channels = site.getAllChannels();
            if (channels != null) {
                updateSettings.getExternalUpdateChannels().put(site.getName(), channels.get(0));
            }
        }
    }

    @Override
    @Nullable
    public UpdatableExternalComponent findExistingComponentMatching(@NotNull UpdatableExternalComponent update, @NotNull ExternalComponentSource source) {
        Collection<UpdatableExternalComponent> existing = source.getCurrentVersions();
        for (UpdatableExternalComponent c : existing) {
            if (!update.isUpdateFor(c)) continue;
            return c;
        }
        return null;
    }
}

