/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFavoritesListProvider<T>
implements FavoritesListProvider {
    public static final int BOOKMARKS_WEIGHT = 100;
    public static final int BREAKPOINTS_WEIGHT = 200;
    public static final int TASKS_WEIGHT = 300;
    protected final Project myProject;
    private final String myListName;
    protected final List<AbstractTreeNode<T>> myChildren = new ArrayList<AbstractTreeNode<T>>();
    protected final FavoritesListNode myNode;

    protected AbstractFavoritesListProvider(@NotNull Project project, @NotNull String listName) {
        this(project, listName, null);
    }

    protected AbstractFavoritesListProvider(@NotNull Project project, @NotNull String listName, @Nullable String description) {
        this.myProject = project;
        this.myListName = listName;
        this.myNode = new FavoritesListNode(project, listName, description){

            @Override
            @NotNull
            public Collection<? extends AbstractTreeNode> getChildren() {
                return AbstractFavoritesListProvider.this.myChildren;
            }

            @Override
            public FavoritesListProvider getProvider() {
                return AbstractFavoritesListProvider.this;
            }
        };
    }

    @Override
    public String getListName(Project project) {
        return this.myListName;
    }

    @Override
    @Nullable
    public FavoritesListNode createFavoriteListNode(Project project) {
        return this.myNode;
    }

    @Override
    public int compare(FavoritesTreeNodeDescriptor o1, FavoritesTreeNodeDescriptor o2) {
        return o1.getIndex() - o2.getIndex();
    }

    @Override
    @Nullable
    public String getCustomName(@NotNull CommonActionsPanel.Buttons type) {
        return null;
    }

    @Override
    public boolean willHandle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects) {
        return false;
    }

    @Override
    public void handle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects, JComponent component) {
    }

    @Override
    public int compareTo(FavoritesListProvider o) {
        return Integer.compare(this.getWeight(), o.getWeight());
    }

    @Override
    public void customizeRenderer(ColoredTreeCellRenderer renderer2, JTree tree, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
    }
}

