/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.FileEditorSelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesViewSelectInTarget;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.util.ObjectUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FavoritesAutoscrollFromSourceHandler
extends AutoScrollFromSourceHandler {
    private final FavoritesViewSelectInTarget mySelectInTarget;

    public FavoritesAutoscrollFromSourceHandler(@NotNull Project project, @NotNull FavoritesViewTreeBuilder builder2) {
        super(project, (JComponent)ObjectUtils.assertNotNull((Object)builder2.getTree()), (Disposable)builder2);
        this.mySelectInTarget = new FavoritesViewSelectInTarget(this.myProject);
    }

    protected boolean isAutoScrollEnabled() {
        return FavoritesManager.getInstance(this.myProject).getViewSettings().isAutoScrollFromSource();
    }

    protected void setAutoScrollEnabled(boolean enabled) {
        FavoritesManager.getInstance(this.myProject).getViewSettings().setAutoScrollFromSource(enabled);
    }

    protected void selectElementFromEditor(@NotNull FileEditor editor) {
        PsiFile psiFile;
        VirtualFile file2 = FileEditorManagerEx.getInstanceEx(this.myProject).getFile(editor);
        PsiFile psiFile2 = psiFile = file2 == null ? null : PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (psiFile != null) {
            new FileEditorSelectInContext(editor, psiFile).selectIn((SelectInTarget)this.mySelectInTarget, false);
        }
    }
}

