/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.favoritesTreeView.AbstractUrlFavoriteAdapter;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.ProjectViewNodeWithChildrenList;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.TreeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FavoritesListNode
extends AbstractTreeNode<String> {
    private static final Logger LOGGER = Logger.getInstance(FavoritesListNode.class);
    private final Project myProject;
    private final String myDescription;

    public FavoritesListNode(Project project, @NotNull String listName, String description) {
        super(project, (Object)listName);
        this.myProject = project;
        this.myName = listName;
        this.myDescription = description;
    }

    public FavoritesListNode(Project project, @NotNull String listName) {
        this(project, listName, null);
    }

    public FavoritesListProvider getProvider() {
        return null;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        return FavoritesListNode.getFavoritesRoots(this.myProject, this.myName, this);
    }

    protected void update(@NotNull PresentationData presentation) {
        presentation.setIcon(AllIcons.Toolwindows.ToolWindowFavorites);
        presentation.setPresentableText(this.myName);
        presentation.setLocationString(this.myDescription);
    }

    @NotNull
    public static Collection<AbstractTreeNode> getFavoritesRoots(Project project, String listName, FavoritesListNode listNode) {
        List<TreeItem<Pair<AbstractUrl, String>>> pairs = FavoritesManager.getInstance(project).getFavoritesListRootUrls(listName);
        if (pairs.isEmpty()) {
            return Collections.emptyList();
        }
        return FavoritesListNode.createFavoriteRoots(project, pairs, listNode);
    }

    @NotNull
    private static Collection<AbstractTreeNode> createFavoriteRoots(Project project, @NotNull Collection<? extends TreeItem<Pair<AbstractUrl, String>>> urls, AbstractTreeNode me) {
        ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
        FavoritesListNode.processUrls(project, urls, result2, me);
        return result2;
    }

    private static void processUrls(Project project, Collection<? extends TreeItem<Pair<AbstractUrl, String>>> urls, Collection<? super AbstractTreeNode> result2, AbstractTreeNode me) {
        for (TreeItem<Pair<AbstractUrl, String>> treeItem : urls) {
            AbstractUrl abstractUrl = (AbstractUrl)((Pair)treeItem.getData()).getFirst();
            Object[] path = abstractUrl.createPath(project);
            if (path == null || path.length < 1 || path[0] == null) continue;
            try {
                List children2;
                ClassLoader loader;
                if (abstractUrl instanceof AbstractUrlFavoriteAdapter) {
                    FavoriteNodeProvider provider = ((AbstractUrlFavoriteAdapter)abstractUrl).getNodeProvider();
                    loader = provider.getClass().getClassLoader();
                } else {
                    loader = FavoritesListNode.class.getClassLoader();
                }
                String className = (String)((Pair)treeItem.getData()).getSecond();
                Class<?> nodeClass = loader.loadClass(className);
                AbstractTreeNode node = ProjectViewNode.createTreeNode(nodeClass, (Project)project, (Object)path[path.length - 1], (ViewSettings)FavoritesManager.getInstance(project).getViewSettings());
                node.setParent(me);
                node.setIndex(result2.size());
                result2.add((AbstractTreeNode)node);
                if (!(node instanceof ProjectViewNodeWithChildrenList) || (children2 = treeItem.getChildren()) == null || children2.isEmpty()) continue;
                ArrayList childList = new ArrayList();
                FavoritesListNode.processUrls(project, children2, childList, node);
                for (AbstractTreeNode treeNode : childList) {
                    ((ProjectViewNodeWithChildrenList)node).addChild(treeNode);
                }
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
            }
        }
    }
}

