/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesRootNode;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.SettingsProvider;
import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiDirectoryImpl;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class FavoritesTreeStructure
extends ProjectTreeStructure {
    private static final Logger LOGGER = Logger.getInstance(FavoritesTreeStructure.class);
    private TreeStructureProvider myNonProjectProvider = null;

    public FavoritesTreeStructure(@NotNull Project project) {
        super(project, "Favorites");
        this.myNonProjectProvider = new MyProvider(project);
    }

    @Override
    protected AbstractTreeNode createRoot(@NotNull Project project, @NotNull ViewSettings settings) {
        return new FavoritesRootNode(project);
    }

    public void rootsChanged() {
        ((FavoritesRootNode)((Object)this.getRootElement())).rootsChanged();
    }

    @Override
    @NotNull
    public Object[] getChildElements(@NotNull Object element) {
        if (!(element instanceof AbstractTreeNode)) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        AbstractTreeNode favTreeElement = (AbstractTreeNode)element;
        try {
            if (!(element instanceof FavoritesListNode)) {
                Object[] elements = super.getChildElements(favTreeElement);
                if (elements.length > 0) {
                    return elements;
                }
                ViewSettings settings = favTreeElement instanceof SettingsProvider ? ((SettingsProvider)favTreeElement).getSettings() : ViewSettings.DEFAULT;
                return ArrayUtil.toObjectArray((Collection)this.myNonProjectProvider.modify(favTreeElement, new ArrayList(), settings));
            }
            ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
            FavoritesListNode listNode = (FavoritesListNode)((Object)element);
            if (listNode.getProvider() != null) {
                return ArrayUtil.toObjectArray(listNode.getChildren());
            }
            Collection<AbstractTreeNode> roots = FavoritesListNode.getFavoritesRoots(this.myProject, listNode.getName(), listNode);
            for (AbstractTreeNode abstractTreeNode : roots) {
                Object value = abstractTreeNode.getValue();
                if (value == null || value instanceof PsiElement && !((PsiElement)value).isValid() || value instanceof SmartPsiElementPointer && ((SmartPsiElementPointer)value).getElement() == null) continue;
                boolean invalid = false;
                for (FavoriteNodeProvider nodeProvider : (FavoriteNodeProvider[])FavoriteNodeProvider.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
                    if (!nodeProvider.isInvalidElement(value)) continue;
                    invalid = true;
                    break;
                }
                if (invalid) continue;
                result2.add(abstractTreeNode);
            }
            return ArrayUtil.toObjectArray(result2);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }

    private AbstractTreeNode<String> getEmptyScreen() {
        return new AbstractTreeNode<String>(this.myProject, IdeBundle.message((String)"favorites.empty.screen", (Object[])new Object[0])){

            @NotNull
            public Collection<AbstractTreeNode> getChildren() {
                return Collections.emptyList();
            }

            public void update(@NotNull PresentationData presentation) {
                presentation.setPresentableText((String)this.getValue());
            }
        };
    }

    @Override
    public Object getParentElement(@NotNull Object element) {
        AbstractTreeNode parent = null;
        if (element == this.getRootElement()) {
            return null;
        }
        if (element instanceof AbstractTreeNode) {
            parent = ((AbstractTreeNode)element).getParent();
        }
        if (parent == null) {
            return this.getRootElement();
        }
        return parent;
    }

    @Override
    @NotNull
    public NodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        return new FavoritesTreeNodeDescriptor(this.myProject, parentDescriptor, (AbstractTreeNode)element);
    }

    private static class MyProvider
    implements TreeStructureProvider {
        private final Project myProject;

        MyProvider(Project project) {
            this.myProject = project;
        }

        @NotNull
        public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children2, ViewSettings settings) {
            if (parent instanceof PsiDirectoryNode && children2.isEmpty()) {
                VirtualFile virtualFile = ((PsiDirectoryNode)parent).getVirtualFile();
                if (virtualFile == null) {
                    return children2;
                }
                VirtualFile[] virtualFiles = virtualFile.getChildren();
                ArrayList<AbstractTreeNode> result2 = new ArrayList<AbstractTreeNode>();
                PsiManagerImpl psiManager = (PsiManagerImpl)PsiManager.getInstance((Project)this.myProject);
                for (VirtualFile file2 : virtualFiles) {
                    BasePsiNode child2;
                    if (file2.isDirectory()) {
                        child2 = new PsiDirectoryNode(this.myProject, new PsiDirectoryImpl(psiManager, file2), settings);
                    } else {
                        PsiFile psiFile = psiManager.findFile(file2);
                        if (psiFile == null) continue;
                        child2 = new PsiFileNode(this.myProject, psiFile, settings);
                    }
                    child2.setParent(parent);
                    result2.add((AbstractTreeNode)child2);
                }
                return result2;
            }
            return children2;
        }
    }
}

