/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ProjectTopics;
import com.intellij.ide.CopyPasteUtil;
import com.intellij.ide.favoritesTreeView.FavoritesComparator;
import com.intellij.ide.favoritesTreeView.FavoritesListener;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesTreeStructure;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ProjectViewPsiTreeChangeListener;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.tree.TreeUtil;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class FavoritesViewTreeBuilder
extends BaseProjectTreeBuilder {
    public FavoritesViewTreeBuilder(@NotNull Project project, JTree tree, DefaultTreeModel treeModel, ProjectAbstractTreeStructureBase treeStructure) {
        super(project, tree, treeModel, treeStructure, new FavoritesComparator(ProjectView.getInstance(project), "Favorites"));
        MessageBusConnection bus = this.myProject.getMessageBus().connect((Disposable)this);
        ProjectViewPsiTreeChangeListener psiTreeChangeListener = new ProjectViewPsiTreeChangeListener(this.myProject){

            @Override
            protected DefaultMutableTreeNode getRootNode() {
                return FavoritesViewTreeBuilder.this.getRootNode();
            }

            @Override
            protected AbstractTreeUpdater getUpdater() {
                return FavoritesViewTreeBuilder.this.getUpdater();
            }

            @Override
            protected boolean isFlattenPackages() {
                return FavoritesViewTreeBuilder.this.getStructure().isFlattenPackages();
            }

            @Override
            protected void childrenChanged(PsiElement parent, boolean stopProcessingForThisModificationCount) {
                PsiElement containingFile;
                Object object = containingFile = parent instanceof PsiDirectory ? parent : parent.getContainingFile();
                if (containingFile != null && FavoritesViewTreeBuilder.this.findNodeByElement(containingFile) == null) {
                    FavoritesViewTreeBuilder.this.queueUpdate(true);
                } else {
                    super.childrenChanged(parent, true);
                }
            }
        };
        bus.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                FavoritesViewTreeBuilder.this.queueUpdate(true);
            }
        });
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)psiTreeChangeListener, (Disposable)this);
        MyFileStatusListener fileStatusListener = new MyFileStatusListener();
        FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener((FileStatusListener)fileStatusListener, (Disposable)this);
        CopyPasteUtil.addDefaultListener((Disposable)this, arg_0 -> ((FavoritesViewTreeBuilder)this).addSubtreeToUpdateByElement(arg_0));
        FavoritesListener favoritesListener = new FavoritesListener(){

            @Override
            public void rootsChanged() {
                FavoritesViewTreeBuilder.this.updateFromRoot();
            }

            @Override
            public void listAdded(@NotNull String listName) {
                FavoritesViewTreeBuilder.this.updateFromRoot();
            }

            @Override
            public void listRemoved(@NotNull String listName) {
                FavoritesViewTreeBuilder.this.updateFromRoot();
            }
        };
        this.initRootNode();
        FavoritesManager.getInstance(this.myProject).addFavoritesListener(favoritesListener, (Disposable)this);
    }

    @NotNull
    public FavoritesTreeStructure getStructure() {
        AbstractTreeStructure structure = this.getTreeStructure();
        assert (structure instanceof FavoritesTreeStructure);
        return (FavoritesTreeStructure)structure;
    }

    public AbstractTreeNode getRoot() {
        Object rootElement = this.getRootElement();
        assert (rootElement instanceof AbstractTreeNode);
        return (AbstractTreeNode)rootElement;
    }

    public void updateFromRoot() {
        this.updateFromRootCB();
    }

    @NotNull
    public ActionCallback updateFromRootCB() {
        this.getStructure().rootsChanged();
        if (this.isDisposed()) {
            return ActionCallback.DONE;
        }
        this.getUpdater().cancelAllRequests();
        return this.queueUpdate();
    }

    @Override
    @NotNull
    public Promise<Object> selectAsync(Object element, VirtualFile file2, boolean requestFocus) {
        DefaultMutableTreeNode node = this.findSmartFirstLevelNodeByElement(element);
        if (node != null) {
            return Promises.toPromise((ActionCallback)TreeUtil.selectInTree((DefaultMutableTreeNode)node, (boolean)requestFocus, (JTree)this.getTree()));
        }
        return super.selectAsync(element, file2, requestFocus);
    }

    @Nullable
    private static DefaultMutableTreeNode findFirstLevelNodeWithObject(DefaultMutableTreeNode aRoot, Object aObject) {
        for (int i = 0; i < aRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode child2 = (DefaultMutableTreeNode)aRoot.getChildAt(i);
            Object userObject = child2.getUserObject();
            if (!(userObject instanceof FavoritesTreeNodeDescriptor) || !Comparing.equal((Object)((FavoritesTreeNodeDescriptor)((Object)userObject)).getElement(), (Object)aObject)) continue;
            return child2;
        }
        return null;
    }

    protected Object findNodeByElement(@NotNull Object element) {
        DefaultMutableTreeNode node = this.findSmartFirstLevelNodeByElement(element);
        if (node != null) {
            return node;
        }
        return super.findNodeByElement(element);
    }

    @Nullable
    DefaultMutableTreeNode findSmartFirstLevelNodeByElement(Object element) {
        for (Object child2 : this.getRoot().getChildren()) {
            DefaultMutableTreeNode nodeWithObject;
            AbstractTreeNode favorite = (AbstractTreeNode)child2;
            Object currentValue = favorite.getValue();
            if (currentValue instanceof SmartPsiElementPointer) {
                currentValue = ((SmartPsiElementPointer)favorite.getValue()).getElement();
            }
            if (!Comparing.equal((Object)element, (Object)currentValue) || (nodeWithObject = FavoritesViewTreeBuilder.findFirstLevelNodeWithObject((DefaultMutableTreeNode)this.getTree().getModel().getRoot(), favorite)) == null) continue;
            return nodeWithObject;
        }
        return null;
    }

    @Override
    protected boolean isAlwaysShowPlus(NodeDescriptor nodeDescriptor) {
        Object[] childElements = this.getStructure().getChildElements(nodeDescriptor);
        return childElements != null && childElements.length > 0;
    }

    @Override
    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return nodeDescriptor.getParentDescriptor() == null;
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            FavoritesViewTreeBuilder.this.queueUpdateFrom(FavoritesViewTreeBuilder.this.getRootNode(), false);
        }

        public void fileStatusChanged(@NotNull VirtualFile vFile) {
            PsiFileSystemItem element = PsiUtilCore.findFileSystemItem((Project)FavoritesViewTreeBuilder.this.myProject, (VirtualFile)vFile);
            if (element != null && !FavoritesViewTreeBuilder.this.addSubtreeToUpdateByElement(element) && element instanceof PsiFile && ((PsiFile)element).getFileType() == StdFileTypes.JAVA) {
                FavoritesViewTreeBuilder.this.addSubtreeToUpdateByElement(((PsiFile)element).getContainingDirectory());
            }
        }
    }
}

