/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.favoritesTreeView.actions.AddToFavoritesAction;
import com.intellij.ide.favoritesTreeView.actions.AddToNewFavoritesListAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddToFavoritesActionGroup
extends ActionGroup
implements DumbAware {
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            return AnAction.EMPTY_ARRAY;
        }
        Project project = e.getProject();
        if (project == null) {
            return AnAction.EMPTY_ARRAY;
        }
        List<String> availableFavoritesLists = FavoritesManager.getInstance(project).getAvailableFavoritesListNames();
        availableFavoritesLists.remove(FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(e.getDataContext()));
        if (availableFavoritesLists.isEmpty()) {
            return new AnAction[]{new AddToNewFavoritesListAction()};
        }
        AnAction[] actions = new AnAction[availableFavoritesLists.size() + 2];
        int idx = 0;
        for (String favoritesList : availableFavoritesLists) {
            actions[idx++] = new AddToFavoritesAction(favoritesList);
        }
        actions[idx++] = Separator.getInstance();
        actions[idx] = new AddToNewFavoritesListAction();
        return actions;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        try {
            e.getPresentation().setVisible(AddToFavoritesAction.canCreateNodes(e));
        }
        catch (IndexNotReadyException e1) {
            e.getPresentation().setVisible(false);
        }
    }
}

