/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.CreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DefaultCreateFromTemplateHandler
implements CreateFromTemplateHandler {
    @Override
    public boolean handlesTemplate(@NotNull FileTemplate template) {
        return true;
    }

    @Override
    @NotNull
    public PsiElement createFromTemplate(@NotNull Project project, @NotNull PsiDirectory directory, String fileName2, @NotNull FileTemplate template, @NotNull String templateText, @NotNull Map<String, Object> props) throws IncorrectOperationException {
        fileName2 = this.checkAppendExtension(fileName2, template);
        if (FileTypeManager.getInstance().isFileIgnored(fileName2)) {
            throw new IncorrectOperationException("This filename is ignored (Settings | Editor | File Types | Ignore files and folders)");
        }
        directory.checkCreateFile(fileName2);
        FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName2);
        PsiFile file2 = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName2, type, (CharSequence)templateText);
        if (template.isReformatCode()) {
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file2);
        }
        file2 = (PsiFile)directory.add((PsiElement)file2);
        return file2;
    }

    protected String checkAppendExtension(String fileName2, @NotNull FileTemplate template) {
        String suggestedFileNameEnd = "." + template.getExtension();
        if (!fileName2.endsWith(suggestedFileNameEnd)) {
            fileName2 = fileName2 + suggestedFileNameEnd;
        }
        return fileName2;
    }

    @Override
    public boolean canCreate(@NotNull PsiDirectory[] dirs) {
        return true;
    }

    @Override
    public boolean isNameRequired() {
        return true;
    }

    @Override
    @NotNull
    public String getErrorMessage() {
        return IdeBundle.message((String)"title.cannot.create.file", (Object[])new Object[0]);
    }

    @Override
    public void prepareProperties(@NotNull Map<String, Object> props, String filename, @NotNull FileTemplate template) {
        String fileName2 = this.checkAppendExtension(filename, template);
        props.put("FILE_NAME", fileName2);
    }

    @Override
    public void prepareProperties(@NotNull Map<String, Object> props) {
    }
}

