/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.CreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.DefaultCreateFromTemplateHandler;
import com.intellij.ide.fileTemplates.DefaultTemplatePropertiesProvider;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.VelocityWrapper;
import com.intellij.ide.fileTemplates.impl.CustomFileTemplate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.Token;
import org.apache.velocity.runtime.parser.node.ASTDirective;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.ASTSetDirective;
import org.apache.velocity.runtime.parser.node.ASTStringLiteral;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTemplateUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.FileTemplateUtil");
    private static final CreateFromTemplateHandler DEFAULT_HANDLER = new DefaultCreateFromTemplateHandler();

    @NotNull
    public static String[] calculateAttributes(@NotNull String templateContent, @NotNull Properties properties, boolean includeDummies, @NotNull Project project) throws ParseException {
        HashSet<String> propertiesNames = new HashSet<String>();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            propertiesNames.add((String)e.nextElement());
        }
        return FileTemplateUtil.calculateAttributes(templateContent, propertiesNames, includeDummies, project);
    }

    public static String[] calculateAttributes(@NotNull String templateContent, @NotNull Map<String, Object> properties, boolean includeDummies, @NotNull Project project) throws ParseException {
        return FileTemplateUtil.calculateAttributes(templateContent, properties.keySet(), includeDummies, project);
    }

    @NotNull
    private static String[] calculateAttributes(@NotNull String templateContent, @NotNull Set<String> propertiesNames, boolean includeDummies, @NotNull Project project) throws ParseException {
        LinkedHashSet unsetAttributes = new LinkedHashSet();
        HashSet definedAttributes = new HashSet();
        SimpleNode template = VelocityWrapper.parse(new StringReader(templateContent), "MyTemplate");
        FileTemplateUtil.collectAttributes(unsetAttributes, definedAttributes, (Node)template, propertiesNames, includeDummies, new HashSet(), project);
        for (String definedAttribute : definedAttributes) {
            unsetAttributes.remove(definedAttribute);
        }
        return ArrayUtil.toStringArray(unsetAttributes);
    }

    private static void collectAttributes(@NotNull Set<? super String> referenced, @NotNull Set<? super String> defined, @NotNull Node apacheNode, @NotNull Set<String> propertiesNames, boolean includeDummies, @NotNull Set<? super String> visitedIncludes, @NotNull Project project) throws ParseException {
        int childCount = apacheNode.jjtGetNumChildren();
        for (int i = 0; i < childCount; ++i) {
            Token firstToken;
            Node literal;
            Node apacheChild = apacheNode.jjtGetChild(i);
            FileTemplateUtil.collectAttributes(referenced, defined, apacheChild, propertiesNames, includeDummies, visitedIncludes, project);
            if (apacheChild instanceof ASTReference) {
                ASTReference apacheReference = (ASTReference)apacheChild;
                String s = apacheReference.literal();
                if ((s = FileTemplateUtil.referenceToAttribute(s, includeDummies)) == null || s.length() <= 0 || propertiesNames.contains(s)) continue;
                referenced.add(s);
                continue;
            }
            if (apacheChild instanceof ASTSetDirective) {
                ASTReference lhs = (ASTReference)apacheChild.jjtGetChild(0);
                String attr = FileTemplateUtil.referenceToAttribute(lhs.literal(), false);
                if (attr == null) continue;
                defined.add(attr);
                continue;
            }
            if (!(apacheChild instanceof ASTDirective) || !"parse".equals(((ASTDirective)apacheChild).getDirectiveName()) || apacheChild.jjtGetNumChildren() != 1 || !((literal = apacheChild.jjtGetChild(0)) instanceof ASTStringLiteral) || literal.jjtGetNumChildren() != 0 || (firstToken = literal.getFirstToken()) == null) continue;
            String s = StringUtil.unquoteString((String)firstToken.toString());
            FileTemplateManager templateManager = FileTemplateManager.getInstance(project);
            FileTemplate includedTemplate = templateManager.getTemplate(s);
            if (includedTemplate == null) {
                includedTemplate = templateManager.getPattern(s);
            }
            if (includedTemplate == null || !visitedIncludes.add(s)) continue;
            SimpleNode template = VelocityWrapper.parse(new StringReader(includedTemplate.getText()), "MyTemplate");
            FileTemplateUtil.collectAttributes(referenced, defined, (Node)template, propertiesNames, includeDummies, visitedIncludes, project);
        }
    }

    @Nullable
    private static String referenceToAttribute(@NotNull String attrib, boolean includeDummies) {
        while (attrib.startsWith("\\\\")) {
            attrib = attrib.substring(2);
        }
        if (attrib.startsWith("\\$")) {
            if (includeDummies) {
                attrib = attrib.substring(1);
            } else {
                return null;
            }
        }
        if (!StringUtil.startsWithChar((CharSequence)attrib, (char)'$')) {
            return null;
        }
        if (StringUtil.startsWithChar((CharSequence)(attrib = attrib.substring(1)), (char)'{')) {
            String cleanAttribute = null;
            for (int i = 1; i < attrib.length(); ++i) {
                char currChar = attrib.charAt(i);
                if (currChar == '{' || currChar == '.') {
                    cleanAttribute = null;
                    break;
                }
                if (currChar != '}') continue;
                cleanAttribute = attrib.substring(1, i);
                break;
            }
            attrib = cleanAttribute;
        } else {
            for (int i = 0; i < attrib.length(); ++i) {
                char currChar = attrib.charAt(i);
                if (currChar != '{' && currChar != '}' && currChar != '.') continue;
                attrib = attrib.substring(0, i);
                break;
            }
        }
        return attrib;
    }

    @NotNull
    public static String mergeTemplate(@NotNull Map attributes, @NotNull String content, boolean useSystemLineSeparators) throws IOException {
        VelocityContext context = FileTemplateUtil.createVelocityContext();
        for (Object o : attributes.keySet()) {
            String name = (String)o;
            context.put(name, attributes.get(name));
        }
        return FileTemplateUtil.mergeTemplate(content, context, useSystemLineSeparators, null);
    }

    @NotNull
    private static VelocityContext createVelocityContext() {
        VelocityContext context = new VelocityContext();
        context.put("StringUtils", StringUtils.class);
        return context;
    }

    @NotNull
    public static String mergeTemplate(@NotNull Properties attributes, @NotNull String content, boolean useSystemLineSeparators) throws IOException {
        return FileTemplateUtil.mergeTemplate(attributes, content, useSystemLineSeparators, null);
    }

    @NotNull
    public static String mergeTemplate(@NotNull Properties attributes, @NotNull String content, boolean useSystemLineSeparators, @Nullable Consumer<? super VelocityException> exceptionHandler) {
        VelocityContext context = FileTemplateUtil.createVelocityContext();
        Enumeration<?> names = attributes.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            context.put(name, (Object)attributes.getProperty(name));
        }
        return FileTemplateUtil.mergeTemplate(content, context, useSystemLineSeparators, exceptionHandler);
    }

    @NotNull
    private static String mergeTemplate(String templateContent, VelocityContext context, boolean useSystemLineSeparators, @Nullable Consumer<? super VelocityException> exceptionHandler) {
        String newSeparator;
        StringWriter stringWriter = new StringWriter();
        try {
            Project project = null;
            Object projectName = context.get("PROJECT_NAME");
            if (projectName instanceof String) {
                Object[] projects = ProjectManager.getInstance().getOpenProjects();
                project = (Project)ContainerUtil.find((Object[])projects, project1 -> projectName.equals(project1.getName()));
            }
            VelocityWrapper.evaluate(project, (Context)context, stringWriter, templateContent);
        }
        catch (VelocityException e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error((Throwable)e);
            }
            LOG.info("Error evaluating template:\n" + templateContent, (Throwable)e);
            if (exceptionHandler == null) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)IdeBundle.message((String)"error.parsing.file.template", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.velocity.error", (Object[])new Object[0])));
            }
            exceptionHandler.consume((Object)e);
        }
        String result2 = stringWriter.toString();
        if (useSystemLineSeparators && !"\n".equals(newSeparator = CodeStyle.getDefaultSettings().getLineSeparator())) {
            return StringUtil.convertLineSeparators((String)result2, (String)newSeparator);
        }
        return result2;
    }

    @NotNull
    public static PsiElement createFromTemplate(@NotNull FileTemplate template, @Nullable String fileName2, @Nullable Properties props, @NotNull PsiDirectory directory) throws Exception {
        HashMap<String, Object> map2;
        if (props != null) {
            map2 = new HashMap<String, Object>();
            FileTemplateUtil.putAll(map2, props);
        } else {
            map2 = null;
        }
        return FileTemplateUtil.createFromTemplate(template, fileName2, map2, directory, null);
    }

    @NotNull
    public static PsiElement createFromTemplate(@NotNull FileTemplate template, @Nullable String fileName2, @Nullable Properties props, @NotNull PsiDirectory directory, @Nullable ClassLoader classLoader) throws Exception {
        HashMap<String, Object> map2;
        if (props != null) {
            map2 = new HashMap<String, Object>();
            FileTemplateUtil.putAll(map2, props);
        } else {
            map2 = null;
        }
        return FileTemplateUtil.createFromTemplate(template, fileName2, map2, directory, classLoader);
    }

    @NotNull
    public static PsiElement createFromTemplate(@NotNull FileTemplate template, @Nullable String fileName2, @Nullable Map<String, Object> propsMap, @NotNull PsiDirectory directory, @Nullable ClassLoader classLoader) throws Exception {
        String[] dummyRefs;
        Properties p;
        Project project = directory.getProject();
        FileTemplateManager.getInstance(project).addRecentName(template.getName());
        if (propsMap == null) {
            p = FileTemplateManager.getInstance(project).getDefaultProperties();
            propsMap = new HashMap<String, Object>();
            FileTemplateUtil.putAll(propsMap, p);
        }
        p = new Properties();
        FileTemplateUtil.fillDefaultProperties(p, directory);
        FileTemplateUtil.putAll(propsMap, p);
        CreateFromTemplateHandler handler2 = FileTemplateUtil.findHandler(template);
        if (fileName2 != null && propsMap.get("NAME") == null) {
            propsMap.put("NAME", fileName2);
        } else if (fileName2 == null && handler2.isNameRequired() && (fileName2 = (String)propsMap.get("NAME")) == null) {
            throw new Exception("File name must be specified");
        }
        propsMap.put("FILE_NAME", fileName2 + (StringUtil.isEmpty((String)template.getExtension()) ? "" : "." + template.getExtension()));
        String dirPath = FileTemplateUtil.getDirPathRelativeToProjectBaseDir(directory);
        if (dirPath != null) {
            propsMap.put("DIR_PATH", dirPath);
        }
        for (String dummyRef : dummyRefs = FileTemplateUtil.calculateAttributes(template.getText(), propsMap, true, directory.getProject())) {
            propsMap.put(dummyRef, "");
        }
        handler2.prepareProperties(propsMap, fileName2, template);
        handler2.prepareProperties(propsMap);
        Map<String, Object> props_ = propsMap;
        String fileName_ = fileName2;
        String mergedText = (String)ClassLoaderUtil.runWithClassLoader((ClassLoader)(classLoader != null ? classLoader : FileTemplateUtil.class.getClassLoader()), () -> template.getText(props_));
        String templateText = StringUtil.convertLineSeparators((String)mergedText);
        return (PsiElement)WriteCommandAction.writeCommandAction((Project)project).withName(handler2.commandName(template)).compute(() -> handler2.createFromTemplate(project, directory, fileName_, template, templateText, props_));
    }

    @Nullable
    private static String getDirPathRelativeToProjectBaseDir(@NotNull PsiDirectory directory) {
        VirtualFile baseDir = directory.getProject().getBaseDir();
        return baseDir != null ? VfsUtilCore.getRelativePath((VirtualFile)directory.getVirtualFile(), (VirtualFile)baseDir) : null;
    }

    @NotNull
    public static CreateFromTemplateHandler findHandler(@NotNull FileTemplate template) {
        for (CreateFromTemplateHandler handler2 : CreateFromTemplateHandler.EP_NAME.getExtensionList()) {
            if (!handler2.handlesTemplate(template)) continue;
            return handler2;
        }
        return DEFAULT_HANDLER;
    }

    public static void fillDefaultProperties(@NotNull Properties props, @NotNull PsiDirectory directory) {
        for (DefaultTemplatePropertiesProvider provider : DefaultTemplatePropertiesProvider.EP_NAME.getExtensionList()) {
            provider.fillProperties(directory, props);
        }
        props.setProperty("FILE_NAME", "");
        props.setProperty("DIR_PATH", "");
    }

    @NotNull
    public static String indent(@NotNull String methodText, @NotNull Project project, FileType fileType) {
        int indent = CodeStyle.getSettings((Project)project).getIndentSize(fileType);
        return methodText.replaceAll("\n", "\n" + StringUtil.repeatSymbol((char)' ', (int)indent));
    }

    public static boolean canCreateFromTemplate(@NotNull PsiDirectory[] dirs, @NotNull FileTemplate template) {
        FileType fileType = FileTemplateUtil.getFileType(template);
        if (fileType.equals(FileTypes.UNKNOWN)) {
            return false;
        }
        CreateFromTemplateHandler handler2 = FileTemplateUtil.findHandler(template);
        return handler2.canCreate(dirs);
    }

    @NotNull
    protected static FileType getFileType(@NotNull FileTemplate template) {
        FileType fileType = FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(template.getExtension());
        if (fileType.equals(FileTypes.UNKNOWN)) {
            return FileTypeManagerEx.getInstanceEx().getFileTypeByExtension(FileUtilRt.getExtension((String)template.getExtension()));
        }
        return fileType;
    }

    @Nullable
    public static Icon getIcon(@NotNull FileTemplate fileTemplate) {
        return FileTemplateUtil.getFileType(fileTemplate).getIcon();
    }

    public static void putAll(@NotNull Map<String, Object> props, @NotNull Properties p) {
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            props.putIfAbsent(s, p.getProperty(s));
        }
    }

    @NotNull
    public static FileTemplate createTemplate(@NotNull String prefName, @NotNull String extension, @NotNull String content, @NotNull FileTemplate[] templates) {
        HashSet<String> names = new HashSet<String>();
        for (FileTemplate template : templates) {
            names.add(template.getName());
        }
        String name = prefName;
        int i = 0;
        while (names.contains(name)) {
            name = prefName + " (" + ++i + ")";
        }
        CustomFileTemplate newTemplate = new CustomFileTemplate(name, extension);
        newTemplate.setText(content);
        return newTemplate;
    }

    @NotNull
    public static Pattern getTemplatePattern(@NotNull FileTemplate template, @NotNull Project project, @NotNull TIntObjectHashMap<String> offsetToProperty) {
        String templateText = template.getText().trim();
        String regex = FileTemplateUtil.templateToRegex(templateText, offsetToProperty, project);
        regex = StringUtil.replace((String)regex, (String)"with", (String)"(?:with|by)");
        regex = ".*(" + regex + ").*";
        return Pattern.compile(regex, 32);
    }

    @NotNull
    private static String templateToRegex(@NotNull String text, @NotNull TIntObjectHashMap<String> offsetToProperty, @NotNull Project project) {
        ArrayList properties = ContainerUtil.newArrayList(FileTemplateManager.getInstance(project).getDefaultProperties().keySet());
        properties.add("PACKAGE_NAME");
        String regex = FileTemplateUtil.escapeRegexChars(text);
        int groupNumber = 1;
        for (Object property : properties) {
            String name = property.toString();
            String escaped = FileTemplateUtil.escapeRegexChars("${" + name + "}");
            boolean first = true;
            int i = regex.indexOf(escaped);
            while (i != -1 && i < regex.length()) {
                int[] offs;
                String replacement = first ? "([^\\n]*)" : "\\" + groupNumber;
                int delta = escaped.length() - replacement.length();
                for (int off : offs = offsetToProperty.keys()) {
                    if (off <= i) continue;
                    String prop = (String)offsetToProperty.remove(off);
                    offsetToProperty.put(off - delta, (Object)prop);
                }
                offsetToProperty.put(i, (Object)name);
                regex = regex.substring(0, i) + replacement + regex.substring(i + escaped.length());
                if (first) {
                    ++groupNumber;
                    first = false;
                }
                i = regex.indexOf(escaped, i + 1);
            }
        }
        return regex;
    }

    @NotNull
    private static String escapeRegexChars(@NotNull String regex) {
        regex = StringUtil.replace((String)regex, (String)"|", (String)"\\|");
        regex = StringUtil.replace((String)regex, (String)".", (String)"\\.");
        regex = StringUtil.replace((String)regex, (String)"*", (String)"\\*");
        regex = StringUtil.replace((String)regex, (String)"+", (String)"\\+");
        regex = StringUtil.replace((String)regex, (String)"?", (String)"\\?");
        regex = StringUtil.replace((String)regex, (String)"$", (String)"\\$");
        regex = StringUtil.replace((String)regex, (String)"(", (String)"\\(");
        regex = StringUtil.replace((String)regex, (String)")", (String)"\\)");
        regex = StringUtil.replace((String)regex, (String)"[", (String)"\\[");
        regex = StringUtil.replace((String)regex, (String)"]", (String)"\\]");
        regex = StringUtil.replace((String)regex, (String)"{", (String)"\\{");
        regex = StringUtil.replace((String)regex, (String)"}", (String)"\\}");
        return regex;
    }
}

