/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.DefaultTemplate;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import org.jetbrains.annotations.NotNull;

public final class BundledFileTemplate
extends FileTemplateBase {
    private final DefaultTemplate myDefaultTemplate;
    private final boolean myInternal;
    private boolean myEnabled = true;

    public BundledFileTemplate(@NotNull DefaultTemplate defaultTemplate, boolean internal) {
        this.myDefaultTemplate = defaultTemplate;
        this.myInternal = internal;
    }

    @Override
    public boolean isLiveTemplateEnabled() {
        if (this.isLiveTemplateEnabledChanged()) {
            return super.isLiveTemplateEnabled();
        }
        return this.isLiveTemplateEnabledByDefault();
    }

    @Override
    @NotNull
    public String getName() {
        return this.myDefaultTemplate.getName();
    }

    @Override
    @NotNull
    public String getExtension() {
        return this.myDefaultTemplate.getExtension();
    }

    @Override
    public void setName(@NotNull String name) {
    }

    @Override
    public void setExtension(@NotNull String extension) {
    }

    @Override
    @NotNull
    protected String getDefaultText() {
        return this.myDefaultTemplate.getText();
    }

    @Override
    @NotNull
    public final String getDescription() {
        return this.myDefaultTemplate.getDescriptionText();
    }

    @Override
    public boolean isDefault() {
        return this.getText().equals(this.getDefaultText());
    }

    @Override
    public BundledFileTemplate clone() {
        return (BundledFileTemplate)super.clone();
    }

    public boolean isEnabled() {
        return this.myInternal || this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.myEnabled) {
            this.myEnabled = enabled;
            if (!enabled) {
                this.revertToDefaults();
            }
        }
    }

    public void revertToDefaults() {
        this.setText(null);
        this.setReformatCode(true);
        this.setLiveTemplateEnabled(this.isLiveTemplateEnabledByDefault());
    }

    public boolean isTextModified() {
        return !this.getText().equals(this.getDefaultText());
    }

    @Override
    public boolean isLiveTemplateEnabledByDefault() {
        return this.myDefaultTemplate.getText().contains("#[[$");
    }

    public String toString() {
        return this.myDefaultTemplate.getTemplateURL().toString();
    }
}

