/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import java.io.IOException;
import java.lang.ref.Reference;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultTemplate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.DefaultTemplate");
    private final String myName;
    private final String myExtension;
    private final URL myTextURL;
    private Reference<String> myText;
    @Nullable
    private final URL myDescriptionURL;
    private Reference<String> myDescriptionText;

    public DefaultTemplate(@NotNull String name, @NotNull String extension, @NotNull URL templateURL, @Nullable URL descriptionURL) {
        this.myName = name;
        this.myExtension = extension;
        this.myTextURL = templateURL;
        this.myDescriptionURL = descriptionURL;
    }

    @NotNull
    private static String loadText(@NotNull URL url) {
        String text = "";
        try {
            text = StringUtil.convertLineSeparators((String)UrlUtil.loadText(url));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return text;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getQualifiedName() {
        return FileTemplateBase.getQualifiedName(this.getName(), this.getExtension());
    }

    @NotNull
    public String getExtension() {
        return this.myExtension;
    }

    @NotNull
    public URL getTemplateURL() {
        return this.myTextURL;
    }

    @NotNull
    public String getText() {
        String text = (String)SoftReference.dereference(this.myText);
        if (text == null) {
            text = DefaultTemplate.loadText(this.myTextURL);
            this.myText = new java.lang.ref.SoftReference<String>(text);
        }
        return text;
    }

    @NotNull
    public String getDescriptionText() {
        if (this.myDescriptionURL == null) {
            return "";
        }
        String text = (String)SoftReference.dereference(this.myDescriptionText);
        if (text == null) {
            text = DefaultTemplate.loadText(this.myDescriptionURL);
            this.myDescriptionText = new java.lang.ref.SoftReference<String>(text);
        }
        return text;
    }
}

