/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.CustomFileTemplate;
import com.intellij.ide.fileTemplates.impl.DefaultTemplate;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.io.PathKt;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FTManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.FTManager");
    private static final String DEFAULT_TEMPLATE_EXTENSION = "ft";
    static final String TEMPLATE_EXTENSION_SUFFIX = ".ft";
    private static final String ENCODED_NAME_EXT_DELIMITER = "\u0f0fext\u0f0f.";
    private final String myName;
    private final boolean myInternal;
    private final Path myTemplatesDir;
    @Nullable
    private final FTManager myOriginal;
    private final Map<String, FileTemplateBase> myTemplates = new HashMap<String, FileTemplateBase>();
    private volatile List<FileTemplateBase> mySortedTemplates;
    private final List<DefaultTemplate> myDefaultTemplates = new ArrayList<DefaultTemplate>();

    FTManager(@NotNull @NonNls String name, @NotNull @NonNls Path defaultTemplatesDirName) {
        this(name, defaultTemplatesDirName, false);
    }

    FTManager(@NotNull @NonNls String name, @NotNull @NonNls Path defaultTemplatesDirName, boolean internal) {
        this.myName = name;
        this.myInternal = internal;
        this.myTemplatesDir = defaultTemplatesDirName;
        this.myOriginal = null;
    }

    FTManager(@NotNull FTManager original) {
        this.myOriginal = original;
        this.myName = original.getName();
        this.myTemplatesDir = original.myTemplatesDir;
        this.myInternal = original.myInternal;
        this.myTemplates.putAll(original.myTemplates);
        this.myDefaultTemplates.addAll(original.myDefaultTemplates);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    Collection<FileTemplateBase> getAllTemplates(boolean includeDisabled) {
        List<FileTemplateBase> sorted = this.mySortedTemplates;
        if (sorted == null) {
            sorted = new ArrayList<FileTemplateBase>(this.getTemplates().values());
            Collections.sort(sorted, (t1, t2) -> t1.getName().compareToIgnoreCase(t2.getName()));
            this.mySortedTemplates = sorted;
        }
        if (includeDisabled) {
            return Collections.unmodifiableCollection(sorted);
        }
        ArrayList<FileTemplateBase> list2 = new ArrayList<FileTemplateBase>(sorted.size());
        for (FileTemplateBase template : sorted) {
            if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isEnabled()) continue;
            list2.add(template);
        }
        return list2;
    }

    @Nullable
    FileTemplateBase getTemplate(@NotNull String templateQname) {
        return this.getTemplates().get(templateQname);
    }

    @Nullable
    public FileTemplateBase findTemplateByName(@NotNull String templateName) {
        FileTemplateBase template = this.getTemplates().get(templateName);
        if (template != null) {
            boolean isEnabled;
            boolean bl = isEnabled = !(template instanceof BundledFileTemplate) || ((BundledFileTemplate)template).isEnabled();
            if (isEnabled) {
                return template;
            }
        }
        for (FileTemplateBase t : this.getAllTemplates(false)) {
            String remainder;
            String qName = t.getQualifiedName();
            if (!qName.startsWith(templateName) || qName.length() <= templateName.length() || !(remainder = qName.substring(templateName.length())).startsWith(ENCODED_NAME_EXT_DELIMITER) && remainder.charAt(0) != '.') continue;
            return t;
        }
        return null;
    }

    @NotNull
    public FileTemplateBase addTemplate(@NotNull String name, @NotNull String extension) {
        String qName = FileTemplateBase.getQualifiedName(name, extension);
        FileTemplateBase template = this.getTemplate(qName);
        if (template == null) {
            template = new CustomFileTemplate(name, extension);
            this.getTemplates().put(qName, template);
            this.mySortedTemplates = null;
        } else if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isEnabled()) {
            ((BundledFileTemplate)template).setEnabled(true);
        }
        return template;
    }

    public void removeTemplate(@NotNull String qName) {
        FileTemplateBase template = this.getTemplates().get(qName);
        if (template instanceof CustomFileTemplate) {
            this.getTemplates().remove(qName);
            this.mySortedTemplates = null;
        } else if (template instanceof BundledFileTemplate) {
            ((BundledFileTemplate)template).setEnabled(false);
        }
    }

    void updateTemplates(@NotNull Collection<? extends FileTemplate> newTemplates) {
        HashSet<String> toDisable = new HashSet<String>();
        for (DefaultTemplate defaultTemplate : this.myDefaultTemplates) {
            toDisable.add(defaultTemplate.getQualifiedName());
        }
        for (FileTemplate fileTemplate : newTemplates) {
            toDisable.remove(((FileTemplateBase)fileTemplate).getQualifiedName());
        }
        this.restoreDefaults(toDisable);
        for (FileTemplate fileTemplate : newTemplates) {
            FileTemplateBase _template = this.addTemplate(fileTemplate.getName(), fileTemplate.getExtension());
            _template.setText(fileTemplate.getText());
            _template.setReformatCode(fileTemplate.isReformatCode());
            _template.setLiveTemplateEnabled(fileTemplate.isLiveTemplateEnabled());
        }
        this.saveTemplates(true);
    }

    private void restoreDefaults(@NotNull Set<String> toDisable) {
        this.getTemplates().clear();
        this.mySortedTemplates = null;
        for (DefaultTemplate template : this.myDefaultTemplates) {
            BundledFileTemplate bundled = this.createAndStoreBundledTemplate(template);
            if (!toDisable.contains(bundled.getQualifiedName())) continue;
            bundled.setEnabled(false);
        }
    }

    void setDefaultTemplates(@NotNull Collection<DefaultTemplate> templates) {
        this.myDefaultTemplates.clear();
        this.myDefaultTemplates.addAll(templates);
        for (DefaultTemplate template : templates) {
            this.createAndStoreBundledTemplate(template);
        }
    }

    @NotNull
    private BundledFileTemplate createAndStoreBundledTemplate(@NotNull DefaultTemplate template) {
        BundledFileTemplate bundled = new BundledFileTemplate(template, this.myInternal);
        String qName = bundled.getQualifiedName();
        FileTemplateBase previous = this.getTemplates().put(qName, bundled);
        this.mySortedTemplates = null;
        LOG.assertTrue(previous == null, (Object)("Duplicate bundled template " + qName + " [" + template.getTemplateURL() + ", " + previous + ']'));
        return bundled;
    }

    void loadCustomizedContent() {
        ArrayList<Path> templateWithDefaultExtension = new ArrayList<Path>();
        THashSet processedNames = new THashSet();
        try (DirectoryStream<Path> stream2 = Files.newDirectoryStream(this.getConfigRoot(), file2 -> !Files.isDirectory(file2, new LinkOption[0]) && !Files.isHidden(file2));){
            for (Path file3 : stream2) {
                String fileName2 = file3.getFileName().toString();
                if (FileTypeManager.getInstance().isFileIgnored(fileName2)) continue;
                if (fileName2.endsWith(TEMPLATE_EXTENSION_SUFFIX)) {
                    templateWithDefaultExtension.add(file3);
                    continue;
                }
                processedNames.add(fileName2);
                this.addTemplateFromFile(fileName2, file3);
            }
        }
        catch (NoSuchFileException stream2) {
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return;
        }
        for (Path file4 : templateWithDefaultExtension) {
            String name = file4.getFileName().toString();
            if (!processedNames.contains(name = name.substring(0, name.length() - TEMPLATE_EXTENSION_SUFFIX.length()))) {
                this.addTemplateFromFile(name, file4);
            }
            try {
                Files.delete(file4);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private void addTemplateFromFile(@NotNull String fileName2, @NotNull Path file2) {
        Pair<String, String> nameExt = FTManager.decodeFileName(fileName2);
        String extension = (String)nameExt.second;
        String templateQName = (String)nameExt.first;
        if (templateQName.isEmpty()) {
            return;
        }
        try {
            this.addTemplate(templateQName, extension).setText(PathKt.readText((Path)file2));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public void saveTemplates() {
        this.saveTemplates(false);
    }

    private void saveTemplates(boolean removeDeleted) {
        THashSet allNames = new THashSet();
        Path configRoot = this.getConfigRoot();
        THashMap templatesOnDisk = new THashMap();
        try {
            DirectoryStream<Path> stream = Files.newDirectoryStream(this.getConfigRoot(), file2 -> !Files.isDirectory(file2, new LinkOption[0]) && !Files.isHidden(file2));
            Object object = null;
            try {
                for (Path file3 : stream) {
                    String fileName2 = file3.getFileName().toString();
                    templatesOnDisk.put(fileName2, file3);
                    allNames.add(fileName2);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (stream != null) {
                    if (object != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (NoSuchFileException stream) {
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        THashMap templatesToSave = new THashMap();
        for (FileTemplateBase template : this.getAllTemplates(true)) {
            if (template instanceof BundledFileTemplate && !((BundledFileTemplate)template).isTextModified()) continue;
            String name = template.getQualifiedName();
            templatesToSave.put(name, template);
            allNames.add(name);
        }
        if (allNames.isEmpty()) {
            return;
        }
        try {
            Files.createDirectories(this.myTemplatesDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.info("Cannot create directory: " + this.myTemplatesDir);
        }
        String lineSeparator = CodeStyle.getDefaultSettings().getLineSeparator();
        for (String name : allNames) {
            Path customizedTemplateFile = (Path)templatesOnDisk.get(name);
            FileTemplateBase templateToSave = (FileTemplateBase)templatesToSave.get(name);
            if (customizedTemplateFile == null) {
                try {
                    FTManager.saveTemplate(configRoot, templateToSave, lineSeparator);
                }
                catch (IOException e) {
                    LOG.error("Unable to save template " + name, (Throwable)e);
                }
                continue;
            }
            if (templateToSave == null) {
                if (!removeDeleted) continue;
                try {
                    Files.delete(customizedTemplateFile);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                continue;
            }
            try {
                String templateText;
                String diskText = StringUtilRt.convertLineSeparators((String)PathKt.readText((Path)customizedTemplateFile));
                if (diskText.equals(templateText = templateToSave.getText())) continue;
                FTManager.saveTemplate(configRoot, templateToSave, lineSeparator);
            }
            catch (IOException e) {
                LOG.error("Unable to save template " + name, (Throwable)e);
            }
        }
    }

    private static void saveTemplate(@NotNull Path parentDir, @NotNull FileTemplateBase template, @NotNull String lineSeparator) throws IOException {
        Path templateFile = parentDir.resolve(FTManager.encodeFileName(template.getName(), template.getExtension()));
        try (OutputStream fileOutputStream = FTManager.startWriteOrCreate(templateFile);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream, StandardCharsets.UTF_8);){
            String content = template.getText();
            if (!lineSeparator.equals("\n")) {
                content = StringUtilRt.convertLineSeparators((String)content, (String)lineSeparator);
            }
            outputStreamWriter.write(content);
        }
    }

    @NotNull
    private static OutputStream startWriteOrCreate(@NotNull Path templateFile) throws IOException {
        try {
            return Files.newOutputStream(templateFile, new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            PathKt.delete((Path)templateFile);
            return Files.newOutputStream(templateFile, new OpenOption[0]);
        }
    }

    @NotNull
    Path getConfigRoot() {
        return this.myTemplatesDir;
    }

    public String toString() {
        return this.myName + " file template manager";
    }

    @NotNull
    static String encodeFileName(@NotNull String templateName, @NotNull String extension) {
        String nameExtDelimiter = extension.contains(".") ? ENCODED_NAME_EXT_DELIMITER : ".";
        return templateName + nameExtDelimiter + extension;
    }

    @NotNull
    private static Pair<String, String> decodeFileName(@NotNull String fileName2) {
        String name = fileName2;
        String ext = "";
        String nameExtDelimiter = fileName2.contains(ENCODED_NAME_EXT_DELIMITER) ? ENCODED_NAME_EXT_DELIMITER : ".";
        int extIndex = fileName2.lastIndexOf(nameExtDelimiter);
        if (extIndex >= 0) {
            name = fileName2.substring(0, extIndex);
            ext = fileName2.substring(extIndex + nameExtDelimiter.length());
        }
        return Pair.create((Object)name, (Object)ext);
    }

    @NotNull
    public Map<String, FileTemplateBase> getTemplates() {
        return this.myOriginal != null ? this.myOriginal.myTemplates : this.myTemplates;
    }
}

