/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplatesScheme;
import com.intellij.ide.fileTemplates.InternalTemplateBean;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.ExportableFileTemplateSettings;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.FileTemplateSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.project.ProjectKt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="FileTemplateManagerImpl", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FileTemplateManagerImpl
extends FileTemplateManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl");
    private final State myState = new State();
    private final FileTypeManagerEx myTypeManager;
    private final FileTemplateSettings myProjectSettings;
    private final ExportableFileTemplateSettings myDefaultSettings;
    private final Project myProject;
    private final FileTemplatesScheme myProjectScheme;
    private FileTemplatesScheme myScheme = FileTemplatesScheme.DEFAULT;
    private boolean myInitialized;
    private Date myTestDate;

    public static FileTemplateManagerImpl getInstanceImpl(@NotNull Project project) {
        return (FileTemplateManagerImpl)FileTemplateManagerImpl.getInstance(project);
    }

    FileTemplateManagerImpl(@NotNull FileTypeManagerEx typeManager, FileTemplateSettings projectSettings, ExportableFileTemplateSettings defaultSettings, final Project project) {
        this.myTypeManager = typeManager;
        this.myProjectSettings = projectSettings;
        this.myDefaultSettings = defaultSettings;
        this.myProject = project;
        this.myProjectScheme = project.isDefault() ? null : new FileTemplatesScheme("Project"){

            @Override
            @NotNull
            public String getTemplatesDir() {
                return FileUtilRt.toSystemDependentName((String)(ProjectKt.getStateStore(project).getDirectoryStorePath(false) + "/" + "fileTemplates"));
            }

            @Override
            @NotNull
            public Project getProject() {
                return project;
            }
        };
    }

    private FileTemplateSettings getSettings() {
        return this.myScheme == FileTemplatesScheme.DEFAULT ? this.myDefaultSettings : this.myProjectSettings;
    }

    @Override
    @NotNull
    public FileTemplatesScheme getCurrentScheme() {
        return this.myScheme;
    }

    @Override
    public void setCurrentScheme(@NotNull FileTemplatesScheme scheme2) {
        for (FTManager child2 : this.getAllManagers()) {
            child2.saveTemplates();
        }
        this.setScheme(scheme2);
    }

    private void setScheme(@NotNull FileTemplatesScheme scheme2) {
        this.myScheme = scheme2;
        this.myInitialized = true;
    }

    @Override
    @NotNull
    protected FileTemplateManager checkInitialized() {
        if (!this.myInitialized) {
            this.setScheme(this.myScheme);
        }
        return this;
    }

    @Override
    @Nullable
    public FileTemplatesScheme getProjectScheme() {
        return this.myProjectScheme;
    }

    @Override
    @NotNull
    public FileTemplate[] getTemplates(@NotNull String category) {
        if ("Default".equals(category)) {
            return (FileTemplate[])ArrayUtil.mergeArrays((Object[])this.getInternalTemplates(), (Object[])this.getAllTemplates());
        }
        if ("Includes".equals(category)) {
            return this.getAllPatterns();
        }
        if ("Code".equals(category)) {
            return this.getAllCodeTemplates();
        }
        if ("J2EE".equals(category)) {
            return this.getAllJ2eeTemplates();
        }
        throw new IllegalArgumentException("Unknown category: " + category);
    }

    @Override
    @NotNull
    public FileTemplate[] getAllTemplates() {
        Collection<FileTemplateBase> templates = this.getSettings().getDefaultTemplatesManager().getAllTemplates(false);
        return templates.toArray(FileTemplate.EMPTY_ARRAY);
    }

    @Override
    public FileTemplate getTemplate(@NotNull String templateName) {
        return this.getSettings().getDefaultTemplatesManager().findTemplateByName(templateName);
    }

    @Override
    @NotNull
    public FileTemplate addTemplate(@NotNull String name, @NotNull String extension) {
        return this.getSettings().getDefaultTemplatesManager().addTemplate(name, extension);
    }

    @Override
    public void removeTemplate(@NotNull FileTemplate template) {
        String qName = ((FileTemplateBase)template).getQualifiedName();
        for (FTManager manager : this.getAllManagers()) {
            manager.removeTemplate(qName);
        }
    }

    @Override
    @NotNull
    public Properties getDefaultProperties() {
        Properties props = new Properties();
        Calendar calendar = Calendar.getInstance();
        Date date = this.myTestDate == null ? calendar.getTime() : this.myTestDate;
        SimpleDateFormat sdfMonthNameShort = new SimpleDateFormat("MMM");
        SimpleDateFormat sdfMonthNameFull = new SimpleDateFormat("MMMM");
        SimpleDateFormat sdfDayNameShort = new SimpleDateFormat("EEE");
        SimpleDateFormat sdfDayNameFull = new SimpleDateFormat("EEEE");
        SimpleDateFormat sdfYearFull = new SimpleDateFormat("yyyy");
        props.setProperty("DATE", DateFormatUtil.formatDate((Date)date));
        props.setProperty("TIME", DateFormatUtil.formatTime((Date)date));
        props.setProperty("YEAR", sdfYearFull.format(date));
        props.setProperty("MONTH", FileTemplateManagerImpl.getCalendarValue(calendar, 2));
        props.setProperty("MONTH_NAME_SHORT", sdfMonthNameShort.format(date));
        props.setProperty("MONTH_NAME_FULL", sdfMonthNameFull.format(date));
        props.setProperty("DAY", FileTemplateManagerImpl.getCalendarValue(calendar, 5));
        props.setProperty("DAY_NAME_SHORT", sdfDayNameShort.format(date));
        props.setProperty("DAY_NAME_FULL", sdfDayNameFull.format(date));
        props.setProperty("HOUR", FileTemplateManagerImpl.getCalendarValue(calendar, 11));
        props.setProperty("MINUTE", FileTemplateManagerImpl.getCalendarValue(calendar, 12));
        props.setProperty("SECOND", FileTemplateManagerImpl.getCalendarValue(calendar, 13));
        props.setProperty("USER", SystemProperties.getUserName());
        props.setProperty("PRODUCT_NAME", ApplicationNamesInfo.getInstance().getFullProductName());
        props.setProperty("DS", "$");
        props.setProperty("PROJECT_NAME", this.myProject.getName());
        return props;
    }

    @NotNull
    private static String getCalendarValue(Calendar calendar, int field) {
        String result2;
        int val = calendar.get(field);
        if (field == 2) {
            ++val;
        }
        if ((result2 = Integer.toString(val)).length() == 1) {
            return "0" + result2;
        }
        return result2;
    }

    @Override
    @NotNull
    public Collection<String> getRecentNames() {
        this.validateRecentNames();
        return this.myState.getRecentNames();
    }

    @Override
    public void addRecentName(@NotNull @NonNls String name) {
        this.myState.addName(name);
    }

    private void validateRecentNames() {
        Collection<FileTemplateBase> allTemplates = this.getSettings().getDefaultTemplatesManager().getAllTemplates(false);
        ArrayList<String> allNames = new ArrayList<String>(allTemplates.size());
        for (FileTemplate fileTemplate : allTemplates) {
            allNames.add(fileTemplate.getName());
        }
        this.myState.validateNames(allNames);
    }

    @Override
    @NotNull
    public FileTemplate[] getInternalTemplates() {
        List internalTemplateBeans = InternalTemplateBean.EP_NAME.getExtensionList();
        ArrayList<FileTemplate> result2 = new ArrayList<FileTemplate>(internalTemplateBeans.size());
        for (InternalTemplateBean bean : internalTemplateBeans) {
            try {
                result2.add(this.getInternalTemplate(bean.name));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return result2.toArray(FileTemplate.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public FileTemplate getInternalTemplate(@NotNull @NonNls String templateName) {
        FileTemplateBase template = (FileTemplateBase)this.findInternalTemplate(templateName);
        if (template == null) {
            template = (FileTemplateBase)this.getJ2eeTemplate(templateName);
            template.setReformatCode(true);
        }
        return template;
    }

    @Override
    public FileTemplate findInternalTemplate(@NotNull @NonNls String templateName) {
        FileTemplateBase template = this.getSettings().getInternalTemplatesManager().findTemplateByName(templateName);
        if (template == null) {
            template = this.getSettings().getDefaultTemplatesManager().findTemplateByName(templateName);
        }
        return template;
    }

    @Override
    @NotNull
    public String internalTemplateToSubject(@NotNull @NonNls String templateName) {
        for (InternalTemplateBean bean : InternalTemplateBean.EP_NAME.getExtensionList()) {
            if (!bean.name.equals(templateName) || bean.subject == null) continue;
            return bean.subject;
        }
        return templateName.toLowerCase();
    }

    @Override
    @NotNull
    public FileTemplate getCodeTemplate(@NotNull @NonNls String templateName) {
        return FileTemplateManagerImpl.getTemplateFromManager(templateName, this.getSettings().getCodeTemplatesManager());
    }

    @Override
    @NotNull
    public FileTemplate getJ2eeTemplate(@NotNull @NonNls String templateName) {
        return FileTemplateManagerImpl.getTemplateFromManager(templateName, this.getSettings().getJ2eeTemplatesManager());
    }

    @NotNull
    private static FileTemplate getTemplateFromManager(@NotNull String templateName, @NotNull FTManager ftManager) {
        FileTemplateBase template = ftManager.getTemplate(templateName);
        if (template != null) {
            return template;
        }
        template = ftManager.findTemplateByName(templateName);
        if (template != null) {
            return template;
        }
        String message = "Template not found: " + templateName;
        LOG.error(message);
        throw new IllegalStateException(message);
    }

    @Override
    @NotNull
    public FileTemplate getDefaultTemplate(@NotNull String name) {
        String templateQName = this.getQualifiedName(name);
        for (FTManager manager : this.getAllManagers()) {
            FileTemplateBase template = manager.getTemplate(templateQName);
            if (template == null) continue;
            if (template instanceof BundledFileTemplate) {
                template = ((BundledFileTemplate)template).clone();
                ((BundledFileTemplate)template).revertToDefaults();
            }
            return template;
        }
        String message = "Default template not found: " + name;
        LOG.error(message);
        throw new RuntimeException(message);
    }

    @NotNull
    private String getQualifiedName(@NotNull String name) {
        return this.myTypeManager.getExtension(name).isEmpty() ? FileTemplateBase.getQualifiedName(name, "java") : name;
    }

    @Override
    @NotNull
    public FileTemplate[] getAllPatterns() {
        Collection<FileTemplateBase> allTemplates = this.getSettings().getPatternsManager().getAllTemplates(false);
        return allTemplates.toArray(FileTemplate.EMPTY_ARRAY);
    }

    @Override
    public FileTemplate getPattern(@NotNull String name) {
        return this.getSettings().getPatternsManager().findTemplateByName(name);
    }

    @Override
    @NotNull
    public FileTemplate[] getAllCodeTemplates() {
        Collection<FileTemplateBase> templates = this.getSettings().getCodeTemplatesManager().getAllTemplates(false);
        return templates.toArray(FileTemplate.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public FileTemplate[] getAllJ2eeTemplates() {
        Collection<FileTemplateBase> templates = this.getSettings().getJ2eeTemplatesManager().getAllTemplates(false);
        return templates.toArray(FileTemplate.EMPTY_ARRAY);
    }

    @Override
    public void setTemplates(@NotNull String templatesCategory, @NotNull Collection<FileTemplate> templates) {
        for (FTManager manager : this.getAllManagers()) {
            if (!templatesCategory.equals(manager.getName())) continue;
            manager.updateTemplates(templates);
            break;
        }
    }

    @Override
    public void saveAllTemplates() {
        for (FTManager manager : this.getAllManagers()) {
            manager.saveTemplates();
        }
    }

    public URL getDefaultTemplateDescription() {
        return this.myDefaultSettings.getDefaultTemplateDescription();
    }

    URL getDefaultIncludeDescription() {
        return this.myDefaultSettings.getDefaultIncludeDescription();
    }

    public void setTestDate(Date testDate) {
        this.myTestDate = testDate;
    }

    @Nullable
    public State getState() {
        this.myState.SCHEME = this.myScheme.getName();
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
        FileTemplatesScheme scheme2 = this.myProjectScheme != null && this.myProjectScheme.getName().equals(state.SCHEME) ? this.myProjectScheme : FileTemplatesScheme.DEFAULT;
        this.setScheme(scheme2);
    }

    private FTManager[] getAllManagers() {
        return this.getSettings().getAllManagers();
    }

    public void setDefaultFileIncludeTemplateTextTemporarilyForTest(final String simpleName, final String text, @NotNull Disposable parentDisposable) {
        FTManager defaultTemplatesManager = this.getSettings().getPatternsManager();
        final String qName = this.getQualifiedName(simpleName);
        FileTemplateBase oldTemplate = defaultTemplatesManager.getTemplate(qName);
        Map<String, FileTemplateBase> templates = defaultTemplatesManager.getTemplates();
        templates.put(qName, new FileTemplateBase(){

            @Override
            @NotNull
            public String getName() {
                return simpleName;
            }

            @Override
            public void setName(@NotNull String name) {
                throw new AbstractMethodError();
            }

            @Override
            public boolean isDefault() {
                return true;
            }

            @Override
            @NotNull
            public String getDescription() {
                throw new AbstractMethodError();
            }

            @Override
            @NotNull
            public String getExtension() {
                return qName.substring(simpleName.length());
            }

            @Override
            public void setExtension(@NotNull String extension) {
                throw new AbstractMethodError();
            }

            @Override
            @NotNull
            protected String getDefaultText() {
                return text;
            }
        });
        Disposer.register((Disposable)parentDisposable, () -> templates.put(qName, oldTemplate));
    }

    public static class State {
        public List<String> RECENT_TEMPLATES = new ArrayList<String>();
        public String SCHEME = FileTemplatesScheme.DEFAULT.getName();

        public void addName(@NotNull @NonNls String name) {
            this.RECENT_TEMPLATES.remove(name);
            this.RECENT_TEMPLATES.add(name);
        }

        @NotNull
        Collection<String> getRecentNames() {
            int size = this.RECENT_TEMPLATES.size();
            int resultSize = Math.min(25, size);
            return this.RECENT_TEMPLATES.subList(size - resultSize, size);
        }

        void validateNames(List<String> validNames) {
            this.RECENT_TEMPLATES.retainAll(validNames);
        }
    }
}

