/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.DefaultTemplate;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateLoadResult;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.project.ProjectKt;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.UrlClassLoader;
import gnu.trove.THashSet;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileTemplatesLoader {
    private static final Logger LOG = Logger.getInstance(FileTemplatesLoader.class);
    static final String TEMPLATES_DIR = "fileTemplates";
    private static final String DEFAULT_TEMPLATES_ROOT = "fileTemplates";
    private static final String DESCRIPTION_FILE_EXTENSION = "html";
    private static final String DESCRIPTION_EXTENSION_SUFFIX = ".html";
    private final FTManager myDefaultTemplatesManager;
    private final FTManager myInternalTemplatesManager;
    private final FTManager myPatternsManager;
    private final FTManager myCodeTemplatesManager;
    private final FTManager myJ2eeTemplatesManager;
    private final FTManager[] myAllManagers;
    private static final String INTERNAL_DIR = "internal";
    private static final String INCLUDES_DIR = "includes";
    private static final String CODE_TEMPLATES_DIR = "code";
    private static final String J2EE_TEMPLATES_DIR = "j2ee";
    private final URL myDefaultTemplateDescription;
    private final URL myDefaultIncludeDescription;

    FileTemplatesLoader(@Nullable Project project) {
        Path configDir = Paths.get(project == null || project.isDefault() ? PathManager.getConfigPath() : UriUtil.trimTrailingSlashes(Objects.requireNonNull(ProjectKt.getStateStore(project).getDirectoryStorePath(true))), "fileTemplates");
        this.myDefaultTemplatesManager = new FTManager("Default", configDir);
        this.myInternalTemplatesManager = new FTManager("Internal", configDir.resolve(INTERNAL_DIR), true);
        this.myPatternsManager = new FTManager("Includes", configDir.resolve(INCLUDES_DIR));
        this.myCodeTemplatesManager = new FTManager("Code", configDir.resolve(CODE_TEMPLATES_DIR));
        this.myJ2eeTemplatesManager = new FTManager("J2EE", configDir.resolve(J2EE_TEMPLATES_DIR));
        this.myAllManagers = new FTManager[]{this.myDefaultTemplatesManager, this.myInternalTemplatesManager, this.myPatternsManager, this.myCodeTemplatesManager, this.myJ2eeTemplatesManager};
        LinkedHashMap<FTManager, String> managerToPrefix = new LinkedHashMap<FTManager, String>();
        for (FTManager manager : this.myAllManagers) {
            Path managerRoot = manager.getConfigRoot();
            String relativePath = configDir.equals(managerRoot) ? "" : FileUtilRt.toSystemIndependentName((String)configDir.relativize(managerRoot).toString()) + "/";
            managerToPrefix.put(manager, relativePath);
        }
        FileTemplateLoadResult result2 = FileTemplatesLoader.loadDefaultTemplates(new ArrayList<String>(managerToPrefix.values()));
        this.myDefaultTemplateDescription = result2.getDefaultTemplateDescription();
        this.myDefaultIncludeDescription = result2.getDefaultIncludeDescription();
        for (FTManager manager : this.myAllManagers) {
            manager.setDefaultTemplates(result2.getResult().get(managerToPrefix.get(manager)));
            manager.loadCustomizedContent();
        }
    }

    @NotNull
    FTManager[] getAllManagers() {
        return this.myAllManagers;
    }

    @NotNull
    FTManager getDefaultTemplatesManager() {
        return new FTManager(this.myDefaultTemplatesManager);
    }

    @NotNull
    FTManager getInternalTemplatesManager() {
        return new FTManager(this.myInternalTemplatesManager);
    }

    @NotNull
    FTManager getPatternsManager() {
        return new FTManager(this.myPatternsManager);
    }

    @NotNull
    FTManager getCodeTemplatesManager() {
        return new FTManager(this.myCodeTemplatesManager);
    }

    @NotNull
    FTManager getJ2eeTemplatesManager() {
        return new FTManager(this.myJ2eeTemplatesManager);
    }

    URL getDefaultTemplateDescription() {
        return this.myDefaultTemplateDescription;
    }

    URL getDefaultIncludeDescription() {
        return this.myDefaultIncludeDescription;
    }

    @NotNull
    private static FileTemplateLoadResult loadDefaultTemplates(@NotNull List<String> prefixes) {
        IdeaPluginDescriptor[] plugins2;
        FileTemplateLoadResult result2 = new FileTemplateLoadResult((MultiMap<String, DefaultTemplate>)MultiMap.createSmart());
        THashSet processedUrls = new THashSet();
        HashSet<ClassLoader> processedLoaders = new HashSet<ClassLoader>();
        for (IdeaPluginDescriptor plugin : plugins2 = PluginManagerCore.getPlugins()) {
            ClassLoader loader;
            if (!(plugin instanceof IdeaPluginDescriptorImpl) || !((IdeaPluginDescriptorImpl)plugin).isEnabled() || (loader = plugin.getPluginClassLoader()) instanceof PluginClassLoader && ((PluginClassLoader)((Object)loader)).getUrls().isEmpty() || !processedLoaders.add(loader)) continue;
            try {
                Enumeration<URL> systemResources = loader.getResources("fileTemplates");
                if (!systemResources.hasMoreElements()) continue;
                while (systemResources.hasMoreElements()) {
                    URL url = systemResources.nextElement();
                    if (!processedUrls.add(url)) continue;
                    FileTemplatesLoader.loadDefaultsFromRoot(url, prefixes, result2);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return result2;
    }

    private static void loadDefaultsFromRoot(@NotNull URL root, @NotNull List<String> prefixes, @NotNull FileTemplateLoadResult result2) throws IOException {
        List<String> children2 = UrlUtil.getChildrenRelativePaths(root);
        if (children2.isEmpty()) {
            return;
        }
        HashSet<String> descriptionPaths = new HashSet<String>();
        for (String path : children2) {
            if (path.equals("default.html")) {
                result2.setDefaultTemplateDescription(UrlClassLoader.internProtocol((URL)new URL(UriUtil.trimTrailingSlashes(root.toExternalForm()) + "/" + path)));
                continue;
            }
            if (path.equals("includes/default.html")) {
                result2.setDefaultIncludeDescription(UrlClassLoader.internProtocol((URL)new URL(UriUtil.trimTrailingSlashes(root.toExternalForm()) + "/" + path)));
                continue;
            }
            if (!path.endsWith(DESCRIPTION_EXTENSION_SUFFIX)) continue;
            descriptionPaths.add(path);
        }
        block1: for (String path : children2) {
            if (!path.endsWith(".ft")) continue;
            for (String prefix : prefixes) {
                URL descriptionUrl;
                if (!FileTemplatesLoader.matchesPrefix(path, prefix)) continue;
                String filename = path.substring(prefix.length(), path.length() - ".ft".length());
                String extension = FileUtilRt.getExtension((String)filename);
                String templateName = filename.substring(0, filename.length() - extension.length() - 1);
                URL templateUrl = UrlClassLoader.internProtocol((URL)new URL(UriUtil.trimTrailingSlashes(root.toExternalForm()) + "/" + path));
                String descriptionPath = FileTemplatesLoader.getDescriptionPath(prefix, templateName, extension, descriptionPaths);
                URL uRL = descriptionUrl = descriptionPath == null ? null : UrlClassLoader.internProtocol((URL)new URL(UriUtil.trimTrailingSlashes(root.toExternalForm()) + "/" + descriptionPath));
                assert (templateUrl != null);
                result2.getResult().putValue((Object)prefix, (Object)new DefaultTemplate(templateName, extension, templateUrl, descriptionUrl));
                continue block1;
            }
        }
    }

    private static boolean matchesPrefix(@NotNull String path, @NotNull String prefix) {
        if (prefix.isEmpty()) {
            return path.indexOf(47) == -1;
        }
        return FileUtil.startsWith((String)path, (String)prefix) && path.indexOf(47, prefix.length()) == -1;
    }

    @Nullable
    private static String getDescriptionPath(@NotNull String pathPrefix, @NotNull String templateName, @NotNull String templateExtension, @NotNull Set<String> descriptionPaths) {
        String descPath;
        Locale locale = Locale.getDefault();
        String descName = MessageFormat.format("{0}.{1}_{2}_{3}.html", templateName, templateExtension, locale.getLanguage(), locale.getCountry());
        String string = descPath = pathPrefix.isEmpty() ? descName : pathPrefix + descName;
        if (descriptionPaths.contains(descPath)) {
            return descPath;
        }
        descName = MessageFormat.format("{0}.{1}_{2}.html", templateName, templateExtension, locale.getLanguage());
        String string2 = descPath = pathPrefix.isEmpty() ? descName : pathPrefix + descName;
        if (descriptionPaths.contains(descPath)) {
            return descPath;
        }
        descName = templateName + "." + templateExtension + DESCRIPTION_EXTENSION_SUFFIX;
        String string3 = descPath = pathPrefix.isEmpty() ? descName : pathPrefix + descName;
        if (descriptionPaths.contains(descPath)) {
            return descPath;
        }
        return null;
    }
}

