/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NotNull;

public class ConsentSettingsUi
extends JPanel
implements ConfigurableUi<List<Consent>> {
    final Collection<Pair<JCheckBox, Consent>> consentMapping = new ArrayList<Pair<JCheckBox, Consent>>();
    private final boolean myPreferencesMode;

    public ConsentSettingsUi(boolean preferencesMode) {
        this.myPreferencesMode = preferencesMode;
        this.setLayout(new GridLayout(1, 1));
    }

    public void reset(@NotNull List<Consent> consents) {
        this.consentMapping.clear();
        if (consents.isEmpty()) {
            JLabel label2 = new JLabel("There are no data-sharing options available", 0);
            label2.setVerticalAlignment(0);
            label2.setOpaque(true);
            label2.setBackground(JBColor.background());
            this.removeAll();
            this.add(label2);
            return;
        }
        JPanel body = new JPanel(new GridBagLayout());
        body.setBackground(this.myPreferencesMode ? UIUtil.getPanelBackground() : UIUtil.getEditorPaneBackground());
        boolean addCheckBox = this.myPreferencesMode || consents.size() > 1;
        Iterator<Consent> it = consents.iterator();
        while (it.hasNext()) {
            Consent consent = it.next();
            JComponent comp = this.createConsentElement(consent, addCheckBox);
            body.add((Component)comp, new GridBagConstraints(0, -1, 1, 1, 1.0, !it.hasNext() && this.myPreferencesMode ? 1.0 : 0.0, 18, 2, (Insets)(it.hasNext() ? JBUI.insets((int)0, (int)0, (int)10, (int)0) : JBUI.emptyInsets()), 0, 0));
        }
        if (!this.myPreferencesMode) {
            JBLabel hintLabel = new JBLabel("You can always change this behavior in " + ShowSettingsUtil.getSettingsMenuName() + " | Appearance & Behavior | System Settings | Data Sharing.");
            hintLabel.setForeground(UIUtil.getContextHelpForeground());
            hintLabel.setVerticalAlignment(1);
            hintLabel.setFont((Font)JBUI.Fonts.smallFont());
            body.add((Component)hintLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, new Insets(JBUI.scale((int)16), 0, JBUI.scale((int)10), 0), 0, 0));
        }
        if (!this.myPreferencesMode) {
            body.setBorder(JBUI.Borders.empty((int)10));
        }
        this.removeAll();
        JBScrollPane scrollPane = new JBScrollPane((Component)body, 20, 30);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        this.add((Component)scrollPane);
    }

    private static String getParagraphTag() {
        return "<p style=\"margin-bottom:" + JBUI.scale((int)10) + "px;\">";
    }

    @NotNull
    private JComponent createConsentElement(Consent consent, boolean addCheckBox) {
        JPanel pane;
        if (addCheckBox) {
            JBCheckBox cb = new JBCheckBox(StringUtil.capitalize((String)consent.getName().toLowerCase(Locale.US)), consent.isAccepted());
            pane = UI.PanelFactory.panel((JComponent)cb).withComment(ConsentSettingsUi.getParagraphTag() + StringUtil.replace((String)consent.getText(), (String)"\n", (String)("</p>" + ConsentSettingsUi.getParagraphTag())) + "</p>").createPanel();
            cb.setOpaque(false);
            this.consentMapping.add((Pair<JCheckBox, Consent>)Pair.create((Object)cb, (Object)consent));
        } else {
            pane = new JPanel(new BorderLayout());
            JEditorPane viewer = SwingHelper.createHtmlViewer(true, null, (Color)JBColor.WHITE, (Color)JBColor.BLACK);
            viewer.setOpaque(false);
            viewer.setFocusable(false);
            viewer.setCaret(new DefaultCaret(){

                @Override
                protected void adjustVisibility(Rectangle nloc) {
                }
            });
            viewer.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    URL url = e.getURL();
                    if (url != null) {
                        BrowserUtil.browse((URL)url);
                    }
                }
            });
            viewer.setText("<html><body>" + ConsentSettingsUi.getParagraphTag() + StringUtil.replace((String)consent.getText(), (String)"\n", (String)("</p>" + ConsentSettingsUi.getParagraphTag())) + "</p></body></html>");
            StyleSheet styleSheet = ((HTMLDocument)viewer.getDocument()).getStyleSheet();
            styleSheet.addRule("body {margin-top:0;padding-top:0;}");
            styleSheet.addRule("h2, em {margin-top:" + JBUI.scaleFontSize((float)20.0f) + "pt;}");
            styleSheet.addRule("h1, h2, h3, p, h4, em {margin-bottom:0;padding-bottom:0;}");
            styleSheet.addRule("p, h1 {margin-top:0;padding-top:" + JBUI.scaleFontSize((float)6.0f) + "pt;}");
            styleSheet.addRule("li {margin-bottom:" + JBUI.scaleFontSize((float)6.0f) + "pt;}");
            styleSheet.addRule("h2 {margin-top:0;padding-top:" + JBUI.scaleFontSize((float)13.0f) + "pt;}");
            styleSheet.addRule("a, a:link {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkColor()) + ";}");
            styleSheet.addRule("a:hover {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkHoverColor()) + ";}");
            styleSheet.addRule("a:active {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.linkPressedColor()) + ";}");
            viewer.setCaretPosition(0);
            pane.add((Component)viewer, "Center");
            this.consentMapping.add((Pair<JCheckBox, Consent>)Pair.create(null, (Object)consent));
        }
        pane.setOpaque(false);
        return pane;
    }

    @NotNull
    private List<Consent> getState() {
        ArrayList<Consent> result2 = new ArrayList<Consent>();
        for (Pair<JCheckBox, Consent> pair : this.consentMapping) {
            JCheckBox checkBox2 = (JCheckBox)pair.first;
            result2.add(((Consent)pair.second).derive(checkBox2 == null || checkBox2.isSelected()));
        }
        return result2;
    }

    public boolean isModified(@NotNull List<Consent> consents) {
        List<Consent> state = this.getState();
        if (consents.size() != state.size()) {
            return true;
        }
        for (int i = 0; i < state.size(); ++i) {
            Consent consent2;
            Consent consent1 = state.get(i);
            if (!consent1.equals(consent2 = consents.get(i))) {
                return true;
            }
            if (consent1.isAccepted() == consent2.isAccepted()) continue;
            return true;
        }
        return false;
    }

    public void apply(@NotNull List<Consent> consents) {
        consents.clear();
        consents.addAll(this.getState());
        if (this.myPreferencesMode) {
            ConsentOptions.getInstance().setConsents(consents);
        }
    }

    @NotNull
    public JComponent getComponent() {
        return this;
    }
}

