/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.Prefs;
import com.intellij.ide.gdpr.Locations;
import com.intellij.ide.gdpr.Version;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

public final class EndUserAgreement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.PrivacyPolicy");
    private static final String POLICY_TEXT_PROPERTY = "jb.privacy.policy.text";
    private static final String PRIVACY_POLICY_DOCUMENT_NAME = "privacy";
    private static final String EULA_DOCUMENT_NAME = "eua";
    private static final String PRIVACY_POLICY_CONTENT_FILE_NAME = "Cached";
    private static final String DEFAULT_DOC_NAME = "eua";
    private static final String DEFAULT_DOC_EAP_NAME = "euaEap";
    private static final String ACTIVE_DOC_FILE_NAME = "documentName";
    private static final String ACTIVE_DOC_EAP_FILE_NAME = "documentName.eap";
    private static final String RELATIVE_RESOURCE_PATH = "PrivacyPolicy";
    private static final String VERSION_COMMENT_START = "<!--";
    private static final String VERSION_COMMENT_END = "-->";
    private static final Version MAGIC_VERSION = new Version(999, 999);

    public static File getDocumentContentFile() {
        return EndUserAgreement.getDocumentContentFile(EndUserAgreement.getDocumentName());
    }

    @NotNull
    private static File getDocumentContentFile(String docName) {
        return new File(EndUserAgreement.getDataRoot(), PRIVACY_POLICY_DOCUMENT_NAME.equals(docName) ? PRIVACY_POLICY_CONTENT_FILE_NAME : docName + ".cached");
    }

    @NotNull
    private static File getDocumentNameFile() {
        return new File(EndUserAgreement.getDataRoot(), ApplicationInfoImpl.getShadowInstance().isEAP() ? ACTIVE_DOC_EAP_FILE_NAME : ACTIVE_DOC_FILE_NAME);
    }

    private static File getDataRoot() {
        return new File(Locations.getDataRoot(), RELATIVE_RESOURCE_PATH);
    }

    private static String getBundledResourcePath(String docName) {
        return PRIVACY_POLICY_DOCUMENT_NAME.equals(docName) ? "/PrivacyPolicy.html" : "/" + docName + ".html";
    }

    public static void setAccepted(@NotNull Document doc) {
        Version version2 = doc.getVersion();
        if (version2.isUnknown()) {
            Prefs.remove((String)EndUserAgreement.getAcceptedVersionKey(doc.getName()));
        } else {
            Prefs.put((String)EndUserAgreement.getAcceptedVersionKey(doc.getName()), (String)version2.toString());
        }
    }

    @NotNull
    private static Version getAcceptedVersion(String docName) {
        return Version.fromString(Prefs.get((String)EndUserAgreement.getAcceptedVersionKey(docName), null));
    }

    @NotNull
    public static Document getLatestDocument() {
        Document fromProperty;
        String text = System.getProperty(POLICY_TEXT_PROPERTY, null);
        if (text != null && !(fromProperty = EndUserAgreement.loadContent(PRIVACY_POLICY_DOCUMENT_NAME, new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8)))).getVersion().isUnknown()) {
            return fromProperty;
        }
        String docName = EndUserAgreement.getDocumentName();
        try {
            Document fromFile = EndUserAgreement.loadContent(docName, new FileInputStream(EndUserAgreement.getDocumentContentFile(docName)));
            if (!fromFile.getVersion().isUnknown()) {
                return fromFile;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return EndUserAgreement.loadContent(docName, EndUserAgreement.class.getResourceAsStream(EndUserAgreement.getBundledResourcePath(docName)));
    }

    public static void update(String docName, String text) {
        try {
            FileUtil.writeToFile((File)EndUserAgreement.getDocumentContentFile(docName), (String)text);
            FileUtil.writeToFile((File)EndUserAgreement.getDocumentNameFile(), (String)docName);
        }
        catch (FileNotFoundException e) {
            LOG.info(e.getMessage());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static Document loadContent(String docName, InputStream stream) {
        if (stream == null) return new Document(docName, "");
        try (InputStreamReader reader = new InputStreamReader(stream instanceof ByteArrayInputStream ? stream : new BufferedInputStream(stream), StandardCharsets.UTF_8);){
            Document document = new Document(docName, new String(FileUtil.adaptiveLoadText((Reader)reader)));
            return document;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return new Document(docName, "");
    }

    @NotNull
    private static String getDocumentName() {
        if (!PlatformUtils.isCommercialEdition()) {
            return PRIVACY_POLICY_DOCUMENT_NAME;
        }
        try {
            String docName = new String(FileUtilRt.loadFileText((File)EndUserAgreement.getDocumentNameFile(), (Charset)StandardCharsets.UTF_8));
            if (!StringUtil.isEmptyOrSpaces((String)docName)) {
                return docName;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if ("eua".equals(PRIVACY_POLICY_DOCUMENT_NAME)) {
            return PRIVACY_POLICY_DOCUMENT_NAME;
        }
        return ApplicationInfoImpl.getShadowInstance().isEAP() ? DEFAULT_DOC_EAP_NAME : "eua";
    }

    @NotNull
    private static String getAcceptedVersionKey(String docName) {
        return PRIVACY_POLICY_DOCUMENT_NAME.equals(docName) ? "JetBrains.privacy_policy.accepted_version" : "JetBrains.privacy_policy." + docName + "_accepted_version";
    }

    public static final class Document {
        private final String myName;
        private final String myText;
        private final Version myVersion;

        public Document(String name, String text) {
            this.myName = name;
            this.myText = text;
            this.myVersion = Document.parseVersion(text);
        }

        public boolean isPrivacyPolicy() {
            return EndUserAgreement.PRIVACY_POLICY_DOCUMENT_NAME.equals(this.myName);
        }

        public boolean isAccepted() {
            Version thisVersion = this.getVersion();
            if (thisVersion.isUnknown() || MAGIC_VERSION.equals(thisVersion)) {
                return true;
            }
            Version acceptedByUser = EndUserAgreement.getAcceptedVersion(this.getName());
            return !acceptedByUser.isUnknown() && acceptedByUser.getMajor() >= thisVersion.getMajor();
        }

        public String getName() {
            return this.myName;
        }

        public Version getVersion() {
            return this.myVersion;
        }

        public String getText() {
            return this.myText;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        private static Version parseVersion(String text) {
            if (StringUtil.isEmptyOrSpaces((String)text)) return Version.UNKNOWN;
            try (BufferedReader reader = new BufferedReader(new StringReader(text));){
                String line = reader.readLine();
                if (line == null) return Version.UNKNOWN;
                int startComment = line.indexOf(EndUserAgreement.VERSION_COMMENT_START);
                if (startComment < 0) return Version.UNKNOWN;
                int endComment = line.indexOf(EndUserAgreement.VERSION_COMMENT_END);
                if (endComment <= startComment) return Version.UNKNOWN;
                Version version2 = Version.fromString(line.substring(startComment + EndUserAgreement.VERSION_COMMENT_START.length(), endComment).trim());
                return version2;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            return Version.UNKNOWN;
        }
    }
}

