/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.util.SystemProperties;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

class ExporterToTextFileHierarchy
implements ExporterToTextFile {
    private static final Logger LOG = Logger.getInstance(ExporterToTextFileHierarchy.class);
    private final HierarchyBrowserBase myHierarchyBrowserBase;

    ExporterToTextFileHierarchy(@NotNull HierarchyBrowserBase hierarchyBrowserBase) {
        this.myHierarchyBrowserBase = hierarchyBrowserBase;
    }

    @NotNull
    public String getReportText() {
        StringBuilder buf = new StringBuilder();
        StructureTreeModel currentBuilder = this.myHierarchyBrowserBase.getCurrentBuilder();
        LOG.assertTrue(currentBuilder != null);
        this.appendNode(buf, currentBuilder.getRootImmediately(), SystemProperties.getLineSeparator(), "");
        return buf.toString();
    }

    private void appendNode(StringBuilder buf, @NotNull TreeNode node, String lineSeparator, String indent) {
        String childIndent;
        if (node.getParent() != null) {
            childIndent = indent + "    ";
            HierarchyNodeDescriptor descriptor = this.myHierarchyBrowserBase.getDescriptor((DefaultMutableTreeNode)node);
            if (descriptor != null) {
                buf.append(indent).append(descriptor.getHighlightedText().getText()).append(lineSeparator);
            }
        } else {
            childIndent = indent;
        }
        Enumeration<? extends TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode child2 = (DefaultMutableTreeNode)enumeration.nextElement();
            this.appendNode(buf, child2, lineSeparator, childIndent);
        }
    }

    @NotNull
    public String getDefaultFilePath() {
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getInstance(this.myHierarchyBrowserBase.myProject).getState();
        return state != null && state.EXPORT_FILE_PATH != null ? state.EXPORT_FILE_PATH : "";
    }

    public void exportedTo(@NotNull String filePath) {
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getInstance(this.myHierarchyBrowserBase.myProject).getState();
        if (state != null) {
            state.EXPORT_FILE_PATH = filePath;
        }
    }

    public boolean canExport() {
        return this.myHierarchyBrowserBase.getCurrentBuilder() != null;
    }
}

