/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.HierarchyTreeBuilder;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.actions.BrowseHierarchyActionBase;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeBuilderUtil;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.PsiElementNavigatable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.SingleAlarm;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HierarchyBrowserBaseEx
extends HierarchyBrowserBase
implements OccurenceNavigator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.hierarchy.HierarchyBrowserBaseEx");
    public static final String SCOPE_PROJECT = IdeBundle.message((String)"hierarchy.scope.project", (Object[])new Object[0]);
    public static final String SCOPE_ALL = IdeBundle.message((String)"hierarchy.scope.all", (Object[])new Object[0]);
    public static final String SCOPE_TEST = IdeBundle.message((String)"hierarchy.scope.test", (Object[])new Object[0]);
    public static final String SCOPE_CLASS = IdeBundle.message((String)"hierarchy.scope.this.class", (Object[])new Object[0]);
    public static final String HELP_ID = "reference.toolWindows.hierarchy";
    @Deprecated
    protected final Hashtable<String, HierarchyTreeBuilder> myBuilders = new Hashtable();
    @Deprecated
    protected String myCurrentViewType;
    private final Map<String, Sheet> myType2Sheet = new THashMap();
    private final RefreshAction myRefreshAction = new RefreshAction();
    private final SingleAlarm myCursorAlarm = new SingleAlarm(() -> this.setCursor(Cursor.getPredefinedCursor(3)), 100, this);
    private SmartPsiElementPointer mySmartPsiElementPointer;
    private final CardLayout myCardLayout;
    private final JPanel myTreePanel;
    private boolean myCachedIsValidBase;

    public HierarchyBrowserBaseEx(@NotNull Project project, @NotNull PsiElement element) {
        super(project);
        JPanel contentPanel;
        this.setHierarchyBase(element);
        this.myCardLayout = new CardLayout();
        this.myTreePanel = new JPanel(this.myCardLayout);
        THashMap type2treeMap = new THashMap();
        this.createTrees((Map<String, JTree>)type2treeMap);
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getSettings(project);
        for (Map.Entry entry : type2treeMap.entrySet()) {
            JTree tree = (JTree)entry.getValue();
            String type = (String)entry.getKey();
            String scope = state.SCOPE != null ? state.SCOPE : SCOPE_ALL;
            OccurenceNavigatorSupport occurenceNavigatorSupport = new OccurenceNavigatorSupport(tree){

                @Nullable
                protected Navigatable createDescriptorForNode(@NotNull DefaultMutableTreeNode node) {
                    PsiElement psiElement;
                    HierarchyNodeDescriptor descriptor = HierarchyBrowserBaseEx.this.getDescriptor(node);
                    if (descriptor != null && (psiElement = HierarchyBrowserBaseEx.this.getOpenFileElementFromDescriptor(descriptor)) != null && psiElement.isValid()) {
                        return new PsiElementNavigatable(psiElement);
                    }
                    return null;
                }

                @NotNull
                public String getNextOccurenceActionName() {
                    return HierarchyBrowserBaseEx.this.getNextOccurenceActionNameImpl();
                }

                @NotNull
                public String getPreviousOccurenceActionName() {
                    return HierarchyBrowserBaseEx.this.getPrevOccurenceActionNameImpl();
                }
            };
            this.myType2Sheet.put(type, new Sheet(type, tree, scope, (OccurenceNavigator)occurenceNavigatorSupport));
            this.myTreePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)tree), type);
        }
        JPanel legendPanel = this.createLegendPanel();
        if (legendPanel != null) {
            contentPanel = new JPanel(new BorderLayout());
            contentPanel.add((Component)this.myTreePanel, "Center");
            contentPanel.add((Component)legendPanel, "South");
        } else {
            contentPanel = this.myTreePanel;
        }
        this.buildUi(this.createToolbar(this.getActionPlace(), HELP_ID).getComponent(), contentPanel);
    }

    @Nullable
    protected PsiElement getOpenFileElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        return this.getElementFromDescriptor(descriptor);
    }

    @Override
    @Nullable
    protected abstract PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor var1);

    @NotNull
    protected abstract String getPrevOccurenceActionNameImpl();

    @NotNull
    protected abstract String getNextOccurenceActionNameImpl();

    protected abstract void createTrees(@NotNull Map<String, JTree> var1);

    @Nullable
    protected abstract JPanel createLegendPanel();

    protected abstract boolean isApplicableElement(@NotNull PsiElement var1);

    protected boolean isApplicableElementForBaseOn(@NotNull PsiElement element) {
        return this.isApplicableElement(element);
    }

    @Nullable
    protected abstract HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String var1, @NotNull PsiElement var2);

    @Nullable
    protected abstract Comparator<NodeDescriptor> getComparator();

    @NotNull
    protected abstract String getActionPlace();

    @NotNull
    protected abstract String getBrowserDataKey();

    @Nullable
    protected Color getFileColorForNode(Object node) {
        if (node instanceof HierarchyNodeDescriptor) {
            PsiFile containingFile = ((HierarchyNodeDescriptor)((Object)node)).getContainingFile();
            return ProjectViewTree.getColorForElement((PsiElement)containingFile);
        }
        return null;
    }

    @NotNull
    protected final JTree createTree(boolean dndAware) {
        Tree tree;
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode(""));
        if (dndAware) {
            tree = new DnDAwareTree(treeModel){

                public void addNotify() {
                    super.addNotify();
                    HierarchyBrowserBaseEx.this.myRefreshAction.registerShortcutOn((JComponent)((Object)this));
                }

                public void removeNotify() {
                    super.removeNotify();
                    HierarchyBrowserBaseEx.this.myRefreshAction.unregisterCustomShortcutSet((JComponent)((Object)this));
                }

                public boolean isFileColorsEnabled() {
                    return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
                }

                public Color getFileColorFor(Object object) {
                    return HierarchyBrowserBaseEx.this.getFileColorForNode(object);
                }
            };
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                DnDManager.getInstance().registerSource(new DnDSource(){

                    public boolean canStartDragging(DnDAction action, Point dragOrigin) {
                        return HierarchyBrowserBaseEx.this.getSelectedElements().length > 0;
                    }

                    public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
                        return new DnDDragStartBean((Object)new TransferableWrapper(){

                            @Override
                            public TreeNode[] getTreeNodes() {
                                return (TreeNode[])tree.getSelectedNodes(TreeNode.class, null);
                            }

                            @Override
                            public PsiElement[] getPsiElements() {
                                return HierarchyBrowserBaseEx.this.getSelectedElements();
                            }

                            @Override
                            public List<File> asFileList() {
                                return PsiCopyPasteManager.asFileList(this.getPsiElements());
                            }
                        });
                    }

                    public void dragDropEnd() {
                    }

                    public void dropActionChanged(int gestureModifiers) {
                    }
                }, (JComponent)tree);
            }
        } else {
            tree = new Tree(treeModel){

                public void addNotify() {
                    super.addNotify();
                    HierarchyBrowserBaseEx.this.myRefreshAction.registerShortcutOn((JComponent)((Object)this));
                }

                public void removeNotify() {
                    super.removeNotify();
                    HierarchyBrowserBaseEx.this.myRefreshAction.unregisterCustomShortcutSet((JComponent)((Object)this));
                }

                public boolean isFileColorsEnabled() {
                    return ProjectViewTree.isFileColorsEnabledFor((JTree)((Object)this));
                }

                public Color getFileColorFor(Object object) {
                    return HierarchyBrowserBaseEx.this.getFileColorForNode(object);
                }
            };
        }
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)tree);
        this.configureTree(tree);
        EditSourceOnDoubleClickHandler.install((JTree)tree);
        EditSourceOnEnterKeyHandler.install((JTree)tree);
        return tree;
    }

    protected void setHierarchyBase(@NotNull PsiElement element) {
        this.mySmartPsiElementPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(element);
    }

    protected PsiElement getHierarchyBase() {
        return this.mySmartPsiElementPointer.getElement();
    }

    private void restoreCursor() {
        this.myCursorAlarm.cancelAllRequests();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void setWaitCursor() {
        this.myCursorAlarm.request();
    }

    public void changeView(@NotNull String typeName) {
        this.changeView(typeName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeView(@NotNull String typeName, boolean requestFocus) {
        String displayName;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myCurrentViewType = typeName;
        PsiElement element = this.mySmartPsiElementPointer.getElement();
        if (element == null || !this.isApplicableElement(element)) {
            return;
        }
        if (this.myContent != null && (displayName = this.getContentDisplayName(typeName, element)) != null) {
            this.myContent.setDisplayName(displayName);
        }
        this.myCardLayout.show(this.myTreePanel, typeName);
        Sheet sheet = this.myType2Sheet.get(typeName);
        if (sheet.myStructureTreeModel == null) {
            try {
                this.setWaitCursor();
                JTree tree = sheet.myTree;
                HierarchyTreeStructure structure = this.createHierarchyTreeStructure(typeName, element);
                if (structure == null) {
                    return;
                }
                Comparator<NodeDescriptor> comparator2 = this.getComparator();
                StructureTreeModel<HierarchyTreeStructure> myModel = comparator2 == null ? new StructureTreeModel<HierarchyTreeStructure>(structure) : new StructureTreeModel<HierarchyTreeStructure>(structure, comparator2);
                AsyncTreeModel atm = new AsyncTreeModel((TreeModel)((Object)myModel), sheet);
                tree.setModel((TreeModel)((Object)atm));
                sheet.myStructureTreeModel = myModel;
                sheet.myAsyncTreeModel = atm;
                this.selectLater(tree, structure.getBaseDescriptor());
                this.expandLater(tree, structure.getBaseDescriptor());
            }
            finally {
                this.restoreCursor();
            }
        }
        if (requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getCurrentTree(), true));
        }
    }

    private static boolean isAncestor(@NotNull Project project, @NotNull HierarchyNodeDescriptor ancestor, @NotNull HierarchyNodeDescriptor child2) {
        PsiElement ancestorElement = ancestor.getPsiElement();
        while (child2 != null) {
            PsiElement childElement = child2.getPsiElement();
            if (PsiManager.getInstance((Project)project).areElementsEquivalent(ancestorElement, childElement)) {
                return true;
            }
            child2 = (HierarchyNodeDescriptor)child2.getParentDescriptor();
        }
        return false;
    }

    private void selectLater(@NotNull JTree tree, @NotNull HierarchyNodeDescriptor descriptor) {
        TreeUtil.promiseSelect((JTree)tree, (TreeVisitor)this.visitor(descriptor));
    }

    private void selectLater(@NotNull JTree tree, @NotNull List<? extends HierarchyNodeDescriptor> descriptors) {
        TreeUtil.promiseSelect((JTree)tree, descriptors.stream().map(descriptor -> this.visitor((HierarchyNodeDescriptor)((Object)descriptor))));
    }

    private void expandLater(@NotNull JTree tree, @NotNull HierarchyNodeDescriptor descriptor) {
        TreeUtil.promiseExpand((JTree)tree, (TreeVisitor)this.visitor(descriptor));
    }

    @NotNull
    private TreeVisitor visitor(@NotNull HierarchyNodeDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (element == null) {
            return path -> TreeVisitor.Action.INTERRUPT;
        }
        PsiManager psiManager = element.getManager();
        return path -> {
            Object component = path.getLastPathComponent();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)component;
            Object object = node.getUserObject();
            HierarchyNodeDescriptor current = (HierarchyNodeDescriptor)((Object)((Object)object));
            PsiElement currentPsiElement = current.getPsiElement();
            if (psiManager.areElementsEquivalent(currentPsiElement, element)) {
                return TreeVisitor.Action.INTERRUPT;
            }
            return HierarchyBrowserBaseEx.isAncestor(this.myProject, current, descriptor) ? TreeVisitor.Action.CONTINUE : TreeVisitor.Action.SKIP_CHILDREN;
        };
    }

    @Nullable
    protected String getContentDisplayName(@NotNull String typeName, @NotNull PsiElement element) {
        if (element instanceof PsiNamedElement) {
            return MessageFormat.format(typeName, ((PsiNamedElement)element).getName());
        }
        return null;
    }

    @Override
    protected void appendActions(@NotNull DefaultActionGroup actionGroup, @Nullable String helpID) {
        this.prependActions(actionGroup);
        actionGroup.add((AnAction)this.myRefreshAction);
        super.appendActions(actionGroup, helpID);
    }

    protected void prependActions(@NotNull DefaultActionGroup actionGroup) {
    }

    public boolean hasNextOccurence() {
        return this.getOccurrenceNavigator().hasNextOccurence();
    }

    @NotNull
    private OccurenceNavigator getOccurrenceNavigator() {
        OccurenceNavigator navigator;
        String currentViewType = this.getCurrentViewType();
        if (currentViewType != null && (navigator = this.myType2Sheet.get(currentViewType).myOccurenceNavigator) != null) {
            return navigator;
        }
        return EMPTY;
    }

    public boolean hasPreviousOccurence() {
        return this.getOccurrenceNavigator().hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.getOccurrenceNavigator().goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.getOccurrenceNavigator().goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        return this.getOccurrenceNavigator().getNextOccurenceActionName();
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        return this.getOccurrenceNavigator().getPreviousOccurenceActionName();
    }

    @NotNull
    public StructureTreeModel getTreeModel(@NotNull String viewType) {
        return this.myType2Sheet.get(viewType).myStructureTreeModel;
    }

    @Override
    StructureTreeModel getCurrentBuilder() {
        String viewType = this.getCurrentViewType();
        if (viewType == null) {
            return null;
        }
        Sheet sheet = this.myType2Sheet.get(viewType);
        return sheet == null ? null : sheet.myStructureTreeModel;
    }

    final boolean isValidBase() {
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (PsiDocumentManager.getInstance((Project)this.myProject).getUncommittedDocuments().length > 0) {
            return this.myCachedIsValidBase;
        }
        PsiElement element = this.mySmartPsiElementPointer.getElement();
        this.myCachedIsValidBase = element != null && this.isApplicableElement(element) && element.isValid();
        return this.myCachedIsValidBase;
    }

    @Override
    protected JTree getCurrentTree() {
        String currentViewType = this.getCurrentViewType();
        return currentViewType == null ? null : this.myType2Sheet.get(currentViewType).myTree;
    }

    protected final String getCurrentViewType() {
        return this.myCurrentViewType;
    }

    @Override
    public Object getData(@NotNull String dataId) {
        if (this.getBrowserDataKey().equals(dataId)) {
            return this;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    @Override
    public void dispose() {
        this.disposeAllSheets();
        super.dispose();
    }

    private void disposeAllSheets() {
        for (Sheet sheet : this.myType2Sheet.values()) {
            this.disposeSheet(sheet);
        }
    }

    private void disposeSheet(@NotNull Sheet sheet) {
        Disposer.dispose((Disposable)sheet);
        this.myType2Sheet.put(sheet.myType, new Sheet(sheet.myType, sheet.myTree, sheet.myScope, sheet.myOccurenceNavigator));
    }

    protected void doRefresh(boolean currentBuilderOnly) {
        PsiElement element;
        if (currentBuilderOnly) {
            LOG.assertTrue(this.getCurrentViewType() != null);
        }
        if (!this.isValidBase()) {
            return;
        }
        if (this.getCurrentBuilder() == null) {
            return;
        }
        String currentViewType = this.getCurrentViewType();
        ArrayList pathsToExpand = new ArrayList();
        ArrayList selectionPaths = new ArrayList();
        if (currentViewType != null) {
            Sheet sheet = this.myType2Sheet.get(currentViewType);
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)sheet.myAsyncTreeModel.getRoot();
            TreeBuilderUtil.storePaths((JTree)sheet.myTree, (DefaultMutableTreeNode)root, pathsToExpand, selectionPaths, (boolean)true);
        }
        if ((element = this.mySmartPsiElementPointer.getElement()) == null || !this.isApplicableElement(element)) {
            return;
        }
        if (currentBuilderOnly) {
            Sheet sheet = this.myType2Sheet.get(currentViewType);
            this.disposeSheet(sheet);
        } else {
            this.disposeAllSheets();
        }
        this.setHierarchyBase(element);
        this.validate();
        ApplicationManager.getApplication().invokeLater(() -> {
            this.changeView(currentViewType);
            for (Object p : pathsToExpand) {
                HierarchyNodeDescriptor descriptor = (HierarchyNodeDescriptor)((Object)((Object)p));
                this.expandLater(this.getCurrentTree(), descriptor);
            }
            this.selectLater(this.getCurrentTree(), selectionPaths);
        }, __ -> this.isDisposed());
    }

    protected String getCurrentScopeType() {
        String currentViewType = this.getCurrentViewType();
        return currentViewType == null ? null : this.myType2Sheet.get(currentViewType).myScope;
    }

    @NotNull
    private Collection<String> getValidScopeNames() {
        NamedScopesHolder[] holders;
        ArrayList<String> result2 = new ArrayList<String>();
        result2.add(SCOPE_PROJECT);
        result2.add(SCOPE_TEST);
        result2.add(SCOPE_ALL);
        result2.add(SCOPE_CLASS);
        for (NamedScopesHolder holder : holders = NamedScopesHolder.getAllNamedScopeHolders((Project)this.myProject)) {
            NamedScope[] scopes;
            for (NamedScope scope : scopes = holder.getEditableScopes()) {
                result2.add(scope.getName());
            }
        }
        return result2;
    }

    public class ChangeScopeAction
    extends ComboBoxAction {
        public final void update(@NotNull AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            presentation.setEnabled(this.isEnabled());
            presentation.setText(HierarchyBrowserBaseEx.this.getCurrentScopeType());
        }

        protected boolean isEnabled() {
            return true;
        }

        @NotNull
        protected final DefaultActionGroup createPopupActionGroup(JComponent button2) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (String name : HierarchyBrowserBaseEx.this.getValidScopeNames()) {
                group.add((AnAction)new MenuAction(name));
            }
            group.add((AnAction)new ConfigureScopesAction());
            return group;
        }

        private void selectScope(@NotNull String scopeType) {
            ((Sheet)HierarchyBrowserBaseEx.this.myType2Sheet.get(HierarchyBrowserBaseEx.this.getCurrentViewType())).myScope = scopeType;
            HierarchyBrowserManager.getSettings((Project)HierarchyBrowserBaseEx.this.myProject).SCOPE = scopeType;
            ApplicationManager.getApplication().invokeLater(() -> HierarchyBrowserBaseEx.this.doRefresh(true), __ -> HierarchyBrowserBaseEx.this.isDisposed());
        }

        @NotNull
        public final JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            JPanel panel2 = new JPanel(new GridBagLayout());
            panel2.add((Component)new JLabel(IdeBundle.message((String)"label.scope", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, (Insets)JBUI.insetsLeft((int)5), 0, 0));
            panel2.add((Component)super.createCustomComponent(presentation, place), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, (Insets)JBUI.emptyInsets(), 0, 0));
            return panel2;
        }

        private final class ConfigureScopesAction
        extends AnAction {
            private ConfigureScopesAction() {
                super("Configure...");
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                EditScopesDialog.showDialog(HierarchyBrowserBaseEx.this.myProject, null);
                if (!HierarchyBrowserBaseEx.this.getValidScopeNames().contains(HierarchyBrowserBaseEx.this.getCurrentScopeType())) {
                    ChangeScopeAction.this.selectScope(SCOPE_ALL);
                }
            }
        }

        private final class MenuAction
        extends AnAction {
            private final String myScopeType;

            MenuAction(String scopeType) {
                super(scopeType);
                this.myScopeType = scopeType;
            }

            public final void actionPerformed(@NotNull AnActionEvent e) {
                ChangeScopeAction.this.selectScope(this.myScopeType);
            }
        }
    }

    private class RefreshAction
    extends com.intellij.ide.actions.RefreshAction {
        RefreshAction() {
            super(IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), AllIcons.Actions.Refresh);
        }

        @Override
        public final void actionPerformed(@NotNull AnActionEvent e) {
            HierarchyBrowserBaseEx.this.doRefresh(false);
        }

        @Override
        public final void update(@NotNull AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(HierarchyBrowserBaseEx.this.isValidBase());
        }
    }

    protected static class BaseOnThisElementAction
    extends AnAction {
        private final String myBrowserDataKey;
        private final LanguageExtension<HierarchyProvider> myProviderLanguageExtension;

        protected BaseOnThisElementAction(@NotNull String text, @NotNull String browserDataKey, @NotNull LanguageExtension<HierarchyProvider> providerLanguageExtension) {
            super(text);
            this.myBrowserDataKey = browserDataKey;
            this.myProviderLanguageExtension = providerLanguageExtension;
        }

        public final void actionPerformed(@NotNull AnActionEvent event) {
            DataContext dataContext = event.getDataContext();
            HierarchyBrowserBaseEx browser2 = (HierarchyBrowserBaseEx)((Object)dataContext.getData(this.myBrowserDataKey));
            if (browser2 == null) {
                return;
            }
            PsiElement selectedElement = browser2.getSelectedElement();
            if (selectedElement == null || !browser2.isApplicableElementForBaseOn(selectedElement)) {
                return;
            }
            String currentViewType = browser2.getCurrentViewType();
            Disposer.dispose((Disposable)browser2);
            HierarchyProvider provider = BrowseHierarchyActionBase.findProvider(this.myProviderLanguageExtension, selectedElement, selectedElement.getContainingFile(), event.getDataContext());
            if (provider != null) {
                HierarchyBrowserBaseEx newBrowser = (HierarchyBrowserBaseEx)BrowseHierarchyActionBase.createAndAddToPanel(selectedElement.getProject(), provider, selectedElement);
                ApplicationManager.getApplication().invokeLater(() -> newBrowser.changeView(this.correctViewType(browser2, currentViewType)), __ -> newBrowser.isDisposed());
            }
        }

        protected String correctViewType(@NotNull HierarchyBrowserBaseEx browser2, String viewType) {
            return viewType;
        }

        public final void update(@NotNull AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            DataContext dataContext = event.getDataContext();
            HierarchyBrowserBaseEx browser2 = (HierarchyBrowserBaseEx)((Object)dataContext.getData(this.myBrowserDataKey));
            if (browser2 == null) {
                presentation.setVisible(false);
                presentation.setEnabled(false);
                return;
            }
            presentation.setVisible(true);
            PsiElement selectedElement = browser2.getSelectedElement();
            if (selectedElement == null || !browser2.isApplicableElementForBaseOn(selectedElement)) {
                presentation.setEnabledAndVisible(false);
            } else {
                String typeName = ElementDescriptionUtil.getElementDescription((PsiElement)selectedElement, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
                if (StringUtil.isNotEmpty((String)typeName)) {
                    presentation.setText(IdeBundle.message((String)"action.base.on.this.0", (Object[])new Object[]{StringUtil.capitalize((String)typeName)}));
                }
                presentation.setEnabled(this.isEnabled(browser2, selectedElement));
            }
        }

        protected boolean isEnabled(@NotNull HierarchyBrowserBaseEx browser2, @NotNull PsiElement element) {
            return !element.equals(browser2.mySmartPsiElementPointer.getElement()) && element.isValid();
        }
    }

    protected class AlphaSortAction
    extends ToggleAction {
        public AlphaSortAction() {
            super(IdeBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), IdeBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), AllIcons.ObjectBrowser.Sorted);
        }

        public final boolean isSelected(@NotNull AnActionEvent event) {
            return HierarchyBrowserManager.getSettings((Project)HierarchyBrowserBaseEx.this.myProject).SORT_ALPHABETICALLY;
        }

        public final void setSelected(@NotNull AnActionEvent event, boolean flag) {
            HierarchyBrowserManager.getSettings((Project)HierarchyBrowserBaseEx.this.myProject).SORT_ALPHABETICALLY = flag;
            Comparator<NodeDescriptor> comparator2 = HierarchyBrowserBaseEx.this.getComparator();
            HierarchyBrowserBaseEx.this.myType2Sheet.values().stream().map(s -> ((Sheet)s).myStructureTreeModel).filter(m -> m != null).forEach(m -> m.setComparator(comparator2));
        }

        public final void update(@NotNull AnActionEvent event) {
            super.update(event);
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(HierarchyBrowserBaseEx.this.isValidBase());
        }
    }

    private static class Sheet
    implements Disposable {
        private AsyncTreeModel myAsyncTreeModel;
        private StructureTreeModel myStructureTreeModel;
        @NotNull
        private final String myType;
        private final JTree myTree;
        private String myScope;
        private final OccurenceNavigator myOccurenceNavigator;

        Sheet(@NotNull String type, @NotNull JTree tree, @NotNull String scope, @NotNull OccurenceNavigator occurenceNavigator) {
            this.myType = type;
            this.myTree = tree;
            this.myScope = scope;
            this.myOccurenceNavigator = occurenceNavigator;
        }

        public void dispose() {
            this.myAsyncTreeModel = null;
            this.myStructureTreeModel = null;
        }
    }
}

