/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.SmartElementDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usageView.UsageTreeColorsScheme;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HierarchyNodeDescriptor
extends SmartElementDescriptor {
    @NotNull
    protected CompositeAppearance myHighlightedText = new CompositeAppearance();
    private Object[] myCachedChildren;
    protected final boolean myIsBase;

    protected HierarchyNodeDescriptor(@NotNull Project project, @Nullable NodeDescriptor parentDescriptor, @NotNull PsiElement element, boolean isBase) {
        super(project, parentDescriptor, element);
        this.myName = "";
        this.myIsBase = isBase;
    }

    @Override
    public final Object getElement() {
        return this;
    }

    @Nullable
    public PsiFile getContainingFile() {
        PsiElement element = this.getPsiElement();
        return element != null ? element.getContainingFile() : null;
    }

    public boolean isValid() {
        return this.getPsiElement() != null;
    }

    public final Object[] getCachedChildren() {
        return this.myCachedChildren;
    }

    public final void setCachedChildren(Object[] cachedChildren) {
        this.myCachedChildren = cachedChildren;
    }

    @Override
    protected final boolean isMarkReadOnly() {
        return true;
    }

    @Override
    protected final boolean isMarkModified() {
        return true;
    }

    @NotNull
    public final CompositeAppearance getHighlightedText() {
        return this.myHighlightedText;
    }

    protected static TextAttributes getInvalidPrefixAttributes() {
        return UsageTreeColorsScheme.getInstance().getScheme().getAttributes(UsageTreeColors.INVALID_PREFIX);
    }

    protected static TextAttributes getUsageCountPrefixAttributes() {
        return UsageTreeColorsScheme.getInstance().getScheme().getAttributes(UsageTreeColors.NUMBER_OF_USAGES);
    }

    protected static TextAttributes getPackageNameAttributes() {
        return HierarchyNodeDescriptor.getUsageCountPrefixAttributes();
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    protected final boolean invalidElement() {
        String invalidPrefix = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
        if (!this.myHighlightedText.getText().startsWith(invalidPrefix)) {
            this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
        }
        return true;
    }

    protected final void installIcon(@Nullable Icon elementIcon, boolean changes2) {
        if (changes2 && this.myIsBase) {
            LayeredIcon icon = new LayeredIcon(2);
            icon.setIcon(elementIcon, 0);
            icon.setIcon(AllIcons.Actions.Forward, 1, -AllIcons.Actions.Forward.getIconWidth() / 2, 0);
            this.setIcon((Icon)icon);
        } else {
            this.setIcon(elementIcon);
        }
    }

    protected final void installIcon(@NotNull PsiElement element, boolean changes2) {
        Icon icon = this.getIcon(element);
        this.installIcon(icon, changes2);
    }

    protected final void installIcon(boolean changes2) {
        this.installIcon(this.getIcon(), changes2);
    }
}

