/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.tree.LeafState;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public abstract class HierarchyTreeStructure
extends AbstractTreeStructure {
    protected HierarchyNodeDescriptor myBaseDescriptor;
    private HierarchyNodeDescriptor myRoot;
    @NotNull
    protected final Project myProject;

    protected HierarchyTreeStructure(@NotNull Project project, HierarchyNodeDescriptor baseDescriptor) {
        this.myBaseDescriptor = baseDescriptor;
        this.myProject = project;
        this.myRoot = baseDescriptor;
    }

    public final HierarchyNodeDescriptor getBaseDescriptor() {
        return this.myBaseDescriptor;
    }

    protected final void setBaseElement(@NotNull HierarchyNodeDescriptor baseElement) {
        this.myBaseDescriptor = baseElement;
        this.myRoot = baseElement;
        while (this.myRoot.getParentDescriptor() != null) {
            this.myRoot = (HierarchyNodeDescriptor)this.myRoot.getParentDescriptor();
        }
    }

    @NotNull
    public final NodeDescriptor createDescriptor(@NotNull Object element, NodeDescriptor parentDescriptor) {
        if (element instanceof HierarchyNodeDescriptor) {
            return (HierarchyNodeDescriptor)((Object)element);
        }
        if (element instanceof String) {
            return new TextInfoNodeDescriptor(parentDescriptor, (String)element, this.myProject);
        }
        throw new IllegalArgumentException("Unknown element type: " + element);
    }

    public final boolean isToBuildChildrenInBackground(@NotNull Object element) {
        if (element instanceof HierarchyNodeDescriptor) {
            HierarchyNodeDescriptor descriptor = (HierarchyNodeDescriptor)((Object)element);
            Object[] cachedChildren = descriptor.getCachedChildren();
            return cachedChildren == null && descriptor.isValid();
        }
        return false;
    }

    @NotNull
    public final Object[] getChildElements(@NotNull Object element) {
        if (element instanceof HierarchyNodeDescriptor) {
            HierarchyNodeDescriptor descriptor = (HierarchyNodeDescriptor)((Object)element);
            Object[] cachedChildren = descriptor.getCachedChildren();
            if (cachedChildren == null) {
                if (descriptor.isValid()) {
                    try {
                        cachedChildren = (Object[])AbstractTreeUi.calculateYieldingToWriteAction(() -> this.buildChildren(descriptor));
                    }
                    catch (IndexNotReadyException e) {
                        return ArrayUtil.EMPTY_OBJECT_ARRAY;
                    }
                } else {
                    cachedChildren = ArrayUtil.EMPTY_OBJECT_ARRAY;
                }
                descriptor.setCachedChildren(cachedChildren);
            }
            return cachedChildren;
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public final Object getParentElement(@NotNull Object element) {
        if (element instanceof HierarchyNodeDescriptor) {
            return ((HierarchyNodeDescriptor)((Object)element)).getParentDescriptor();
        }
        return null;
    }

    public final void commit() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
    }

    public final boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments();
    }

    @NotNull
    public ActionCallback asyncCommit() {
        return HierarchyTreeStructure.asyncCommitDocuments((Project)this.myProject);
    }

    @NotNull
    protected abstract Object[] buildChildren(@NotNull HierarchyNodeDescriptor var1);

    @NotNull
    public final Object getRootElement() {
        return this.myRoot;
    }

    protected SearchScope getSearchScope(String scopeType, PsiElement thisClass) {
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)this.myProject);
        if (HierarchyBrowserBaseEx.SCOPE_CLASS.equals(scopeType)) {
            searchScope = new LocalSearchScope(thisClass);
        } else if (HierarchyBrowserBaseEx.SCOPE_PROJECT.equals(scopeType)) {
            searchScope = GlobalSearchScopesCore.projectProductionScope((Project)this.myProject);
        } else if (HierarchyBrowserBaseEx.SCOPE_TEST.equals(scopeType)) {
            searchScope = GlobalSearchScopesCore.projectTestScope((Project)this.myProject);
        } else {
            NamedScope namedScope = NamedScopesHolder.getScope((Project)this.myProject, (String)scopeType);
            if (namedScope != null) {
                searchScope = GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)namedScope);
            }
        }
        return searchScope;
    }

    protected boolean isInScope(PsiElement baseClass, @NotNull PsiElement srcElement, String scopeType) {
        if (HierarchyBrowserBaseEx.SCOPE_CLASS.equals(scopeType)) {
            return PsiTreeUtil.isAncestor((PsiElement)baseClass, (PsiElement)srcElement, (boolean)true);
        }
        if (HierarchyBrowserBaseEx.SCOPE_PROJECT.equals(scopeType)) {
            VirtualFile virtualFile = srcElement.getContainingFile().getVirtualFile();
            return virtualFile == null || !TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)this.myProject);
        }
        if (HierarchyBrowserBaseEx.SCOPE_TEST.equals(scopeType)) {
            VirtualFile virtualFile = srcElement.getContainingFile().getVirtualFile();
            return virtualFile == null || TestSourcesFilter.isTestSources((VirtualFile)virtualFile, (Project)this.myProject);
        }
        if (HierarchyBrowserBaseEx.SCOPE_ALL.equals(scopeType)) {
            return true;
        }
        NamedScope namedScope = NamedScopesHolder.getScope((Project)this.myProject, (String)scopeType);
        if (namedScope == null) {
            return false;
        }
        PackageSet namedScopePattern = namedScope.getValue();
        if (namedScopePattern == null) {
            return false;
        }
        PsiFile psiFile = srcElement.getContainingFile();
        if (psiFile == null) {
            return true;
        }
        NamedScopesHolder holder = NamedScopesHolder.getHolder((Project)this.myProject, (String)scopeType, (NamedScopesHolder)NamedScopeManager.getInstance((Project)this.myProject));
        return namedScopePattern.contains(psiFile, holder);
    }

    @NotNull
    public LeafState getLeafState(@NotNull Object element) {
        if (this.isAlwaysShowPlus()) {
            return LeafState.NEVER;
        }
        LeafState state = super.getLeafState(element);
        return state != LeafState.DEFAULT ? state : LeafState.ASYNC;
    }

    public boolean isAlwaysShowPlus() {
        return false;
    }

    @NotNull
    protected String formatBaseElementText() {
        HierarchyNodeDescriptor descriptor = this.getBaseDescriptor();
        if (descriptor == null) {
            return ((Object)((Object)this)).toString();
        }
        PsiElement element = descriptor.getPsiElement();
        if (element == null) {
            return descriptor.toString();
        }
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE) + " " + ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE);
    }

    private static final class TextInfoNodeDescriptor
    extends NodeDescriptor {
        TextInfoNodeDescriptor(NodeDescriptor parentDescriptor, String text, Project project) {
            super(project, parentDescriptor);
            this.myName = text;
            this.myColor = JBColor.RED;
        }

        public final Object getElement() {
            return this.myName;
        }

        public final boolean update() {
            return true;
        }
    }
}

