/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.LanguageTypeHierarchy;
import com.intellij.ide.hierarchy.ViewClassHierarchyAction;
import com.intellij.ide.hierarchy.ViewSubtypesHierarchyAction;
import com.intellij.ide.hierarchy.ViewSupertypesHierarchyAction;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public abstract class TypeHierarchyBrowserBase
extends HierarchyBrowserBaseEx {
    public static final String TYPE_HIERARCHY_TYPE = IdeBundle.message((String)"title.hierarchy.class", (Object[])new Object[0]);
    public static final String SUBTYPES_HIERARCHY_TYPE = IdeBundle.message((String)"title.hierarchy.subtypes", (Object[])new Object[0]);
    public static final String SUPERTYPES_HIERARCHY_TYPE = IdeBundle.message((String)"title.hierarchy.supertypes", (Object[])new Object[0]);
    private boolean myIsInterface;
    private final MyDeleteProvider myDeleteElementProvider = new MyDeleteProvider();
    public static final DataKey<TypeHierarchyBrowserBase> DATA_KEY = DataKey.create((String)"com.intellij.ide.hierarchy.TypeHierarchyBrowserBase");

    public TypeHierarchyBrowserBase(Project project, PsiElement element) {
        super(project, element);
    }

    protected abstract boolean isInterface(@NotNull PsiElement var1);

    protected void createTreeAndSetupCommonActions(@NotNull Map<String, JTree> trees, @NotNull String typeHierarchyActionGroupName) {
        ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction(typeHierarchyActionGroupName);
        this.createTreeAndSetupCommonActions(trees, group);
    }

    protected void createTreeAndSetupCommonActions(@NotNull Map<String, JTree> trees, @NotNull ActionGroup group) {
        BaseOnThisTypeAction baseOnThisTypeAction = this.createBaseOnThisAction();
        JTree tree1 = this.createTree(true);
        PopupHandler.installPopupHandler((JComponent)tree1, (ActionGroup)group, (String)"TypeHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        baseOnThisTypeAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("TypeHierarchy").getShortcutSet(), tree1);
        trees.put(TYPE_HIERARCHY_TYPE, tree1);
        JTree tree2 = this.createTree(true);
        PopupHandler.installPopupHandler((JComponent)tree2, (ActionGroup)group, (String)"TypeHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        baseOnThisTypeAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("TypeHierarchy").getShortcutSet(), tree2);
        trees.put(SUPERTYPES_HIERARCHY_TYPE, tree2);
        JTree tree3 = this.createTree(true);
        PopupHandler.installPopupHandler((JComponent)tree3, (ActionGroup)group, (String)"TypeHierarchyViewPopup", (ActionManager)ActionManager.getInstance());
        baseOnThisTypeAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("TypeHierarchy").getShortcutSet(), tree3);
        trees.put(SUBTYPES_HIERARCHY_TYPE, tree3);
    }

    @NotNull
    protected BaseOnThisTypeAction createBaseOnThisAction() {
        return new BaseOnThisTypeAction();
    }

    protected abstract boolean canBeDeleted(PsiElement var1);

    protected abstract String getQualifiedName(PsiElement var1);

    public boolean isInterface() {
        return this.myIsInterface;
    }

    @Override
    protected void setHierarchyBase(@NotNull PsiElement element) {
        super.setHierarchyBase(element);
        this.myIsInterface = this.isInterface(element);
    }

    @Override
    protected void prependActions(@NotNull DefaultActionGroup actionGroup) {
        actionGroup.add((AnAction)new ViewClassHierarchyAction());
        actionGroup.add((AnAction)new ViewSupertypesHierarchyAction());
        actionGroup.add((AnAction)new ViewSubtypesHierarchyAction());
        actionGroup.add((AnAction)new HierarchyBrowserBaseEx.AlphaSortAction());
    }

    @Override
    @NotNull
    protected String getBrowserDataKey() {
        return DATA_KEY.getName();
    }

    @Override
    @NotNull
    protected String getActionPlace() {
        return "TypeHierarchyViewToolbar";
    }

    @Override
    public final Object getData(@NotNull String dataId) {
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.myDeleteElementProvider;
        }
        return super.getData(dataId);
    }

    @Override
    @NotNull
    protected String getPrevOccurenceActionNameImpl() {
        return IdeBundle.message((String)"hierarchy.type.prev.occurence.name", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected String getNextOccurenceActionNameImpl() {
        return IdeBundle.message((String)"hierarchy.type.next.occurence.name", (Object[])new Object[0]);
    }

    protected static class BaseOnThisTypeAction
    extends HierarchyBrowserBaseEx.BaseOnThisElementAction {
        public BaseOnThisTypeAction() {
            super(IdeBundle.message((String)"action.base.on.this.class", (Object[])new Object[0]), DATA_KEY.getName(), (LanguageExtension<HierarchyProvider>)LanguageTypeHierarchy.INSTANCE);
        }

        @Override
        protected String correctViewType(@NotNull HierarchyBrowserBaseEx browser2, String viewType) {
            if (((TypeHierarchyBrowserBase)browser2).myIsInterface && TYPE_HIERARCHY_TYPE.equals(viewType)) {
                return SUBTYPES_HIERARCHY_TYPE;
            }
            return viewType;
        }
    }

    private final class MyDeleteProvider
    implements DeleteProvider {
        private MyDeleteProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void deleteElement(@NotNull DataContext dataContext) {
            PsiElement aClass = TypeHierarchyBrowserBase.this.getSelectedElement();
            if (!TypeHierarchyBrowserBase.this.canBeDeleted(aClass)) {
                return;
            }
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting.class", (Object[])new Object[]{TypeHierarchyBrowserBase.this.getQualifiedName(aClass)}));
            try {
                PsiElement[] elements = new PsiElement[]{aClass};
                DeleteHandler.deletePsiElement(elements, TypeHierarchyBrowserBase.this.myProject);
            }
            finally {
                a.finish();
            }
        }

        public final boolean canDeleteElement(@NotNull DataContext dataContext) {
            PsiElement aClass = TypeHierarchyBrowserBase.this.getSelectedElement();
            if (!TypeHierarchyBrowserBase.this.canBeDeleted(aClass)) {
                return false;
            }
            PsiElement[] elements = new PsiElement[]{aClass};
            return DeleteHandler.shouldEnableDeleteAction(elements);
        }
    }
}

