/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.impl;

import com.intellij.codeInsight.highlighting.PairedBraceMatcherAdapter;
import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomFileTypeBraceMatcher
implements PairedBraceMatcher {
    public static final BracePair[] PAIRS = new BracePair[]{new BracePair(CustomHighlighterTokenType.L_BRACKET, CustomHighlighterTokenType.R_BRACKET, true), new BracePair(CustomHighlighterTokenType.L_ANGLE, CustomHighlighterTokenType.R_ANGLE, true), new BracePair(CustomHighlighterTokenType.L_PARENTH, CustomHighlighterTokenType.R_PARENTH, true), new BracePair(CustomHighlighterTokenType.L_BRACE, CustomHighlighterTokenType.R_BRACE, true)};

    @NotNull
    public BracePair[] getPairs() {
        return PAIRS;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        return contextType == CustomHighlighterTokenType.PUNCTUATION || contextType == CustomHighlighterTokenType.WHITESPACE || CustomFileTypeBraceMatcher.isRBraceToken(contextType);
    }

    public int getCodeConstructStart(PsiFile file2, int openingBraceOffset) {
        return openingBraceOffset;
    }

    private static boolean isRBraceToken(IElementType type) {
        for (BracePair pair : PAIRS) {
            if (type != pair.getRightBraceType()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static PairedBraceMatcherAdapter createBraceMatcher() {
        return new PairedBraceMatcherAdapter(new CustomFileTypeBraceMatcher(), CustomHighlighterTokenType.IDENTIFIER.getLanguage()){

            @Override
            public int getBraceTokenGroupId(IElementType tokenType) {
                int id = super.getBraceTokenGroupId(tokenType);
                return id == -1 ? -1 : 777;
            }
        };
    }
}

