/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.KeyedLazyInstanceEP;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataValidator<T> {
    private static boolean ourExtensionsLoaded;
    public static final ExtensionPointName<KeyedLazyInstanceEP<DataValidator>> EP_NAME;
    private static final Logger LOG;
    private static final Map<String, DataValidator<?>> ourValidators;
    private static final DataValidator<VirtualFile> VIRTUAL_FILE_VALIDATOR;
    private static final DataValidator<Project> PROJECT_VALIDATOR;
    private static final DataValidator<Editor> EDITOR_VALIDATOR;

    @Nullable
    public abstract T findInvalid(@NotNull String var1, @NotNull T var2, @NotNull Object var3);

    private static <T> DataValidator<T> getValidator(@NotNull String dataId) {
        if (!ourExtensionsLoaded) {
            ourExtensionsLoaded = true;
            for (KeyedLazyInstanceEP ep : EP_NAME.getExtensionList()) {
                ourValidators.put(ep.key, (DataValidator<?>)ep.getInstance());
            }
        }
        return ourValidators.get(dataId);
    }

    static <T> T findInvalidData(@NotNull String dataId, @NotNull Object data, @NotNull Object dataSource) {
        DataValidator<Object> validator = DataValidator.getValidator(dataId);
        if (validator != null) {
            try {
                return (T)validator.findInvalid(dataId, data, dataSource);
            }
            catch (ClassCastException e) {
                throw new AssertionError("Object of incorrect type returned for key '" + dataId + "' by " + dataSource, e);
            }
        }
        return null;
    }

    static {
        EP_NAME = ExtensionPointName.create((String)"com.intellij.dataValidator");
        LOG = Logger.getInstance((String)"#com.intellij.ide.impl.DataValidator");
        ourValidators = new HashMap();
        VIRTUAL_FILE_VALIDATOR = new DataValidator<VirtualFile>(){

            @Override
            public VirtualFile findInvalid(@NotNull String dataId, @NotNull VirtualFile file2, @NotNull Object dataSource) {
                return file2.isValid() ? null : file2;
            }
        };
        PROJECT_VALIDATOR = new DataValidator<Project>(){

            @Override
            public Project findInvalid(@NotNull String dataId, @NotNull Project project, @NotNull Object dataSource) {
                return project.isDisposed() ? project : null;
            }
        };
        EDITOR_VALIDATOR = new DataValidator<Editor>(){

            @Override
            public Editor findInvalid(@NotNull String dataId, @NotNull Editor editor, @NotNull Object dataSource) {
                return editor.isDisposed() ? editor : null;
            }
        };
        ourValidators.put(CommonDataKeys.VIRTUAL_FILE.getName(), VIRTUAL_FILE_VALIDATOR);
        ourValidators.put(CommonDataKeys.VIRTUAL_FILE_ARRAY.getName(), new ArrayValidator<VirtualFile>(VIRTUAL_FILE_VALIDATOR));
        ourValidators.put(CommonDataKeys.PROJECT.getName(), PROJECT_VALIDATOR);
        ourValidators.put(CommonDataKeys.EDITOR.getName(), EDITOR_VALIDATOR);
        ourValidators.put(AnActionEvent.injectedId((String)CommonDataKeys.EDITOR.getName()), EDITOR_VALIDATOR);
        ourValidators.put(CommonDataKeys.HOST_EDITOR.getName(), EDITOR_VALIDATOR);
    }

    static class ArrayValidator<T>
    extends DataValidator<T[]> {
        private final DataValidator<T> myElementValidator;

        ArrayValidator(@NotNull DataValidator<T> elementValidator) {
            this.myElementValidator = elementValidator;
        }

        @Override
        public T[] findInvalid(@NotNull String dataId, @NotNull T[] array, @NotNull Object dataSource) {
            for (T element : array) {
                if (element == null) {
                    LOG.error("Data isn't valid. " + dataId + "=null Provided by: " + dataSource.getClass().getName() + " (" + dataSource.toString() + ")");
                    return null;
                }
                T invalid = this.myElementValidator.findInvalid(dataId, element, dataSource);
                if (invalid == null) continue;
                Class<?> type = array.getClass().getComponentType();
                return ArrayUtil.toObjectArray(type, (Object[])new Object[]{invalid});
            }
            return null;
        }
    }
}

