/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.ProjectNewWindowDoNotAskOption;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.ui.AppIcon;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import java.awt.Component;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JFrame;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.annotations.SystemIndependent;

public class ProjectUtil {
    private static final Logger LOG = Logger.getInstance(ProjectUtil.class);
    public static final String MODE_PROPERTY = "OpenOrAttachDialog.OpenMode";
    public static final String MODE_ATTACH = "attach";
    public static final String MODE_REPLACE = "replace";
    public static final String MODE_NEW = "new";

    private ProjectUtil() {
    }

    public static void updateLastProjectLocation(String projectFilePath) {
        File lastProjectLocation = new File(projectFilePath);
        if (lastProjectLocation.isFile()) {
            lastProjectLocation = lastProjectLocation.getParentFile();
        }
        if (lastProjectLocation == null) {
            return;
        }
        if ((lastProjectLocation = lastProjectLocation.getParentFile()) == null) {
            return;
        }
        String path = lastProjectLocation.getPath();
        try {
            path = FileUtil.resolveShortWindowsName((String)path);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return;
        }
        RecentProjectsManager.getInstance().setLastProjectCreationLocation(PathUtil.toSystemIndependentName((String)path));
    }

    public static boolean closeAndDispose(@NotNull Project project) {
        return ProjectManagerEx.getInstanceEx().closeAndDispose(project);
    }

    @Nullable
    public static Project openOrImport(@NotNull @SystemIndependent String path, Project projectToClose, boolean forceOpenInNewFrame) {
        ProjectOpenProcessor provider;
        Project existing = ProjectUtil.findAndFocusExistingProjectForPath(path);
        if (existing != null) {
            return existing;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        if (virtualFile == null) {
            return null;
        }
        virtualFile.refresh(false, false);
        ProjectOpenProcessor strong = ProjectOpenProcessor.getStrongImportProvider((VirtualFile)virtualFile);
        if (strong != null) {
            return strong.doOpenProject(virtualFile, projectToClose, forceOpenInNewFrame);
        }
        if (ProjectKt.isValidProjectPath(path)) {
            return ProjectUtil.openProject(path, projectToClose, forceOpenInNewFrame);
        }
        if (virtualFile.isDirectory()) {
            for (VirtualFile child2 : virtualFile.getChildren()) {
                String childPath = child2.getPath();
                if (!childPath.endsWith(".ipr")) continue;
                return ProjectUtil.openProject(childPath, projectToClose, forceOpenInNewFrame);
            }
        }
        if ((provider = ProjectOpenProcessor.getImportProvider((VirtualFile)virtualFile)) != null) {
            Project project = provider.doOpenProject(virtualFile, projectToClose, forceOpenInNewFrame);
            if (project != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    ToolWindow toolWindow;
                    if (!project.isDisposed() && (toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.PROJECT_VIEW)) != null) {
                        toolWindow.activate(null);
                    }
                }, ModalityState.NON_MODAL);
            }
            return project;
        }
        return null;
    }

    @Nullable
    public static Project openProject(@NotNull String path, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        File dir;
        File file2 = new File(path);
        if (!file2.exists()) {
            Messages.showErrorDialog((String)IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{path}), (String)CommonBundle.getErrorTitle());
            return null;
        }
        if (file2.isDirectory() && !(dir = new File(file2, ".idea")).exists()) {
            String message = IdeBundle.message((String)"error.project.file.does.not.exist", (Object[])new Object[]{dir.getPath()});
            Messages.showErrorDialog((String)message, (String)CommonBundle.getErrorTitle());
            return null;
        }
        Project existing = ProjectUtil.findAndFocusExistingProjectForPath(path);
        if (existing != null) {
            return existing;
        }
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (!forceOpenInNewFrame && openProjects.length > 0) {
            int exitCode = ProjectUtil.confirmOpenNewProject(false);
            if (exitCode == 1) {
                Project toClose;
                Project project = toClose = projectToClose != null ? projectToClose : openProjects[openProjects.length - 1];
                if (!ProjectUtil.closeAndDispose(toClose)) {
                    return null;
                }
            } else if (exitCode != 0) {
                return null;
            }
        }
        if (ProjectUtil.isRemotePath(path) && !RecentProjectsManager.getInstance().hasPath(PathUtil.toSystemIndependentName((String)path)) && !ProjectUtil.confirmLoadingFromRemotePath(path, "warning.load.project.from.share", "title.load.project.from.share")) {
            return null;
        }
        ProjectManagerEx projectManager = ProjectManagerEx.getInstanceEx();
        Project project = null;
        try {
            project = projectManager.loadAndOpenProject(path);
        }
        catch (IOException e) {
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.cannot.load.project", (Object[])new Object[]{e.getMessage()}), (String)IdeBundle.message((String)"title.cannot.load.project", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        catch (InvalidDataException | JDOMException e) {
            LOG.info(e);
            Messages.showMessageDialog((String)IdeBundle.message((String)"error.project.file.is.corrupted", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.cannot.load.project", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        return project;
    }

    public static boolean confirmLoadingFromRemotePath(@NotNull String path, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String msgKey, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String titleKey) {
        return ProjectUtil.showYesNoDialog(IdeBundle.message((String)msgKey, (Object[])new Object[]{path}), titleKey);
    }

    public static boolean showYesNoDialog(@NotNull String message, @NotNull @PropertyKey(resourceBundle="messages.IdeBundle") String titleKey) {
        Window window = ProjectUtil.getActiveFrameOrWelcomeScreen();
        Icon icon = Messages.getWarningIcon();
        String title = IdeBundle.message((String)titleKey, (Object[])new Object[0]);
        int answer = window == null ? Messages.showYesNoDialog((String)message, (String)title, (Icon)icon) : Messages.showYesNoDialog((Component)window, (String)message, (String)title, (Icon)icon);
        return answer == 0;
    }

    public static Window getActiveFrameOrWelcomeScreen() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window != null) {
            return window;
        }
        for (Frame frame : Frame.getFrames()) {
            if (!(frame instanceof IdeFrame) || !frame.isVisible()) continue;
            return frame;
        }
        return null;
    }

    public static boolean isRemotePath(@NotNull String path) {
        return path.contains("://") || path.contains("\\\\");
    }

    @Nullable
    public static Project findAndFocusExistingProjectForPath(@NotNull String path) {
        Project[] openProjects;
        for (Project project : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            if (project.isDefault() || !ProjectUtil.isSameProject(path, project)) continue;
            ProjectUtil.focusProjectWindow(project, false);
            return project;
        }
        return null;
    }

    public static int confirmOpenNewProject(boolean isNewProject) {
        int confirmOpenNewProject;
        GeneralSettings settings = GeneralSettings.getInstance();
        int n = confirmOpenNewProject = ApplicationManager.getApplication().isUnitTestMode() ? 0 : settings.getConfirmOpenNewProject();
        if (confirmOpenNewProject == -1) {
            if (isNewProject) {
                int exitCode = Messages.showYesNoDialog((String)IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.existing.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.new.frame", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new ProjectNewWindowDoNotAskOption());
                return exitCode == 0 ? 1 : 0;
            }
            int exitCode = Messages.showYesNoCancelDialog((String)IdeBundle.message((String)"prompt.open.project.in.new.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.open.project", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.existing.frame", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.new.frame", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new ProjectNewWindowDoNotAskOption());
            return exitCode == 0 ? 1 : (exitCode == 1 ? 0 : 2);
        }
        return confirmOpenNewProject;
    }

    public static int confirmOpenOrAttachProject() {
        String mode = PropertiesComponent.getInstance().getValue(MODE_PROPERTY);
        int exitCode = Messages.showDialog((String)IdeBundle.message((String)"prompt.open.project.or.attach", (Object[])new Object[0]), (String)"Open Project", (String[])new String[]{"&This Window", "New &Window", "&Attach", CommonBundle.getCancelButtonText()}, (int)(MODE_NEW.equals(mode) ? 1 : (MODE_REPLACE.equals(mode) ? 0 : (MODE_ATTACH.equals(mode) ? 2 : 0))), (Icon)Messages.getQuestionIcon());
        return exitCode == 0 ? 1 : (exitCode == 1 ? 0 : (exitCode == 2 ? 2 : -1));
    }

    public static boolean isSameProject(@Nullable String projectFilePath, @NotNull Project project) {
        if (projectFilePath == null) {
            return false;
        }
        IProjectStore projectStore = ProjectKt.getStateStore(project);
        String existingBaseDirPath = projectStore.getProjectBasePath();
        File projectFile = new File(projectFilePath);
        if (projectFile.isDirectory()) {
            return FileUtil.pathsEqual((String)projectFilePath, (String)existingBaseDirPath);
        }
        if (projectStore.getStorageScheme() == StorageScheme.DEFAULT) {
            return FileUtil.pathsEqual((String)projectFilePath, (String)projectStore.getProjectFilePath());
        }
        File parent = projectFile.getParentFile();
        if (parent.getName().equals(".idea")) {
            return (parent = parent.getParentFile()) != null && FileUtil.pathsEqual((String)parent.getPath(), (String)existingBaseDirPath);
        }
        return FileUtil.pathsEqual((String)parent.getPath(), (String)existingBaseDirPath) && "ipr".equals(FileUtilRt.getExtension((String)projectFile.getName()));
    }

    public static void focusProjectWindow(Project p, boolean executeIfAppInactive) {
        JFrame f = WindowManager.getInstance().getFrame(p);
        if (f != null) {
            if (executeIfAppInactive) {
                AppIcon.getInstance().requestFocus((IdeFrame)WindowManager.getInstance().getFrame(p));
                f.toFront();
            } else {
                IdeFocusManager.getInstance((Project)p).requestFocus((Component)f, true);
            }
        }
    }

    public static String getBaseDir() {
        String defaultDirectory = GeneralSettings.getInstance().getDefaultProjectDirectory();
        if (StringUtil.isNotEmpty((String)defaultDirectory)) {
            return defaultDirectory.replace('/', File.separatorChar);
        }
        String lastProjectLocation = RecentProjectsManager.getInstance().getLastProjectCreationLocation();
        if (lastProjectLocation != null) {
            return lastProjectLocation.replace('/', File.separatorChar);
        }
        String userHome = SystemProperties.getUserHome();
        String productName = ApplicationNamesInfo.getInstance().getLowercaseProductName();
        if (PlatformUtils.isCLion()) {
            productName = ApplicationNamesInfo.getInstance().getProductName();
        }
        return userHome.replace('/', File.separatorChar) + File.separator + productName + "Projects";
    }
}

