/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.CompositeSelectInTarget;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.IdeUICustomization;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class ProjectViewSelectInGroupTarget
implements CompositeSelectInTarget,
DumbAware {
    @NotNull
    public Collection<SelectInTarget> getSubTargets(@NotNull SelectInContext context) {
        return ProjectView.getInstance(context.getProject()).getSelectInTargets();
    }

    public boolean canSelect(SelectInContext context) {
        ProjectView projectView = ProjectView.getInstance(context.getProject());
        Collection<SelectInTarget> targets2 = projectView.getSelectInTargets();
        for (SelectInTarget projectViewTarget : targets2) {
            if (!projectViewTarget.canSelect(context)) continue;
            return true;
        }
        return false;
    }

    public void selectIn(SelectInContext context, boolean requestFocus) {
        SelectInTarget target2;
        ProjectView projectView = ProjectView.getInstance(context.getProject());
        Collection<SelectInTarget> targets2 = projectView.getSelectInTargets();
        LinkedHashSet<SelectInTarget> targetsToCheck = new LinkedHashSet<SelectInTarget>();
        String currentId = projectView.getCurrentViewId();
        for (SelectInTarget projectViewTarget : targets2) {
            if (!Comparing.equal((String)currentId, (String)projectViewTarget.getMinorViewId())) continue;
            targetsToCheck.add(projectViewTarget);
            break;
        }
        targetsToCheck.addAll(targets2);
        Iterator<Object> iterator = targetsToCheck.iterator();
        while (iterator.hasNext() && !context.selectIn(target2 = (SelectInTarget)iterator.next(), requestFocus)) {
        }
    }

    public String getToolWindowId() {
        return ToolWindowId.PROJECT_VIEW;
    }

    public String getMinorViewId() {
        return null;
    }

    public String toString() {
        return IdeUICustomization.getInstance().getProjectViewSelectInTitle();
    }
}

