/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectInTargetPsiWrapper
implements SelectInTarget {
    protected final Project myProject;

    protected SelectInTargetPsiWrapper(@NotNull Project project) {
        this.myProject = project;
    }

    public abstract String toString();

    protected abstract boolean canSelect(PsiFileSystemItem var1);

    public final boolean canSelect(@NotNull SelectInContext context) {
        if (!this.isContextValid(context)) {
            return false;
        }
        return this.canSelectInner(context);
    }

    protected boolean canSelectInner(@NotNull SelectInContext context) {
        PsiFileSystemItem psiFile = this.getContextPsiFile(context);
        return psiFile != null && this.canSelect(psiFile);
    }

    private boolean isContextValid(SelectInContext context) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        VirtualFile virtualFile = context.getVirtualFile();
        return virtualFile.isValid();
    }

    @Nullable
    protected PsiFileSystemItem getContextPsiFile(@NotNull SelectInContext context) {
        VirtualFile virtualFile = context.getVirtualFile();
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
        if (psiFile != null) {
            return psiFile;
        }
        if (context.getSelectorInFile() instanceof PsiFile) {
            return (PsiFile)context.getSelectorInFile();
        }
        if (virtualFile.isDirectory()) {
            return PsiManager.getInstance((Project)this.myProject).findDirectory(virtualFile);
        }
        return null;
    }

    public final void selectIn(@NotNull SelectInContext context, boolean requestFocus) {
        VirtualFile file2 = context.getVirtualFile();
        Object selector = context.getSelectorInFile();
        if (selector == null) {
            selector = PsiUtilCore.findFileSystemItem((Project)this.myProject, (VirtualFile)file2);
        }
        if (selector instanceof PsiElement) {
            PsiUtilCore.ensureValid((PsiElement)((PsiElement)selector));
            PsiElement original = ((PsiElement)selector).getOriginalElement();
            if (original != null && !original.isValid()) {
                throw new PsiInvalidElementAccessException(original, "Returned by " + selector + " of " + selector.getClass());
            }
            this.select(original, requestFocus);
        } else {
            this.select(selector, file2, requestFocus);
        }
    }

    protected abstract void select(Object var1, VirtualFile var2, boolean var3);

    @Deprecated
    protected boolean canWorkWithCustomObjects() {
        return false;
    }

    protected abstract void select(PsiElement var1, boolean var2);

    @Nullable
    protected static PsiElement findElementToSelect(PsiElement element, PsiElement candidate) {
        PsiElement toSelect2 = candidate;
        if (toSelect2 == null) {
            if (element instanceof PsiFile || element instanceof PsiDirectory) {
                toSelect2 = element;
            } else {
                PsiFile containingFile = element.getContainingFile();
                if (containingFile != null) {
                    FileViewProvider viewProvider = containingFile.getViewProvider();
                    toSelect2 = viewProvider.getPsi(viewProvider.getBaseLanguage());
                }
            }
        }
        if (toSelect2 != null) {
            PsiElement originalElement = null;
            try {
                originalElement = toSelect2.getOriginalElement();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (originalElement != null) {
                toSelect2 = originalElement;
            }
        }
        return toSelect2;
    }
}

