/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroFilter;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MacrosDialog
extends DialogWrapper {
    private final DefaultListModel<MacroWrapper> myMacrosModel = new DefaultListModel();
    private final JBList<MacroWrapper> myMacrosList = new JBList(this.myMacrosModel);
    private final JTextArea myPreviewTextarea = new JTextArea();

    public MacrosDialog(Project project) {
        super(project, true);
        MacroManager.getInstance().cacheMacrosPreview(SimpleDataContext.getProjectContext(project));
        this.init();
    }

    public MacrosDialog(Component parent) {
        super(parent, true);
        MacroManager.getInstance().cacheMacrosPreview(DataManager.getInstance().getDataContext(parent));
        this.init();
    }

    public static void show(@NotNull JTextComponent textComponent, @Nullable Condition<? super Macro> filter) {
        MacrosDialog dialog2 = new MacrosDialog(textComponent);
        if (filter != null) {
            for (int i = 0; i < dialog2.myMacrosModel.size(); ++i) {
                if (filter.value((Object)dialog2.myMacrosModel.get(i).myMacro)) continue;
                dialog2.myMacrosModel.remove(i);
                --i;
            }
            if (dialog2.myMacrosModel.size() > 0) {
                dialog2.myMacrosList.setSelectedIndex(0);
            } else {
                dialog2.setOKActionEnabled(false);
            }
        }
        if (dialog2.showAndGet() && dialog2.getSelectedMacro() != null) {
            String macro = dialog2.getSelectedMacro().getName();
            int position = textComponent.getCaretPosition();
            int selectionStart = textComponent.getSelectionStart();
            int selectionEnd = textComponent.getSelectionEnd();
            try {
                if (selectionStart < selectionEnd) {
                    textComponent.getDocument().remove(selectionStart, selectionEnd - selectionStart);
                    position = selectionStart;
                }
                textComponent.getDocument().insertString(position, "$" + macro + "$", null);
                textComponent.setCaretPosition(position + macro.length() + 2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        IdeFocusManager.findInstance().requestFocus((Component)textComponent, true);
    }

    protected void init() {
        super.init();
        this.setTitle(IdeBundle.message((String)"title.macros", (Object[])new Object[0]));
        this.setOKButtonText(IdeBundle.message((String)"button.insert", (Object[])new Object[0]));
        List<Macro> macros = new ArrayList<Macro>(MacroManager.getInstance().getMacros());
        macros = ContainerUtil.filter(macros, macro -> MacroFilter.GLOBAL.accept((Macro)macro));
        Collections.sort(macros, new Comparator<Macro>(){
            private final String ZERO = new String(new char[]{'\u0000'});

            @Override
            public int compare(Macro macro1, Macro macro2) {
                String name1 = macro1.getName();
                String name2 = macro2.getName();
                if (!StringUtil.startsWithChar((CharSequence)name1, (char)'/')) {
                    name1 = this.ZERO + name1;
                }
                if (!StringUtil.startsWithChar((CharSequence)name2, (char)'/')) {
                    name2 = this.ZERO + name2;
                }
                return name1.compareToIgnoreCase(name2);
            }
        });
        for (Macro macro2 : macros) {
            this.myMacrosModel.addElement(new MacroWrapper(macro2));
        }
        this.addListeners();
        if (this.myMacrosModel.size() > 0) {
            this.myMacrosList.setSelectedIndex(0);
        } else {
            this.setOKActionEnabled(false);
        }
    }

    protected String getHelpId() {
        return "reference.settings.ide.settings.external.tools.macros";
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.macro.MacrosDialog";
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridy = 0;
        constr.anchor = 17;
        constr.fill = 2;
        panel2.add((Component)SeparatorFactory.createSeparator((String)IdeBundle.message((String)"label.macros", (Object[])new Object[0]), null), constr);
        constr = new GridBagConstraints();
        constr.gridy = 1;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.fill = 1;
        constr.anchor = 17;
        panel2.add((Component)ScrollPaneFactory.createScrollPane(this.myMacrosList), constr);
        this.myMacrosList.setSelectionMode(0);
        this.myMacrosList.setPreferredSize(null);
        constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 2;
        constr.anchor = 17;
        constr.fill = 2;
        panel2.add((Component)SeparatorFactory.createSeparator((String)IdeBundle.message((String)"label.macro.preview", (Object[])new Object[0]), null), constr);
        constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 3;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.fill = 1;
        constr.anchor = 17;
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myPreviewTextarea), constr);
        this.myPreviewTextarea.setEditable(false);
        this.myPreviewTextarea.setLineWrap(true);
        this.myPreviewTextarea.setPreferredSize(null);
        panel2.setPreferredSize((Dimension)JBUI.size((int)400, (int)500));
        return panel2;
    }

    private void addListeners() {
        this.myMacrosList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Macro macro = MacrosDialog.this.getSelectedMacro();
                if (macro == null) {
                    MacrosDialog.this.myPreviewTextarea.setText("");
                    MacrosDialog.this.setOKActionEnabled(false);
                } else {
                    MacrosDialog.this.myPreviewTextarea.setText(macro.preview());
                    MacrosDialog.this.setOKActionEnabled(true);
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (MacrosDialog.this.getSelectedMacro() != null) {
                    MacrosDialog.this.close(0);
                    return true;
                }
                return false;
            }
        }.installOn(this.myMacrosList);
    }

    public Macro getSelectedMacro() {
        MacroWrapper macroWrapper = (MacroWrapper)this.myMacrosList.getSelectedValue();
        if (macroWrapper != null) {
            return macroWrapper.myMacro;
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myMacrosList;
    }

    private static final class MacroWrapper {
        private final Macro myMacro;

        MacroWrapper(Macro macro) {
            this.myMacro = macro;
        }

        public String toString() {
            return this.myMacro.getName() + " - " + this.myMacro.getDescription();
        }
    }
}

