/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.IdeView;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.NavBarPopup;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class NavBarIdeView
implements IdeView {
    private final NavBarPanel myPanel;

    public NavBarIdeView(NavBarPanel panel2) {
        this.myPanel = panel2;
    }

    public void selectElement(PsiElement element) {
        Navigatable navigatable;
        this.myPanel.getModel().updateModel(element);
        if (element instanceof Navigatable && (navigatable = (Navigatable)element).canNavigate()) {
            ((Navigatable)element).navigate(true);
        }
        this.myPanel.hideHint();
    }

    @NotNull
    public PsiDirectory[] getDirectories() {
        NavBarPopup nodePopup = this.myPanel.getNodePopup();
        JBIterable selection = nodePopup != null && nodePopup.isVisible() ? JBIterable.from((Iterable)nodePopup.getList().getSelectedValuesList()) : this.myPanel.getSelection();
        List dirs = selection.flatMap(o -> {
            if (o instanceof PsiElement && !((PsiElement)o).isValid()) {
                return JBIterable.empty();
            }
            if (o instanceof PsiDirectory) {
                return JBIterable.of((Object)((PsiDirectory)o));
            }
            if (o instanceof PsiDirectoryContainer) {
                return JBIterable.of((Object[])((PsiDirectoryContainer)o).getDirectories());
            }
            if (o instanceof PsiElement) {
                PsiFile file3 = ((PsiElement)o).getContainingFile();
                return JBIterable.of((Object)(file3 != null ? file3.getContainingDirectory() : null));
            }
            if (o instanceof Module && !((Module)o).isDisposed()) {
                PsiManager psiManager = PsiManager.getInstance((Project)this.myPanel.getProject());
                return JBIterable.of((Object[])ModuleRootManager.getInstance((Module)((Module)o)).getSourceRoots()).filterMap(file2 -> psiManager.findDirectory(file2));
            }
            return JBIterable.empty();
        }).filter(o -> o.isValid()).toList();
        return dirs.isEmpty() ? PsiDirectory.EMPTY_ARRAY : dirs.toArray(PsiDirectory.EMPTY_ARRAY);
    }

    public PsiDirectory getOrChooseDirectory() {
        return DirectoryChooserUtil.getOrChooseDirectory(this);
    }
}

