/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ide.navigationToolbar.NavBarListWrapper;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.SelectInNavBarTarget;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class ShowNavBarAction
extends AnAction
implements DumbAware,
PopupAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext context = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project != null) {
            UISettings uiSettings = UISettings.getInstance();
            if (uiSettings.getShowNavigationBar() && !uiSettings.getPresentationMode()) {
                new SelectInNavBarTarget(project).select(null, false);
            } else {
                Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
                if (!ShowNavBarAction.isInsideNavBar(component)) {
                    Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
                    NavBarPanel toolbarPanel = new NavBarPanel(project, false);
                    toolbarPanel.showHint(editor, context);
                }
            }
        }
    }

    private static boolean isInsideNavBar(Component c) {
        return c == null || c instanceof NavBarPanel || UIUtil.getParentOfType(NavBarListWrapper.class, (Component)c) != null;
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled = e.getData(CommonDataKeys.PROJECT) != null;
        e.getPresentation().setEnabled(enabled);
        if (!ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace())) {
            e.getPresentation().setText(ActionsBundle.message((String)"action.ShowNavBar.ShortText", (Object[])new Object[0]));
        }
    }
}

