/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.ui.NavBarUI;
import com.intellij.ide.ui.UISettings;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNavBarUI
implements NavBarUI {
    private static final Map<NavBarItem, Map<ImageType, BufferedImage>> myCache = new THashMap();

    @Override
    public Insets getElementIpad(boolean isPopupElement) {
        return isPopupElement ? JBUI.insets((int)1, (int)2) : JBUI.emptyInsets();
    }

    public JBInsets getElementPadding() {
        return JBUI.insets((int)3);
    }

    @Override
    public Font getElementFont(NavBarItem navBarItem) {
        Font font = UIUtil.getLabelFont();
        return UISettings.getInstance().getUseSmallLabelsOnTabs() ? RelativeFont.SMALL.derive(font) : font;
    }

    @Override
    public Color getBackground(boolean selected, boolean focused) {
        return selected && focused ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground();
    }

    @Override
    @Nullable
    public Color getForeground(boolean selected, boolean focused, boolean inactive) {
        return selected && focused ? UIUtil.getListSelectionForeground() : (inactive ? UIUtil.getInactiveTextColor() : null);
    }

    @Override
    public short getSelectionAlpha() {
        return 150;
    }

    @Override
    public void doPaintNavBarItem(Graphics2D g, NavBarItem item, NavBarPanel navbar) {
        boolean nextSelected;
        boolean floating = navbar.isInFloatingMode();
        boolean toolbarVisible = UISettings.getInstance().getShowMainToolbar();
        boolean selected = item.isSelected() && item.isFocused();
        boolean bl = nextSelected = item.isNextSelected() && navbar.isFocused();
        ImageType type = floating ? (selected ? ImageType.ACTIVE_FLOATING : (nextSelected ? ImageType.NEXT_ACTIVE_FLOATING : ImageType.INACTIVE_FLOATING)) : (toolbarVisible ? (selected ? ImageType.ACTIVE : (nextSelected ? ImageType.NEXT_ACTIVE : ImageType.INACTIVE)) : (selected ? ImageType.ACTIVE_NO_TOOLBAR : (nextSelected ? ImageType.NEXT_ACTIVE_NO_TOOLBAR : ImageType.INACTIVE_NO_TOOLBAR)));
        Map cached = myCache.computeIfAbsent(item, k -> new HashMap());
        BufferedImage image = cached.computeIfAbsent(type, k -> AbstractNavBarUI.drawToBuffer(item, floating, toolbarVisible, selected, navbar));
        UIUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, null);
        Icon icon = item.getIcon();
        int offset = item.isFirstElement() ? AbstractNavBarUI.getFirstElementLeftOffset() : 0;
        int iconOffset = this.getElementPadding().left + offset;
        icon.paintIcon((Component)((Object)item), g, iconOffset, (item.getHeight() - icon.getIconHeight()) / 2);
        int textOffset = icon.getIconWidth() + this.getElementPadding().width() + offset;
        item.doPaintText(g, textOffset);
    }

    private static BufferedImage drawToBuffer(NavBarItem item, boolean floating, boolean toolbarVisible, boolean selected, NavBarPanel navbar) {
        int w = item.getWidth();
        int h = item.getHeight();
        int offset = w - AbstractNavBarUI.getDecorationOffset();
        int h2 = h / 2;
        BufferedImage result2 = UIUtil.createImage((int)w, (int)h, (int)2);
        Gray defaultBg = UIUtil.isUnderDarcula() ? Gray._100 : JBColor.WHITE;
        Gray bg = floating ? defaultBg : null;
        Color selection = UIUtil.getListSelectionBackground();
        Graphics2D g2 = result2.createGraphics();
        g2.setStroke(new BasicStroke(1.0f, 0, 1));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Path2D.Double shape = new Path2D.Double();
        shape.moveTo(0.0, 0.0);
        shape.lineTo(offset, 0.0);
        shape.lineTo(w, h2);
        shape.lineTo(offset, h);
        shape.lineTo(0.0, h);
        shape.closePath();
        Path2D.Double endShape = new Path2D.Double();
        endShape.moveTo(offset, 0.0);
        endShape.lineTo(w, 0.0);
        endShape.lineTo(w, h);
        endShape.lineTo(offset, h);
        endShape.lineTo(w, h2);
        endShape.closePath();
        if (bg != null && toolbarVisible) {
            g2.setPaint((Paint)bg);
            g2.fill(shape);
            g2.fill(endShape);
        }
        if (selected) {
            Path2D.Double focusShape = new Path2D.Double();
            if (toolbarVisible || floating) {
                focusShape.moveTo(offset, 0.0);
            } else {
                focusShape.moveTo(0.0, 0.0);
                focusShape.lineTo(offset, 0.0);
            }
            focusShape.lineTo(w - 1, h2);
            focusShape.lineTo(offset, h - 1);
            if (!toolbarVisible && !floating) {
                focusShape.lineTo(0.0, h - 1);
            }
            g2.setColor(selection);
            if (floating && item.isLastElement()) {
                g2.fillRect(0, 0, w, h);
            } else {
                g2.fill(shape);
            }
        }
        if (item.isNextSelected() && navbar.isFocused()) {
            g2.setColor(selection);
            g2.fill(endShape);
        }
        if (!item.isLastElement() && !selected && !navbar.isFocused() | !item.isNextSelected()) {
            Icon icon = AllIcons.Ide.NavBarSeparator;
            icon.paintIcon((Component)((Object)item), g2, w - icon.getIconWidth() - JBUI.scale((int)1), h2 - icon.getIconHeight() / 2);
        }
        g2.dispose();
        return result2;
    }

    private static int getDecorationOffset() {
        return JBUI.scale((int)8);
    }

    private static int getFirstElementLeftOffset() {
        return JBUI.scale((int)6);
    }

    @Override
    public Dimension getOffsets(NavBarItem item) {
        Dimension size = new Dimension();
        if (!item.isPopupElement()) {
            size.width = size.width + (AbstractNavBarUI.getDecorationOffset() + this.getElementPadding().width() + (item.isFirstElement() ? AbstractNavBarUI.getFirstElementLeftOffset() : 0));
            size.height += this.getElementPadding().height();
        }
        return size;
    }

    @Override
    public Insets getWrapperPanelInsets(Insets insets) {
        JBInsets result2 = JBUI.insets((Insets)insets);
        if (AbstractNavBarUI.shouldPaintWrapperPanel()) {
            result2.top += JBUI.scale((int)1);
        }
        return result2;
    }

    private static boolean shouldPaintWrapperPanel() {
        return false;
    }

    protected Color getBackgroundColor() {
        return ColorUtil.darker((Color)UIUtil.getPanelBackground(), (int)1);
    }

    @Override
    public void doPaintNavBarPanel(Graphics2D g, Rectangle r, boolean mainToolbarVisible, boolean undocked) {
    }

    @Override
    public void clearItems() {
        myCache.clear();
    }

    @Override
    public int getPopupOffset(@NotNull NavBarItem item) {
        return item.isFirstElement() ? 0 : JBUI.scale((int)5);
    }

    private static enum ImageType {
        INACTIVE,
        NEXT_ACTIVE,
        ACTIVE,
        INACTIVE_FLOATING,
        NEXT_ACTIVE_FLOATING,
        ACTIVE_FLOATING,
        INACTIVE_NO_TOOLBAR,
        NEXT_ACTIVE_NO_TOOLBAR,
        ACTIVE_NO_TOOLBAR;

    }
}

