/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.HelpSetPath;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.OptimizedPluginBean;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginHelpSet;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.ProductDescriptor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.OldComponentConfig;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaPluginDescriptorImpl
implements IdeaPluginDescriptor {
    public static final IdeaPluginDescriptorImpl[] EMPTY_ARRAY = new IdeaPluginDescriptorImpl[0];
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.plugins.PluginDescriptor");
    private final File myPath;
    private final boolean myBundled;
    private final NullableLazyValue<String> myDescription = new NullableLazyValue<String>(){

        protected String compute() {
            return IdeaPluginDescriptorImpl.this.computeDescription();
        }
    };
    private String myName;
    private PluginId myId;
    @Nullable
    private String myProductCode;
    @Nullable
    private Date myReleaseDate;
    private int myReleaseVersion;
    private String myResourceBundleBaseName;
    private String myChangeNotes;
    private String myVersion;
    private String myVendor;
    private String myVendorEmail;
    private String myVendorUrl;
    private String myVendorLogoPath;
    private String myCategory;
    private String myUrl;
    private PluginId[] myDependencies = PluginId.EMPTY_ARRAY;
    private PluginId[] myOptionalDependencies = PluginId.EMPTY_ARRAY;
    private Map<PluginId, List<String>> myOptionalConfigs;
    private Map<PluginId, List<IdeaPluginDescriptorImpl>> myOptionalDescriptors;
    @Nullable
    private List<Element> myActionElements;
    private List<ComponentConfig> myAppComponents;
    private List<ComponentConfig> myProjectComponents;
    private List<ComponentConfig> myModuleComponents;
    private boolean myDeleted;
    private ClassLoader myLoader;
    private HelpSetPath[] myHelpSets;
    @Nullable
    private MultiMap<String, Element> myExtensions;
    @Nullable
    private MultiMap<String, Element> myExtensionsPoints;
    private String myDescriptionChildText;
    private boolean myUseIdeaClassLoader;
    private boolean myUseCoreClassLoader;
    private boolean myAllowBundledUpdate;
    private boolean myEnabled = true;
    private String mySinceBuild;
    private String myUntilBuild;
    private Boolean mySkipped;
    private List<String> myModules;
    public static final Pattern EXPLICIT_BIG_NUMBER_PATTERN = Pattern.compile("(.*)\\.(9{4,}+|10{4,}+)");

    public IdeaPluginDescriptorImpl(@NotNull File pluginPath, boolean bundled) {
        this.myPath = pluginPath;
        this.myBundled = bundled;
    }

    private static String createDescriptionKey(PluginId id) {
        return "plugin." + id + ".description";
    }

    public File getPath() {
        return this.myPath;
    }

    @Deprecated
    public void setPath(File path) {
    }

    public void readExternal(@NotNull Element element, @NotNull URL url, @NotNull JDOMXIncluder.PathResolver pathResolver) throws InvalidDataException, MalformedURLException {
        Application application = ApplicationManager.getApplication();
        this.readExternal(element, url, application != null && application.isUnitTestMode(), pathResolver);
    }

    private void readExternal(@NotNull Element element, @NotNull URL url, boolean ignoreMissingInclude, @NotNull JDOMXIncluder.PathResolver pathResolver) throws InvalidDataException, MalformedURLException {
        this.myAppComponents = Collections.emptyList();
        this.myProjectComponents = Collections.emptyList();
        this.myModuleComponents = Collections.emptyList();
        if (JDOMUtil.isEmpty((Element)element)) {
            return;
        }
        JDOMXIncluder.resolveNonXIncludeElement((Element)element, (URL)url, (boolean)ignoreMissingInclude, (JDOMXIncluder.PathResolver)pathResolver);
        this.readExternal(element);
    }

    public void loadFromFile(@NotNull File file2, @Nullable SafeJdomFactory factory) throws IOException, JDOMException {
        this.readExternal(JDOMUtil.load((File)file2, (SafeJdomFactory)factory), file2.toURI().toURL(), JDOMXIncluder.DEFAULT_PATH_RESOLVER);
    }

    protected void readExternal(@NotNull Element element) {
        OptimizedPluginBean pluginBean = (OptimizedPluginBean)XmlSerializer.deserialize((Element)element, OptimizedPluginBean.class);
        this.myUrl = pluginBean.url;
        String idString = StringUtil.nullize((String)pluginBean.id, (boolean)true);
        String nameString = StringUtil.nullize((String)pluginBean.name, (boolean)true);
        this.myId = idString != null ? PluginId.getId((String)idString) : (nameString != null ? PluginId.getId((String)nameString) : null);
        this.myName = (String)ObjectUtils.chooseNotNull((Object)nameString, (Object)idString);
        ProductDescriptor pd = pluginBean.productDescriptor;
        this.myProductCode = pd != null ? pd.code : null;
        this.myReleaseDate = IdeaPluginDescriptorImpl.parseReleaseDate(pluginBean);
        this.myReleaseVersion = pd != null ? pd.releaseVersion : 0;
        String internalVersionString = pluginBean.formatVersion;
        if (internalVersionString != null) {
            try {
                Integer.parseInt(internalVersionString);
            }
            catch (NumberFormatException e) {
                LOG.error((Throwable)new PluginException("Invalid value in plugin.xml format version: '" + internalVersionString + "'", (Throwable)e, this.myId));
            }
        }
        this.myUseIdeaClassLoader = pluginBean.useIdeaClassLoader;
        this.myAllowBundledUpdate = pluginBean.allowBundledUpdate;
        if (pluginBean.ideaVersion != null) {
            this.mySinceBuild = pluginBean.ideaVersion.sinceBuild;
            this.myUntilBuild = IdeaPluginDescriptorImpl.convertExplicitBigNumberInUntilBuildToStar(pluginBean.ideaVersion.untilBuild);
        }
        this.myResourceBundleBaseName = pluginBean.resourceBundle;
        this.myDescriptionChildText = pluginBean.description;
        this.myChangeNotes = pluginBean.changeNotes;
        this.myVersion = pluginBean.pluginVersion;
        if (this.myVersion == null) {
            this.myVersion = PluginManagerCore.getBuildNumber().asStringWithoutProductCode();
        }
        this.myCategory = pluginBean.category;
        if (pluginBean.vendor != null) {
            this.myVendor = pluginBean.vendor.name;
            this.myVendorEmail = pluginBean.vendor.email;
            this.myVendorUrl = pluginBean.vendor.url;
            this.myVendorLogoPath = pluginBean.vendor.logo;
        }
        LinkedHashSet<PluginId> dependentPlugins = new LinkedHashSet<PluginId>();
        LinkedHashSet<PluginId> nonOptionalDependentPlugins = new LinkedHashSet<PluginId>();
        if (pluginBean.dependencies != null) {
            this.myOptionalConfigs = new LinkedHashMap<PluginId, List<String>>();
            for (PluginDependency dependency : pluginBean.dependencies) {
                String text = dependency.pluginId;
                if (StringUtil.isEmptyOrSpaces((String)text)) continue;
                PluginId id2 = PluginId.getId((String)text);
                dependentPlugins.add(id2);
                if (dependency.optional) {
                    if (StringUtil.isEmptyOrSpaces((String)dependency.configFile)) continue;
                    this.myOptionalConfigs.computeIfAbsent(id2, it -> new SmartList()).add(dependency.configFile);
                    continue;
                }
                nonOptionalDependentPlugins.add(id2);
            }
        }
        this.myDependencies = dependentPlugins.isEmpty() ? PluginId.EMPTY_ARRAY : dependentPlugins.toArray(PluginId.EMPTY_ARRAY);
        this.myOptionalDependencies = nonOptionalDependentPlugins.size() == dependentPlugins.size() ? PluginId.EMPTY_ARRAY : ContainerUtil.filter(dependentPlugins, id -> !nonOptionalDependentPlugins.contains(id)).toArray(PluginId.EMPTY_ARRAY);
        if (pluginBean.helpSets == null || pluginBean.helpSets.length == 0) {
            this.myHelpSets = HelpSetPath.EMPTY;
        } else {
            this.myHelpSets = new HelpSetPath[pluginBean.helpSets.length];
            for (PluginHelpSet pluginHelpSet : pluginBean.helpSets) {
                this.myHelpSets[i] = new HelpSetPath(pluginHelpSet.file, pluginHelpSet.path);
            }
        }
        Ref oldComponentConfigBeanBinding = new Ref();
        block22: for (Content content : element.getContent()) {
            if (!(content instanceof Element)) continue;
            Element child2 = (Element)content;
            switch (child2.getName()) {
                case "extensions": {
                    if (this.myExtensions == null) {
                        this.myExtensions = MultiMap.createSmart();
                    }
                    String ns = child2.getAttributeValue("defaultExtensionNs");
                    for (Element extensionElement : child2.getChildren()) {
                        String os = extensionElement.getAttributeValue("os");
                        if (os != null) {
                            extensionElement.removeAttribute("os");
                            if (!Extensions.isComponentSuitableForOs((String)os)) continue;
                        }
                        this.myExtensions.putValue((Object)ExtensionsAreaImpl.extractPointName((Element)extensionElement, (String)ns), (Object)extensionElement);
                    }
                    continue block22;
                }
                case "extensionPoints": {
                    if (this.myExtensionsPoints == null) {
                        this.myExtensionsPoints = MultiMap.createSmart();
                    }
                    for (Element extensionPoint : child2.getChildren()) {
                        this.myExtensionsPoints.putValue((Object)StringUtilRt.notNullize((String)extensionPoint.getAttributeValue("area")), (Object)extensionPoint);
                    }
                    continue block22;
                }
                case "actions": {
                    if (this.myActionElements == null) {
                        this.myActionElements = new ArrayList<Element>(child2.getChildren());
                        break;
                    }
                    this.myActionElements.addAll(child2.getChildren());
                    break;
                }
                case "module": {
                    String moduleName = child2.getAttributeValue("value");
                    if (moduleName == null) continue block22;
                    if (this.myModules == null) {
                        this.myModules = new SmartList();
                    }
                    this.myModules.add(moduleName);
                    break;
                }
                case "application-components": {
                    if (this.myAppComponents == Collections.emptyList()) {
                        this.myAppComponents = new ArrayList<ComponentConfig>();
                    }
                    IdeaPluginDescriptorImpl.readComponents(child2, (Ref<BeanBinding>)oldComponentConfigBeanBinding, (ArrayList)this.myAppComponents);
                    break;
                }
                case "project-components": {
                    if (this.myProjectComponents == Collections.emptyList()) {
                        this.myProjectComponents = new ArrayList<ComponentConfig>();
                    }
                    IdeaPluginDescriptorImpl.readComponents(child2, (Ref<BeanBinding>)oldComponentConfigBeanBinding, (ArrayList)this.myProjectComponents);
                    break;
                }
                case "module-components": {
                    if (this.myModuleComponents == Collections.emptyList()) {
                        this.myModuleComponents = new ArrayList<ComponentConfig>();
                    }
                    IdeaPluginDescriptorImpl.readComponents(child2, (Ref<BeanBinding>)oldComponentConfigBeanBinding, (ArrayList)this.myModuleComponents);
                }
            }
        }
    }

    private static void readComponents(@NotNull Element parent, @NotNull Ref<BeanBinding> oldComponentConfigBean, @NotNull ArrayList<ComponentConfig> result2) {
        List content = parent.getContent();
        int contentSize = content.size();
        if (contentSize == 0) {
            return;
        }
        result2.ensureCapacity(result2.size() + contentSize);
        for (Content child2 : content) {
            Element componentElement;
            if (!(child2 instanceof Element) || !(componentElement = (Element)child2).getName().equals("component")) continue;
            OldComponentConfig componentConfig = new OldComponentConfig();
            BeanBinding beanBinding = (BeanBinding)oldComponentConfigBean.get();
            if (beanBinding == null) {
                beanBinding = XmlSerializer.getBeanBinding((Object)componentConfig);
                oldComponentConfigBean.set((Object)beanBinding);
            }
            beanBinding.deserializeInto((Object)componentConfig, componentElement);
            result2.add((ComponentConfig)componentConfig);
        }
    }

    @Nullable
    private static Date parseReleaseDate(@NotNull OptimizedPluginBean bean) {
        String dateStr;
        ProductDescriptor pd = bean.productDescriptor;
        String string = dateStr = pd != null ? pd.releaseDate : null;
        if (dateStr != null) {
            try {
                return new SimpleDateFormat("yyyyMMdd", Locale.US).parse(dateStr);
            }
            catch (ParseException e) {
                LOG.info("Error parse release date from plugin descriptor for plugin " + bean.name + " {" + bean.id + "}: " + e.getMessage());
            }
        }
        return null;
    }

    public static String convertExplicitBigNumberInUntilBuildToStar(@Nullable String build2) {
        if (build2 == null) {
            return null;
        }
        Matcher matcher = EXPLICIT_BIG_NUMBER_PATTERN.matcher(build2);
        if (matcher.matches()) {
            return matcher.group(1) + ".*";
        }
        return build2;
    }

    public void registerExtensionPoints(@NotNull ExtensionsArea area) {
        if (this.myExtensionsPoints != null) {
            for (Element element : this.myExtensionsPoints.get((Object)StringUtil.notNullize((String)area.getAreaClass()))) {
                area.registerExtensionPoint((PluginDescriptor)this, element);
            }
        }
    }

    public void registerExtensions(@NotNull ExtensionsArea area, @NotNull String epName) {
        this.registerExtensions(area, area.getExtensionPoint(epName));
    }

    public void registerExtensions(@NotNull ExtensionsArea area, @NotNull ExtensionPoint<?> extensionPoint) {
        if (this.myExtensions == null) {
            return;
        }
        Collection elements = this.myExtensions.get((Object)extensionPoint.getName());
        if (elements.isEmpty()) {
            return;
        }
        for (Element element : elements) {
            area.registerExtension(extensionPoint, (PluginDescriptor)this, element);
        }
    }

    public String getDescription() {
        return (String)this.myDescription.getValue();
    }

    public String getChangeNotes() {
        return this.myChangeNotes;
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getProductCode() {
        return this.myProductCode;
    }

    @Nullable
    public Date getReleaseDate() {
        return this.myReleaseDate;
    }

    public int getReleaseVersion() {
        return this.myReleaseVersion;
    }

    @NotNull
    public PluginId[] getDependentPluginIds() {
        return this.myDependencies;
    }

    @NotNull
    public PluginId[] getOptionalDependentPluginIds() {
        return this.myOptionalDependencies;
    }

    public String getVendor() {
        return this.myVendor;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public String getResourceBundleBaseName() {
        return this.myResourceBundleBaseName;
    }

    public String getCategory() {
        return this.myCategory;
    }

    public void setCategory(String category) {
        this.myCategory = category;
    }

    @Nullable
    public MultiMap<String, Element> getExtensionsPoints() {
        return this.myExtensionsPoints;
    }

    @Nullable
    public MultiMap<String, Element> getExtensions() {
        if (this.myExtensions == null) {
            return null;
        }
        MultiMap result2 = MultiMap.create();
        result2.putAllValues(this.myExtensions);
        return result2;
    }

    @NotNull
    public List<File> getClassPath() {
        if (this.myPath.isDirectory()) {
            File[] files2;
            ArrayList<File> result2 = new ArrayList<File>();
            File classesDir = new File(this.myPath, "classes");
            if (classesDir.exists()) {
                result2.add(classesDir);
            }
            if ((files2 = new File(this.myPath, "lib").listFiles()) != null && files2.length > 0) {
                for (File f : files2) {
                    if (f.isFile()) {
                        String name = f.getName();
                        if (!StringUtil.endsWithIgnoreCase((String)name, (String)".jar") && !StringUtil.endsWithIgnoreCase((String)name, (String)".zip")) continue;
                        result2.add(f);
                        continue;
                    }
                    result2.add(f);
                }
            }
            return result2;
        }
        return Collections.singletonList(this.myPath);
    }

    @Nullable
    public List<Element> getActionsDescriptionElements() {
        return this.myActionElements;
    }

    @NotNull
    public List<ComponentConfig> getAppComponents() {
        return this.myAppComponents;
    }

    @NotNull
    public List<ComponentConfig> getProjectComponents() {
        return this.myProjectComponents;
    }

    @NotNull
    public List<ComponentConfig> getModuleComponents() {
        return this.myModuleComponents;
    }

    public String getVendorEmail() {
        return this.myVendorEmail;
    }

    public String getVendorUrl() {
        return this.myVendorUrl;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public void setUrl(String val) {
        this.myUrl = val;
    }

    public boolean isDeleted() {
        return this.myDeleted;
    }

    public void setDeleted(boolean deleted) {
        this.myDeleted = deleted;
    }

    public void setLoader(ClassLoader loader) {
        this.myLoader = loader;
    }

    @NotNull
    public HelpSetPath[] getHelpSets() {
        return this.myHelpSets;
    }

    public PluginId getPluginId() {
        return this.myId;
    }

    @Deprecated
    public String getDownloads() {
        return null;
    }

    public ClassLoader getPluginClassLoader() {
        return this.myLoader != null ? this.myLoader : this.getClass().getClassLoader();
    }

    public String getVendorLogoPath() {
        return this.myVendorLogoPath;
    }

    public boolean getUseIdeaClassLoader() {
        return this.myUseIdeaClassLoader;
    }

    boolean isUseCoreClassLoader() {
        return this.myUseCoreClassLoader;
    }

    void setUseCoreClassLoader(boolean useCoreClassLoader) {
        this.myUseCoreClassLoader = useCoreClassLoader;
    }

    private String computeDescription() {
        ResourceBundle bundle = null;
        if (this.myResourceBundleBaseName != null) {
            try {
                bundle = AbstractBundle.getResourceBundle((String)this.myResourceBundleBaseName, (ClassLoader)this.getPluginClassLoader());
            }
            catch (MissingResourceException e) {
                LOG.info("Cannot find plugin " + this.myId + " resource-bundle: " + this.myResourceBundleBaseName);
            }
        }
        if (bundle == null) {
            return this.myDescriptionChildText;
        }
        return CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)IdeaPluginDescriptorImpl.createDescriptionKey(this.myId), (String)(this.myDescriptionChildText == null ? "" : this.myDescriptionChildText), (Object[])new Object[0]);
    }

    void insertDependency(@NotNull IdeaPluginDescriptor d) {
        PluginId[] deps = new PluginId[this.getDependentPluginIds().length + 1];
        deps[0] = d.getPluginId();
        System.arraycopy(this.myDependencies, 0, deps, 1, deps.length - 1);
        this.myDependencies = deps;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public String getSinceBuild() {
        return this.mySinceBuild;
    }

    public String getUntilBuild() {
        return this.myUntilBuild;
    }

    Map<PluginId, List<String>> getOptionalConfigs() {
        return this.myOptionalConfigs;
    }

    @Nullable
    Map<PluginId, List<IdeaPluginDescriptorImpl>> getOptionalDescriptors() {
        return this.myOptionalDescriptors;
    }

    void setOptionalDescriptors(@NotNull Map<PluginId, List<IdeaPluginDescriptorImpl>> optionalDescriptors) {
        this.myOptionalDescriptors = optionalDescriptors;
    }

    void mergeOptionalConfig(@NotNull IdeaPluginDescriptorImpl descriptor) {
        if (this.myExtensions == null) {
            this.myExtensions = descriptor.myExtensions;
        } else if (descriptor.myExtensions != null) {
            this.myExtensions.putAllValues(descriptor.myExtensions);
        }
        if (this.myExtensionsPoints == null) {
            this.myExtensionsPoints = descriptor.myExtensionsPoints;
        } else if (descriptor.myExtensionsPoints != null) {
            this.myExtensionsPoints.putAllValues(descriptor.myExtensionsPoints);
        }
        if (this.myActionElements == null) {
            this.myActionElements = descriptor.myActionElements;
        } else if (descriptor.myActionElements != null) {
            this.myActionElements.addAll(descriptor.myActionElements);
        }
        this.myAppComponents = ContainerUtil.concat(this.myAppComponents, descriptor.myAppComponents);
        this.myProjectComponents = ContainerUtil.concat(this.myProjectComponents, descriptor.myProjectComponents);
        this.myModuleComponents = ContainerUtil.concat(this.myModuleComponents, descriptor.myModuleComponents);
    }

    public Boolean getSkipped() {
        return this.mySkipped;
    }

    public void setSkipped(Boolean skipped) {
        this.mySkipped = skipped;
    }

    public boolean isBundled() {
        return this.myBundled;
    }

    public boolean allowBundledUpdate() {
        return this.myAllowBundledUpdate;
    }

    @NotNull
    public List<String> getModules() {
        return ContainerUtil.notNullize(this.myModules);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof IdeaPluginDescriptorImpl && this.myId == ((IdeaPluginDescriptorImpl)o).myId;
    }

    public int hashCode() {
        return Objects.hashCode(this.myId);
    }

    public String toString() {
        return "PluginDescriptor(name=" + this.myName + ", classpath=" + this.myPath + ")";
    }
}

