/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.plugins.AvailablePluginsManagerMain;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstallPluginAction;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.InstalledPluginsTableModel;
import com.intellij.ide.plugins.PluginInstaller;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginTable;
import com.intellij.ide.plugins.UninstallPluginAction;
import com.intellij.ide.ui.search.ActionFromOptionDescriptorProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.editor.CustomFileDropHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.TextTransferable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPluginsManagerMain
extends PluginManagerMain {
    private static final String PLUGINS_PRESELECTION_PATH = "plugins.preselection.path";
    private static final InstalledPluginsState ourState = InstalledPluginsState.getInstance();
    private static final String INSTALL_PLUGIN_FROM_DISK_BUTTON_LABEL = "Install plugin from disk...";

    public InstalledPluginsManagerMain(PluginManagerUISettings uiSettings) {
        super(uiSettings);
        this.init();
        this.myActionsPanel.setLayout(new FlowLayout(0));
        JButton installJB = new JButton("Install JetBrains plugin...");
        installJB.setMnemonic('j');
        installJB.addActionListener(new BrowseRepoListener("JetBrains"));
        this.myActionsPanel.add(installJB);
        JButton browse = new JButton("Browse repositories...");
        browse.setMnemonic('b');
        browse.addActionListener(new BrowseRepoListener(null));
        this.myActionsPanel.add(browse);
        JButton installFromDisk = new JButton(INSTALL_PLUGIN_FROM_DISK_BUTTON_LABEL);
        installFromDisk.setMnemonic('d');
        installFromDisk.addActionListener(e -> {
            InstalledPluginsTableModel model = (InstalledPluginsTableModel)this.pluginsModel;
            InstalledPluginsManagerMain.chooseAndInstall(model, (Consumer<? super Pair<File, IdeaPluginDescriptor>>)((Consumer)pair -> {
                model.appendOrUpdateDescriptor((IdeaPluginDescriptor)pair.second);
                this.setRequireShutdown(true);
                this.select((IdeaPluginDescriptor)pair.second);
            }), this.myActionsPanel);
        });
        this.myActionsPanel.add(installFromDisk);
        StatusText emptyText = this.pluginTable.getEmptyText();
        emptyText.setText("No plugins found. ");
        emptyText.appendText("Search in repositories", SimpleTextAttributes.LINK_ATTRIBUTES, (ActionListener)new BrowseRepoListener(null));
    }

    public static void chooseAndInstall(@NotNull InstalledPluginsTableModel model, @NotNull Consumer<? super Pair<File, IdeaPluginDescriptor>> callback2, @Nullable Component parent) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, false, true, true, false, false){

            public boolean isFileSelectable(VirtualFile file2) {
                String extension = file2.getExtension();
                return Comparing.strEqual((String)extension, (String)"jar") || Comparing.strEqual((String)extension, (String)"zip");
            }
        };
        descriptor.setTitle("Choose Plugin File");
        descriptor.setDescription("JAR and ZIP archives are accepted");
        String oldPath = PropertiesComponent.getInstance().getValue(PLUGINS_PRESELECTION_PATH);
        VirtualFile toSelect2 = oldPath == null ? null : VfsUtil.findFileByIoFile((File)new File(FileUtil.toSystemDependentName((String)oldPath)), (boolean)false);
        FileChooser.chooseFile((FileChooserDescriptor)descriptor, null, (Component)parent, (VirtualFile)toSelect2, virtualFile -> {
            File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            PropertiesComponent.getInstance().setValue(PLUGINS_PRESELECTION_PATH, FileUtil.toSystemIndependentName((String)file2.getParent()));
            InstalledPluginsManagerMain.install(model, file2, callback2, parent);
        });
    }

    private static boolean install(@NotNull InstalledPluginsTableModel model, @NotNull File file2, @NotNull Consumer<? super Pair<File, IdeaPluginDescriptor>> callback2, @Nullable Component parent) {
        try {
            IdeaPluginDescriptorImpl pluginDescriptor = PluginDownloader.loadDescriptionFromJar(file2);
            if (pluginDescriptor == null) {
                MessagesEx.showErrorDialog(parent, "Fail to load plugin descriptor from file " + file2.getName(), CommonBundle.getErrorTitle());
                return false;
            }
            if (ourState.wasInstalled(pluginDescriptor.getPluginId())) {
                String message = "Plugin '" + pluginDescriptor.getName() + "' was already installed";
                MessagesEx.showWarningDialog(parent, message, CommonBundle.getWarningTitle());
                return false;
            }
            if (PluginManagerCore.isIncompatible(pluginDescriptor)) {
                String message = "Plugin '" + pluginDescriptor.getName() + "' is incompatible with this installation";
                MessagesEx.showErrorDialog(parent, message, CommonBundle.getErrorTitle());
                return false;
            }
            File oldFile = null;
            IdeaPluginDescriptor installedPlugin = PluginManager.getPlugin(pluginDescriptor.getPluginId());
            if (installedPlugin != null && !installedPlugin.isBundled()) {
                oldFile = installedPlugin.getPath();
            }
            PluginInstaller.install(file2, false, oldFile, pluginDescriptor);
            ourState.onPluginInstall(pluginDescriptor);
            InstalledPluginsManagerMain.checkInstalledPluginDependencies(model, pluginDescriptor, parent);
            callback2.consume((Object)Pair.pair((Object)file2, (Object)pluginDescriptor));
            return true;
        }
        catch (IOException ex) {
            MessagesEx.showErrorDialog(parent, ex.getMessage(), CommonBundle.getErrorTitle());
            return false;
        }
    }

    private static void checkInstalledPluginDependencies(@NotNull InstalledPluginsTableModel model, @NotNull IdeaPluginDescriptorImpl pluginDescriptor, @Nullable Component parent) {
        HashSet<PluginId> notInstalled = new HashSet<PluginId>();
        HashSet<PluginId> disabledIds = new HashSet<PluginId>();
        PluginId[] dependentPluginIds = pluginDescriptor.getDependentPluginIds();
        Object[] optionalDependentPluginIds = pluginDescriptor.getOptionalDependentPluginIds();
        for (PluginId id : dependentPluginIds) {
            if (ArrayUtilRt.find((Object[])optionalDependentPluginIds, (Object)id) > -1) continue;
            boolean disabled = model.isDisabled(id);
            boolean enabled = model.isEnabled(id);
            if (!(enabled || disabled || PluginManagerCore.isModuleDependency(id))) {
                notInstalled.add(id);
                continue;
            }
            if (!disabled) continue;
            disabledIds.add(id);
        }
        if (!notInstalled.isEmpty()) {
            String deps = StringUtil.join(notInstalled, PluginId::toString, (String)", ");
            String message = "Plugin " + pluginDescriptor.getName() + " depends on unknown plugin" + (notInstalled.size() > 1 ? "s " : " ") + deps;
            MessagesEx.showWarningDialog(parent, message, CommonBundle.getWarningTitle());
        }
        if (!disabledIds.isEmpty()) {
            HashSet<IdeaPluginDescriptor> dependencies = new HashSet<IdeaPluginDescriptor>();
            for (IdeaPluginDescriptor ideaPluginDescriptor : model.getAllPlugins()) {
                if (!disabledIds.contains(ideaPluginDescriptor.getPluginId())) continue;
                dependencies.add(ideaPluginDescriptor);
            }
            String part = "disabled plugin" + (dependencies.size() > 1 ? "s " : " ");
            String deps = StringUtil.join(dependencies, IdeaPluginDescriptor::getName, (String)", ");
            String message = "Plugin " + pluginDescriptor.getName() + " depends on " + part + deps + ". Enable " + part.trim() + "?";
            if (MessagesEx.showOkCancelDialog(parent, message, CommonBundle.getWarningTitle(), Messages.getWarningIcon()) == 0) {
                model.enableRows(dependencies.toArray(new IdeaPluginDescriptor[0]), Boolean.TRUE);
            }
        }
    }

    @Override
    protected void propagateUpdates(List<IdeaPluginDescriptor> list2) {
    }

    private PluginManagerConfigurable createAvailableConfigurable(final String vendorFilter) {
        return new PluginManagerConfigurable(PluginManagerUISettings.getInstance(), true){

            @Override
            protected PluginManagerMain createPanel() {
                return new AvailablePluginsManagerMain(InstalledPluginsManagerMain.this, this.myUISettings, vendorFilter);
            }

            @Override
            public String getDisplayName() {
                return vendorFilter != null ? "Browse " + vendorFilter + " Plugins " : "Browse Repositories";
            }
        };
    }

    @Override
    protected JScrollPane createTable() {
        this.pluginsModel = new InstalledPluginsTableModel();
        if (PluginManagerUISettings.getInstance().installedSortByStatus) {
            this.pluginsModel.setSortByStatus(true);
        }
        this.pluginTable = new PluginTable(this.pluginsModel);
        this.pluginTable.setTableHeader(null);
        JScrollPane installedScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.pluginTable), (int)20, (int)30);
        this.pluginTable.registerKeyboardAction(e -> {
            int column = InstalledPluginsTableModel.getCheckboxColumn();
            int[] selectedRows = this.pluginTable.getSelectedRows();
            boolean currentlyMarked = true;
            for (int selectedRow : selectedRows) {
                if (selectedRow < 0 || !this.pluginTable.isCellEditable(selectedRow, column)) {
                    return;
                }
                Boolean enabled = (Boolean)this.pluginTable.getValueAt(selectedRow, column);
                currentlyMarked &= enabled == null || enabled != false;
            }
            IdeaPluginDescriptor[] selected = new IdeaPluginDescriptor[selectedRows.length];
            int selectedLength = selected.length;
            for (int i = 0; i < selectedLength; ++i) {
                selected[i] = this.pluginsModel.getObjectAt(this.pluginTable.convertRowIndexToModel(selectedRows[i]));
            }
            ((InstalledPluginsTableModel)this.pluginsModel).enableRows(selected, currentlyMarked ? Boolean.FALSE : Boolean.TRUE);
            this.pluginTable.repaint();
        }, KeyStroke.getKeyStroke(32, 0), 0);
        InstalledPluginsManagerMain.registerCopyProvider(this.pluginTable);
        this.pluginTable.setExpandableItemsEnabled(false);
        return installedScrollPane;
    }

    private static void registerCopyProvider(final PluginTable table) {
        CopyProvider copyProvider = new CopyProvider(){

            public void performCopy(@NotNull DataContext dataContext) {
                StringBuilder sb = new StringBuilder();
                for (IdeaPluginDescriptor pluginDescriptor : table.getSelectedObjects()) {
                    sb.append(pluginDescriptor.getName()).append(" (").append(pluginDescriptor.getVersion()).append(")\n");
                }
                CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(sb.substring(0, sb.length() - 1)));
            }

            public boolean isCopyEnabled(@NotNull DataContext dataContext) {
                return table.getSelectedRowCount() > 0;
            }

            public boolean isCopyVisible(@NotNull DataContext dataContext) {
                return true;
            }
        };
        DataManager.registerDataProvider((JComponent)((Object)table), dataId -> {
            if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                return copyProvider;
            }
            return null;
        });
    }

    @Override
    protected PluginManagerMain getAvailable() {
        return this;
    }

    @Override
    protected PluginManagerMain getInstalled() {
        return this;
    }

    @Override
    protected ActionGroup getActionGroup(boolean inToolbar) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        if (inToolbar) {
            actionGroup.add((AnAction)new MyFilterEnabledAction());
        } else {
            actionGroup.add((AnAction)new PluginManagerMain.RefreshAction(this));
            actionGroup.addAction((AnAction)this.createSortersGroup());
            actionGroup.add((AnAction)Separator.getInstance());
            actionGroup.add((AnAction)new InstallPluginAction(this.getAvailable(), this.getInstalled()));
            actionGroup.add((AnAction)new UninstallPluginAction(this, this.pluginTable));
        }
        return actionGroup;
    }

    @Override
    public boolean isModified() {
        boolean modified = super.isModified();
        if (modified) {
            return true;
        }
        List<String> disabledPlugins = PluginManagerCore.getDisabledPlugins();
        for (int i = 0; i < this.pluginsModel.getRowCount(); ++i) {
            if (!this.isPluginStateChanged(this.pluginsModel.getObjectAt(i), disabledPlugins)) continue;
            return true;
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : this.pluginsModel.filtered) {
            if (!this.isPluginStateChanged(ideaPluginDescriptor, disabledPlugins)) continue;
            return true;
        }
        for (Map.Entry entry : ((InstalledPluginsTableModel)this.pluginsModel).getEnabledMap().entrySet()) {
            Boolean enabled = (Boolean)entry.getValue();
            if (enabled == null || enabled.booleanValue() || disabledPlugins.contains(((PluginId)entry.getKey()).toString())) continue;
            return true;
        }
        return false;
    }

    private boolean isPluginStateChanged(IdeaPluginDescriptor pluginDescriptor, List<String> disabledPlugins) {
        PluginId pluginId = pluginDescriptor.getPluginId();
        boolean enabledInTable = ((InstalledPluginsTableModel)this.pluginsModel).isEnabled(pluginId);
        if (pluginDescriptor.isEnabled() != enabledInTable) {
            return !enabledInTable || disabledPlugins.contains(pluginId.getIdString());
        }
        return false;
    }

    @Override
    public String apply() {
        String apply2 = super.apply();
        if (apply2 != null) {
            return apply2;
        }
        for (int i = 0; i < this.pluginTable.getRowCount(); ++i) {
            IdeaPluginDescriptor pluginDescriptor = this.pluginsModel.getObjectAt(i);
            Boolean enabled = (Boolean)this.pluginsModel.getValueAt(i, InstalledPluginsTableModel.getCheckboxColumn());
            pluginDescriptor.setEnabled(enabled != null && enabled != false);
        }
        for (IdeaPluginDescriptor descriptor : this.pluginsModel.filtered) {
            descriptor.setEnabled(((InstalledPluginsTableModel)this.pluginsModel).isEnabled(descriptor.getPluginId()));
        }
        try {
            ArrayList<String> ids = new ArrayList<String>();
            for (Map.Entry<PluginId, Boolean> entry : ((InstalledPluginsTableModel)this.pluginsModel).getEnabledMap().entrySet()) {
                Boolean value = entry.getValue();
                if (value == null || value.booleanValue()) continue;
                ids.add(entry.getKey().getIdString());
            }
            PluginManagerCore.saveDisabledPlugins(ids, false);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @Override
    protected String canApply() {
        HashMap<PluginId, Set<PluginId>> dependentToRequiredListMap = new HashMap<PluginId, Set<PluginId>>(((InstalledPluginsTableModel)this.pluginsModel).getDependentToRequiredListMap());
        Iterator iterator = dependentToRequiredListMap.keySet().iterator();
        while (iterator.hasNext()) {
            PluginId id = (PluginId)iterator.next();
            boolean hasNonModuleDeps = false;
            for (PluginId pluginId2 : (Set)dependentToRequiredListMap.get(id)) {
                if (PluginManagerCore.isModuleDependency(pluginId2)) continue;
                hasNonModuleDeps = true;
                break;
            }
            if (hasNonModuleDeps) continue;
            iterator.remove();
        }
        if (!dependentToRequiredListMap.isEmpty()) {
            return "<html><body style=\"padding: 5px;\">Unable to apply changes: plugin" + (dependentToRequiredListMap.size() == 1 ? " " : "s ") + StringUtil.join(dependentToRequiredListMap.keySet(), pluginId -> {
                IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getPlugin(pluginId);
                return "\"" + (ideaPluginDescriptor != null ? ideaPluginDescriptor.getName() : pluginId.getIdString()) + "\"";
            }, (String)", ") + " won't be able to load.</body></html>";
        }
        return super.canApply();
    }

    public static class PluginsActionFromOptionDescriptorProvider
    extends ActionFromOptionDescriptorProvider {
        @Nullable
        public AnAction provide(@NotNull OptionDescription description) {
            String name = InstalledPluginsManagerMain.INSTALL_PLUGIN_FROM_DISK_BUTTON_LABEL;
            if (name.equals(description.getHit()) && "preferences.pluginManager".equals(description.getConfigurableId())) {
                return new InstallFromDiskAction(name);
            }
            return null;
        }
    }

    public static class PluginDropHandler
    extends CustomFileDropHandler {
        @Override
        public boolean canHandle(@NotNull Transferable t, @Nullable Editor editor) {
            File file2 = PluginDropHandler.getFile(t);
            if (file2 == null) {
                return false;
            }
            String path = file2.getPath();
            return FileUtilRt.extensionEquals((String)path, (String)"jar") || FileUtilRt.extensionEquals((String)path, (String)"zip");
        }

        @Override
        public boolean handleDrop(@NotNull Transferable t, @Nullable Editor editor, Project project) {
            File file2 = PluginDropHandler.getFile(t);
            if (file2 == null) {
                return false;
            }
            return InstalledPluginsManagerMain.install(new InstalledPluginsTableModel(), file2, (Consumer<? super Pair<File, IdeaPluginDescriptor>>)pair -> PluginManagerConfigurable.shutdownOrRestartApp(), null);
        }

        @Nullable
        private static File getFile(@NotNull Transferable t) {
            List<File> list2 = FileCopyPasteUtil.getFileList(t);
            return list2 == null || list2.size() != 1 ? null : list2.get(0);
        }
    }

    public static class InstallFromDiskAction
    extends DumbAwareAction {
        public InstallFromDiskAction(@Nullable String text) {
            super(text, "", AllIcons.Nodes.Plugin);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            InstalledPluginsManagerMain.chooseAndInstall(new InstalledPluginsTableModel(), (Consumer<? super Pair<File, IdeaPluginDescriptor>>)((Consumer)pair -> PluginManagerConfigurable.shutdownOrRestartApp()), null);
        }
    }

    private class BrowseRepoListener
    implements ActionListener {
        private final String myVendor;

        BrowseRepoListener(String vendor) {
            this.myVendor = vendor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final PluginManagerConfigurable configurable = InstalledPluginsManagerMain.this.createAvailableConfigurable(this.myVendor);
            SingleConfigurableEditor configurableEditor = new SingleConfigurableEditor(InstalledPluginsManagerMain.this.myActionsPanel, (Configurable)configurable, ShowSettingsUtilImpl.createDimensionKey((Configurable)configurable), false){
                {
                    super(parent, configurable2, dimensionServiceKey, showApplyButton);
                    this.setOKButtonText(CommonBundle.message((String)"close.action.name", (Object[])new Object[0]));
                    this.setOKButtonMnemonic(67);
                    String filter = InstalledPluginsManagerMain.this.myFilter.getFilter();
                    if (!StringUtil.isEmptyOrSpaces((String)filter)) {
                        Runnable searchRunnable = configurable.enableSearch(filter);
                        PluginManagerMain.LOG.assertTrue(searchRunnable != null);
                        searchRunnable.run();
                    }
                }

                @Override
                @NotNull
                protected Action[] createActions() {
                    return new Action[]{this.getOKAction()};
                }
            };
            configurableEditor.show();
        }
    }

    private class MyFilterEnabledAction
    extends ComboBoxAction
    implements DumbAware {
        private MyFilterEnabledAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setText(((InstalledPluginsTableModel)InstalledPluginsManagerMain.this.pluginsModel).getEnabledFilter());
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
            DefaultActionGroup gr = new DefaultActionGroup();
            for (final String enabledValue : InstalledPluginsTableModel.ENABLED_VALUES) {
                gr.add((AnAction)new DumbAwareAction(enabledValue){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        IdeaPluginDescriptor[] selection = InstalledPluginsManagerMain.this.pluginTable.getSelectedObjects();
                        String filter = InstalledPluginsManagerMain.this.myFilter.getFilter().toLowerCase();
                        ((InstalledPluginsTableModel)InstalledPluginsManagerMain.this.pluginsModel).setEnabledFilter(enabledValue, filter);
                        if (selection != null) {
                            InstalledPluginsManagerMain.this.select(selection);
                        }
                    }
                });
            }
            return gr;
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            JComponent component = super.createCustomComponent(presentation, place);
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setOpaque(false);
            panel2.add((Component)component, "Center");
            JLabel comp = new JLabel("Show:");
            comp.setIconTextGap(0);
            comp.setHorizontalTextPosition(4);
            comp.setVerticalTextPosition(0);
            comp.setAlignmentX(1.0f);
            panel2.add((Component)comp, "West");
            panel2.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
            return panel2;
        }
    }
}

