/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginTableModel;
import com.intellij.ide.plugins.PluginsTableRenderer;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPluginsTableModel
extends PluginTableModel {
    private static final InstalledPluginsState ourState = InstalledPluginsState.getInstance();
    private static final String ENABLED_DISABLED = "All plugins";
    private static final String ENABLED = "Enabled";
    private static final String DISABLED = "Disabled";
    private static final String BUNDLED = "Bundled";
    private static final String CUSTOM = "Custom";
    public static final String[] ENABLED_VALUES = new String[]{"All plugins", "Enabled", "Disabled", "Bundled", "Custom"};
    private final Map<PluginId, Boolean> myEnabled = ContainerUtil.newHashMap();
    private final Map<PluginId, Set<PluginId>> myDependentToRequiredListMap = ContainerUtil.newHashMap();
    private String myEnabledFilter = "All plugins";

    public InstalledPluginsTableModel() {
        MyPluginManagerColumnInfo infoColumn = new MyPluginManagerColumnInfo();
        EnabledPluginInfo enabledColumn = new EnabledPluginInfo();
        this.columns = new ColumnInfo[]{infoColumn, enabledColumn};
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        for (IdeaPluginDescriptor plugin : PluginManagerCore.getPlugins()) {
            if (appInfo.isEssentialPlugin(plugin.getPluginId().getIdString())) {
                this.myEnabled.put(plugin.getPluginId(), true);
                continue;
            }
            this.view.add(plugin);
        }
        this.view.addAll(ourState.getInstalledPlugins());
        for (IdeaPluginDescriptor descriptor : this.view) {
            this.setEnabled(descriptor, descriptor.isEnabled());
        }
        this.updatePluginDependencies();
        this.setSortKey(new RowSorter.SortKey(this.getNameColumn(), SortOrder.ASCENDING));
    }

    public boolean hasProblematicDependencies(PluginId pluginId) {
        Set<PluginId> ids = this.myDependentToRequiredListMap.get(pluginId);
        return ids != null && !ids.isEmpty();
    }

    @Nullable
    public Set<PluginId> getRequiredPlugins(PluginId pluginId) {
        return this.myDependentToRequiredListMap.get(pluginId);
    }

    public boolean isLoaded(PluginId pluginId) {
        return this.myEnabled.get(pluginId) != null;
    }

    public void appendOrUpdateDescriptor(@NotNull IdeaPluginDescriptor descriptor) {
        PluginId id = descriptor.getPluginId();
        if (!PluginManager.isPluginInstalled(id)) {
            List list2 = this.isPluginDescriptorAccepted(descriptor) ? this.view : this.filtered;
            int i = list2.indexOf(descriptor);
            if (i < 0) {
                list2.add(descriptor);
            } else {
                list2.set(i, descriptor);
            }
            this.setEnabled(descriptor, true);
            this.fireTableDataChanged();
        }
    }

    public static int getCheckboxColumn() {
        return 1;
    }

    @Override
    public int getNameColumn() {
        return 0;
    }

    private void setEnabled(IdeaPluginDescriptor ideaPluginDescriptor, boolean enabled) {
        List<String> disabledPlugins = PluginManagerCore.getDisabledPlugins();
        PluginId pluginId = ideaPluginDescriptor.getPluginId();
        if (!enabled && !disabledPlugins.contains(pluginId.toString())) {
            this.myEnabled.put(pluginId, null);
        } else {
            this.myEnabled.put(pluginId, enabled);
        }
    }

    public Map<PluginId, Set<PluginId>> getDependentToRequiredListMap() {
        return this.myDependentToRequiredListMap;
    }

    protected void updatePluginDependencies() {
        this.myDependentToRequiredListMap.clear();
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Boolean enabled;
            IdeaPluginDescriptor descriptor = this.getObjectAt(i);
            PluginId pluginId = descriptor.getPluginId();
            this.myDependentToRequiredListMap.remove(pluginId);
            if (descriptor instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)descriptor).isDeleted() || (enabled = this.myEnabled.get(pluginId)) != null && !enabled.booleanValue()) continue;
            PluginManagerCore.checkDependants(descriptor, (Function<? super PluginId, ? extends IdeaPluginDescriptor>)((Function)pluginId1 -> PluginManager.getPlugin(pluginId1)), (Condition<? super PluginId>)((Condition)dependantPluginId -> {
                Boolean enabled1 = this.myEnabled.get(dependantPluginId);
                if (enabled1 == null && !ourState.wasUpdated((PluginId)dependantPluginId) || enabled1 != null && !enabled1.booleanValue()) {
                    HashSet required = this.myDependentToRequiredListMap.get(pluginId);
                    if (required == null) {
                        required = new HashSet();
                        this.myDependentToRequiredListMap.put(pluginId, (Set<PluginId>)required);
                    }
                    required.add((PluginId)dependantPluginId);
                }
                return true;
            }));
            if (enabled != null || this.myDependentToRequiredListMap.containsKey(pluginId) || !PluginManagerCore.isCompatible(descriptor)) continue;
            this.myEnabled.put(pluginId, true);
        }
    }

    @Override
    public void updatePluginsList(List<IdeaPluginDescriptor> list2) {
        this.fireTableDataChanged();
    }

    public void enableRows(IdeaPluginDescriptor[] ideaPluginDescriptors, Boolean value) {
        for (IdeaPluginDescriptor ideaPluginDescriptor : ideaPluginDescriptors) {
            PluginId currentPluginId = ideaPluginDescriptor.getPluginId();
            Boolean enabled = this.myEnabled.get(currentPluginId) == null ? Boolean.FALSE : value;
            this.myEnabled.put(currentPluginId, enabled);
        }
        this.updatePluginDependencies();
        this.warnAboutMissedDependencies(value, ideaPluginDescriptors);
        this.hideNotApplicablePlugins(value, ideaPluginDescriptors);
    }

    private void hideNotApplicablePlugins(Boolean value, IdeaPluginDescriptor ... ideaPluginDescriptors) {
        if (!value.booleanValue() && ENABLED.equals(this.myEnabledFilter) || value.booleanValue() && DISABLED.equals(this.myEnabledFilter)) {
            SwingUtilities.invokeLater(() -> {
                for (IdeaPluginDescriptor ideaPluginDescriptor : ideaPluginDescriptors) {
                    this.view.remove(ideaPluginDescriptor);
                    this.filtered.add(ideaPluginDescriptor);
                }
                this.fireTableDataChanged();
            });
        }
    }

    public boolean isEnabled(PluginId pluginId) {
        Boolean enabled = this.myEnabled.get(pluginId);
        return enabled != null && enabled != false;
    }

    public boolean isDisabled(PluginId pluginId) {
        Boolean enabled = this.myEnabled.get(pluginId);
        return enabled != null && enabled == false;
    }

    public Map<PluginId, Boolean> getEnabledMap() {
        return this.myEnabled;
    }

    public String getEnabledFilter() {
        return this.myEnabledFilter;
    }

    public void setEnabledFilter(String enabledFilter, String filter) {
        this.myEnabledFilter = enabledFilter;
        this.filter(filter);
    }

    @Override
    public boolean isPluginDescriptorAccepted(IdeaPluginDescriptor descriptor) {
        if (!this.myEnabledFilter.equals(ENABLED_DISABLED)) {
            boolean enabled = this.isEnabled(descriptor.getPluginId());
            if (enabled && this.myEnabledFilter.equals(DISABLED)) {
                return false;
            }
            if (!enabled && this.myEnabledFilter.equals(ENABLED)) {
                return false;
            }
            boolean bundled = descriptor.isBundled();
            if (bundled && this.myEnabledFilter.equals(CUSTOM)) {
                return false;
            }
            if (!bundled && this.myEnabledFilter.equals(BUNDLED)) {
                return false;
            }
        }
        return true;
    }

    private void warnAboutMissedDependencies(Boolean newVal, IdeaPluginDescriptor ... ideaPluginDescriptors) {
        HashSet deps = new HashSet();
        ArrayList<IdeaPluginDescriptor> descriptorsToCheckDependencies = new ArrayList<IdeaPluginDescriptor>();
        if (newVal.booleanValue()) {
            Collections.addAll(descriptorsToCheckDependencies, ideaPluginDescriptors);
        } else {
            descriptorsToCheckDependencies.addAll(this.getAllPlugins());
            descriptorsToCheckDependencies.removeAll(Arrays.asList(ideaPluginDescriptors));
            Iterator iterator = descriptorsToCheckDependencies.iterator();
            while (iterator.hasNext()) {
                IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)iterator.next();
                Boolean enabled = this.myEnabled.get(descriptor.getPluginId());
                if (enabled != null && enabled.booleanValue()) continue;
                iterator.remove();
            }
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : descriptorsToCheckDependencies) {
            PluginManagerCore.checkDependants(ideaPluginDescriptor, (Function<? super PluginId, ? extends IdeaPluginDescriptor>)((Function)pluginId -> PluginManager.getPlugin(pluginId)), (Condition<? super PluginId>)((Condition)arg_0 -> this.lambda$warnAboutMissedDependencies$4(newVal, (Set)deps, ideaPluginDescriptor, ideaPluginDescriptors, arg_0)));
        }
        if (!deps.isEmpty()) {
            String message;
            String listOfSelectedPlugins = StringUtil.join((Object[])ideaPluginDescriptors, pluginDescriptor -> pluginDescriptor.getName(), (String)", ");
            HashSet pluginDependencies = new HashSet();
            String listOfDependencies = StringUtil.join((Collection)deps, arg_0 -> InstalledPluginsTableModel.lambda$warnAboutMissedDependencies$6((Set)pluginDependencies, arg_0), (String)"<br>");
            String string = message = newVal == false ? "<html>The following plugins <br>" + listOfDependencies + "<br>are enabled and depend" + (deps.size() == 1 ? "s" : "") + " on selected plugins. <br>Would you like to disable them too?</html>" : "<html>The following plugins on which " + listOfSelectedPlugins + " depend" + (ideaPluginDescriptors.length == 1 ? "s" : "") + " are disabled:<br>" + listOfDependencies + "<br>Would you like to enable them?</html>";
            if (Messages.showOkCancelDialog((String)message, (String)(newVal != false ? "Enable Dependant Plugins" : "Disable Plugins with Dependency on this"), (Icon)Messages.getQuestionIcon()) == 0) {
                for (PluginId pluginId2 : deps) {
                    this.myEnabled.put(pluginId2, newVal);
                }
                this.updatePluginDependencies();
                this.hideNotApplicablePlugins(newVal, pluginDependencies.toArray(new IdeaPluginDescriptor[0]));
            }
        }
    }

    private static /* synthetic */ String lambda$warnAboutMissedDependencies$6(Set pluginDependencies, PluginId pluginId) {
        IdeaPluginDescriptor pluginDescriptor = PluginManager.getPlugin(pluginId);
        assert (pluginDescriptor != null);
        pluginDependencies.add(pluginDescriptor);
        return pluginDescriptor.getName();
    }

    private /* synthetic */ boolean lambda$warnAboutMissedDependencies$4(Boolean newVal, Set deps, IdeaPluginDescriptor ideaPluginDescriptor, IdeaPluginDescriptor[] ideaPluginDescriptors, PluginId pluginId) {
        Boolean enabled = this.myEnabled.get(pluginId);
        if (enabled == null) {
            return false;
        }
        if (newVal.booleanValue() && !enabled.booleanValue()) {
            deps.add(pluginId);
        }
        if (!newVal.booleanValue()) {
            if (ideaPluginDescriptor instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)ideaPluginDescriptor).isDeleted()) {
                return true;
            }
            PluginId pluginDescriptorId = ideaPluginDescriptor.getPluginId();
            for (IdeaPluginDescriptor descriptor : ideaPluginDescriptors) {
                if (!pluginId.equals(descriptor.getPluginId())) continue;
                deps.add(pluginDescriptorId);
                break;
            }
        }
        return true;
    }

    private class MyPluginManagerColumnInfo
    extends PluginManagerColumnInfo {
        MyPluginManagerColumnInfo() {
            super(0, InstalledPluginsTableModel.this);
        }

        @Override
        public TableCellRenderer getRenderer(IdeaPluginDescriptor pluginDescriptor) {
            return new PluginsTableRenderer(pluginDescriptor, false);
        }

        @Override
        protected boolean isSortByName() {
            return true;
        }

        @Override
        public Comparator<IdeaPluginDescriptor> getComparator() {
            Comparator<IdeaPluginDescriptor> comparator2 = this.getColumnComparator();
            return (o1, o2) -> {
                if (this.isSortByStatus()) {
                    boolean deleted2;
                    boolean incompatible1 = PluginManagerCore.isIncompatible(o1);
                    boolean incompatible2 = PluginManagerCore.isIncompatible(o2);
                    if (incompatible1) {
                        if (incompatible2) {
                            return comparator2.compare((IdeaPluginDescriptor)o1, (IdeaPluginDescriptor)o2);
                        }
                        return -1;
                    }
                    if (incompatible2) {
                        return 1;
                    }
                    boolean hasNewerVersion1 = ourState.hasNewerVersion(o1.getPluginId());
                    boolean hasNewerVersion2 = ourState.hasNewerVersion(o2.getPluginId());
                    if (hasNewerVersion1) {
                        if (hasNewerVersion2) {
                            return comparator2.compare((IdeaPluginDescriptor)o1, (IdeaPluginDescriptor)o2);
                        }
                        return -1;
                    }
                    if (hasNewerVersion2) {
                        return 1;
                    }
                    boolean wasUpdated1 = ourState.wasUpdated(o1.getPluginId());
                    boolean wasUpdated2 = ourState.wasUpdated(o2.getPluginId());
                    if (wasUpdated1) {
                        if (wasUpdated2) {
                            return comparator2.compare((IdeaPluginDescriptor)o1, (IdeaPluginDescriptor)o2);
                        }
                        return -1;
                    }
                    if (wasUpdated2) {
                        return 1;
                    }
                    if (o1 instanceof PluginNode) {
                        if (o2 instanceof PluginNode) {
                            return comparator2.compare((IdeaPluginDescriptor)o1, (IdeaPluginDescriptor)o2);
                        }
                        return -1;
                    }
                    if (o2 instanceof PluginNode) {
                        return 1;
                    }
                    boolean deleted1 = o1 instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)o1).isDeleted();
                    boolean bl = deleted2 = o2 instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)o2).isDeleted();
                    if (deleted1) {
                        if (deleted2) {
                            return comparator2.compare((IdeaPluginDescriptor)o1, (IdeaPluginDescriptor)o2);
                        }
                        return -1;
                    }
                    if (deleted2) {
                        return 1;
                    }
                    boolean enabled1 = InstalledPluginsTableModel.this.isEnabled(o1.getPluginId());
                    boolean enabled2 = InstalledPluginsTableModel.this.isEnabled(o2.getPluginId());
                    if (enabled1 && !enabled2) {
                        return -1;
                    }
                    if (enabled2 && !enabled1) {
                        return 1;
                    }
                }
                return comparator2.compare((IdeaPluginDescriptor)o1, (IdeaPluginDescriptor)o2);
            };
        }
    }

    private class EnabledPluginInfo
    extends ColumnInfo<IdeaPluginDescriptor, Boolean> {
        EnabledPluginInfo() {
            super("");
        }

        public Boolean valueOf(IdeaPluginDescriptor ideaPluginDescriptor) {
            return (Boolean)InstalledPluginsTableModel.this.myEnabled.get(ideaPluginDescriptor.getPluginId());
        }

        public boolean isCellEditable(IdeaPluginDescriptor ideaPluginDescriptor) {
            return true;
        }

        public Class getColumnClass() {
            return Boolean.class;
        }

        public TableCellEditor getEditor(IdeaPluginDescriptor o) {
            return new BooleanTableCellEditor();
        }

        public TableCellRenderer getRenderer(IdeaPluginDescriptor ideaPluginDescriptor) {
            return new BooleanTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
                    return super.getTableCellRendererComponent(table, value == null ? Boolean.TRUE : value, isSelected, hasFocus, row2, column);
                }
            };
        }

        public void setValue(IdeaPluginDescriptor ideaPluginDescriptor, Boolean value) {
            PluginId currentPluginId = ideaPluginDescriptor.getPluginId();
            Boolean enabled = InstalledPluginsTableModel.this.myEnabled.get(currentPluginId) == null ? Boolean.FALSE : value;
            InstalledPluginsTableModel.this.myEnabled.put(currentPluginId, enabled);
            InstalledPluginsTableModel.this.updatePluginDependencies();
            InstalledPluginsTableModel.this.warnAboutMissedDependencies(enabled, new IdeaPluginDescriptor[]{ideaPluginDescriptor});
            InstalledPluginsTableModel.this.hideNotApplicablePlugins(value, new IdeaPluginDescriptor[]{ideaPluginDescriptor});
        }

        public Comparator<IdeaPluginDescriptor> getComparator() {
            return (o1, o2) -> {
                Boolean enabled1 = (Boolean)InstalledPluginsTableModel.this.myEnabled.get(o1.getPluginId());
                Boolean enabled2 = (Boolean)InstalledPluginsTableModel.this.myEnabled.get(o2.getPluginId());
                if (enabled1 != null && enabled1.booleanValue()) {
                    if (enabled2 != null && enabled2.booleanValue()) {
                        return 0;
                    }
                    return 1;
                }
                if (enabled2 == null || !enabled2.booleanValue()) {
                    return 0;
                }
                return -1;
            };
        }
    }
}

